/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.azure.loganalytics;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;

public abstract class AbstractAzureLogAnalyticsReportingTask
extends AbstractReportingTask {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String HMAC_SHA256_ALG = "HmacSHA256";
    private static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss O");
    static final PropertyDescriptor LOG_ANALYTICS_WORKSPACE_ID = new PropertyDescriptor.Builder().name("Log Analytics Workspace Id").description("Log Analytics Workspace Id").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    static final PropertyDescriptor LOG_ANALYTICS_WORKSPACE_KEY = new PropertyDescriptor.Builder().name("Log Analytics Workspace Key").description("Azure Log Analytic Worskspace Key").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    static final PropertyDescriptor APPLICATION_ID = new PropertyDescriptor.Builder().name("Application ID").description("The Application ID to be included in the metrics sent to Azure Log Analytics WS").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor INSTANCE_ID = new PropertyDescriptor.Builder().name("Instance ID").description("Id of this NiFi instance to be included in the metrics sent to Azure Log Analytics WS").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("${hostname(true)}").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor PROCESS_GROUP_IDS = new PropertyDescriptor.Builder().name("Process group ID(s)").description("If specified, the reporting task will send metrics the configured ProcessGroup(s) only. Multiple IDs should be separated by a comma. If none of the group-IDs could be found or no IDs are defined, the Root Process Group is used and global metrics are sent.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.createListValidator((boolean)true, (boolean)true, (Validator)StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("[0-9a-z-]+")))).build();
    static final PropertyDescriptor JOB_NAME = new PropertyDescriptor.Builder().name("Job Name").description("The name of the exporting job").defaultValue("nifi_reporting_job").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor LOG_ANALYTICS_URL_ENDPOINT_FORMAT = new PropertyDescriptor.Builder().name("Log Analytics URL Endpoint Format").description("Log Analytics URL Endpoint Format").required(false).defaultValue("https://{0}.ods.opinsights.azure.com/api/logs?api-version=2016-04-01").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(LOG_ANALYTICS_WORKSPACE_ID, LOG_ANALYTICS_WORKSPACE_KEY, APPLICATION_ID, INSTANCE_ID, PROCESS_GROUP_IDS, JOB_NAME, LOG_ANALYTICS_URL_ENDPOINT_FORMAT);

    protected String createAuthorization(String workspaceId, String key, int contentLength, String rfc1123Date) {
        try {
            String signature = String.format("POST\n%d\napplication/json\nx-ms-date:%s\n/api/logs", contentLength, rfc1123Date);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALG);
            mac.init(new SecretKeySpec(Base64.getDecoder().decode(key), HMAC_SHA256_ALG));
            String hmac = Base64.getEncoder().encodeToString(mac.doFinal(signature.getBytes(UTF8)));
            return String.format("SharedKey %s:%s", workspaceId, hmac);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected HttpPost getHttpPost(String urlFormat, String workspaceId, String logName) throws IllegalArgumentException {
        String dataCollectorEndpoint = MessageFormat.format(urlFormat, workspaceId);
        HttpPost post = new HttpPost(dataCollectorEndpoint);
        post.addHeader("Content-Type", "application/json");
        post.addHeader("Log-Type", logName);
        return post;
    }

    protected void sendToLogAnalytics(HttpPost request, String workspaceId, String linuxPrimaryKey, String rawJson) throws RuntimeException, IOException {
        int bodyLength = rawJson.getBytes(UTF8).length;
        ZonedDateTime zNow = ZonedDateTime.now(ZoneOffset.UTC);
        String nowRfc1123 = zNow.format(RFC_1123_DATE_TIME);
        String nowISO8601 = zNow.format(DateTimeFormatter.ISO_DATE_TIME);
        String createAuthorization = this.createAuthorization(workspaceId, linuxPrimaryKey, bodyLength, nowRfc1123);
        request.addHeader("Authorization", createAuthorization);
        request.addHeader("x-ms-date", nowRfc1123);
        request.addHeader("time-generated-field", nowISO8601);
        request.setEntity((HttpEntity)new StringEntity(rawJson));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            this.postRequest(httpClient, request);
        }
    }

    protected void postRequest(CloseableHttpClient httpClient, HttpPost request) throws IOException, RuntimeException {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            if (response != null && response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(response.getStatusLine().toString());
            }
        }
    }
}

