/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure;

import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.processors.azure.storage.utils.DataLakeServiceClientFactory;
import org.apache.nifi.services.azure.storage.ADLSCredentialsDetails;
import org.apache.nifi.services.azure.storage.ADLSCredentialsService;

public abstract class AbstractAzureDataLakeStorageProcessor
extends AbstractProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that have been successfully written to Azure storage are transferred to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that could not be written to Azure storage for some reason are transferred to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    public static final String TEMP_FILE_DIRECTORY = "_nifitempdirectory";
    private volatile DataLakeServiceClientFactory clientFactory;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientFactory = new DataLakeServiceClientFactory(this.getLogger(), AzureStorageUtils.getProxyOptions((PropertyContext)context));
    }

    @OnStopped
    public void onStopped() {
        this.clientFactory = null;
    }

    public DataLakeServiceClient getStorageClient(PropertyContext context, FlowFile flowFile) {
        Map attributes = flowFile != null ? flowFile.getAttributes() : Map.of();
        ADLSCredentialsService credentialsService = (ADLSCredentialsService)context.getProperty(AzureStorageUtils.ADLS_CREDENTIALS_SERVICE).asControllerService(ADLSCredentialsService.class);
        ADLSCredentialsDetails credentialsDetails = credentialsService.getCredentialsDetails(attributes);
        return (DataLakeServiceClient)this.clientFactory.getStorageClient(credentialsDetails);
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("adls-credentials-service", AzureStorageUtils.ADLS_CREDENTIALS_SERVICE.getName());
        ProxyServiceMigration.renameProxyConfigurationServiceProperty((PropertyConfiguration)config);
    }
}

