/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.processors.azure.storage.utils.BlobServiceClientFactory;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService_v12;

public abstract class AbstractAzureBlobProcessor_v12
extends AbstractProcessor {
    public static final String OLD_BLOB_NAME_PROPERTY_DESCRIPTOR_NAME = "blob-name";
    public static final PropertyDescriptor BLOB_NAME = new PropertyDescriptor.Builder().name("Blob Name").description("The full name of the blob").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All successfully processed FlowFiles are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Unsuccessful operations will be transferred to the failure relationship.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private volatile BlobServiceClientFactory clientFactory;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        ProxyServiceMigration.renameProxyConfigurationServiceProperty((PropertyConfiguration)config);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientFactory = new BlobServiceClientFactory(this.getLogger(), AzureStorageUtils.getProxyOptions((PropertyContext)context));
    }

    @OnStopped
    public void onStopped() {
        this.clientFactory = null;
    }

    protected BlobServiceClient getStorageClient(PropertyContext context, FlowFile flowFile) {
        return this.getStorageClient(context, AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE, flowFile);
    }

    protected BlobServiceClient getStorageClient(PropertyContext context, PropertyDescriptor storageCredentialsServiceProperty, FlowFile flowFile) {
        Map attributes = flowFile != null ? flowFile.getAttributes() : Collections.emptyMap();
        AzureStorageCredentialsService_v12 credentialsService = (AzureStorageCredentialsService_v12)context.getProperty(storageCredentialsServiceProperty).asControllerService(AzureStorageCredentialsService_v12.class);
        AzureStorageCredentialsDetails_v12 credentialsDetails = credentialsService.getCredentialsDetails(attributes);
        return (BlobServiceClient)this.clientFactory.getStorageClient(credentialsDetails);
    }

    protected Map<String, String> createBlobAttributesMap(BlobClient blobClient) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.applyStandardBlobAttributes(attributes, blobClient);
        this.applyBlobMetadata(attributes, blobClient);
        return attributes;
    }

    protected void applyStandardBlobAttributes(Map<String, String> attributes, BlobClient blobClient) {
        String primaryUri = blobClient.getBlobUrl().replace("%2F", "/");
        attributes.put("azure.container", blobClient.getContainerName());
        attributes.put("azure.blobname", blobClient.getBlobName());
        attributes.put("azure.primaryUri", primaryUri);
    }

    protected void applyBlobMetadata(Map<String, String> attributes, final BlobClient blobClient) {
        Supplier<BlobProperties> props = new Supplier<BlobProperties>(this){
            BlobProperties properties;

            @Override
            public BlobProperties get() {
                if (this.properties == null) {
                    this.properties = blobClient.getProperties();
                }
                return this.properties;
            }
        };
        attributes.computeIfAbsent("azure.etag", arg_0 -> AbstractAzureBlobProcessor_v12.lambda$applyBlobMetadata$0((Supplier)props, arg_0));
        attributes.computeIfAbsent("azure.blobtype", arg_0 -> AbstractAzureBlobProcessor_v12.lambda$applyBlobMetadata$1((Supplier)props, arg_0));
        attributes.computeIfAbsent("mime.type", arg_0 -> AbstractAzureBlobProcessor_v12.lambda$applyBlobMetadata$2((Supplier)props, arg_0));
        attributes.computeIfAbsent("azure.timestamp", arg_0 -> AbstractAzureBlobProcessor_v12.lambda$applyBlobMetadata$3((Supplier)props, arg_0));
        attributes.computeIfAbsent("azure.length", arg_0 -> AbstractAzureBlobProcessor_v12.lambda$applyBlobMetadata$4((Supplier)props, arg_0));
        if (!attributes.containsKey("lang")) {
            attributes.put("lang", ((BlobProperties)props.get()).getContentLanguage());
        }
    }

    private static /* synthetic */ String lambda$applyBlobMetadata$4(Supplier props, String key) {
        return String.valueOf(((BlobProperties)props.get()).getBlobSize());
    }

    private static /* synthetic */ String lambda$applyBlobMetadata$3(Supplier props, String key) {
        return String.valueOf(((BlobProperties)props.get()).getLastModified());
    }

    private static /* synthetic */ String lambda$applyBlobMetadata$2(Supplier props, String key) {
        return ((BlobProperties)props.get()).getContentType();
    }

    private static /* synthetic */ String lambda$applyBlobMetadata$1(Supplier props, String key) {
        return ((BlobProperties)props.get()).getBlobType().toString();
    }

    private static /* synthetic */ String lambda$applyBlobMetadata$0(Supplier props, String key) {
        return ((BlobProperties)props.get()).getETag();
    }
}

