/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.ADLSCredentialsDetails;
import org.apache.nifi.services.azure.storage.ADLSCredentialsService;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsType;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adls", "credentials"})
@CapabilityDescription(value="Defines credentials for ADLS processors.")
public class ADLSCredentialsControllerService
extends AbstractControllerService
implements ADLSCredentialsService {
    public static final PropertyDescriptor ACCOUNT_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ACCOUNT_NAME).description("The storage account name. There are certain risks in allowing the account name to be stored as a FlowFile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a FlowFile attribute, care must be taken to restrict access to the event provenance data (e.g., by strictly controlling the policies governing provenance for this processor). In addition, the provenance repositories may be put on encrypted disk partitions.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor ACCOUNT_KEY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ACCOUNT_KEY).description("The storage account key. This is an admin-like password providing access to every container in this account. It is recommended one uses Shared Access Signature (SAS) token, Managed Identity or Service Principal instead for fine-grained control with policies. There are certain risks in allowing the account key to be stored as a FlowFile attribute. While it does provide for a more flexible flow by allowing the account key to be fetched dynamically from a FlowFile attribute, care must be taken to restrict access to the event provenance data (e.g., by strictly controlling the policies governing provenance for this processor). In addition, the provenance repositories may be put on encrypted disk partitions.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor SAS_TOKEN = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.SAS_TOKEN).description("Shared Access Signature token (the leading '?' may be included) There are certain risks in allowing the SAS token to be stored as a FlowFile attribute. While it does provide for a more flexible flow by allowing the SAS token to be fetched dynamically from a FlowFile attribute, care must be taken to restrict access to the event provenance data (e.g., by strictly controlling the policies governing provenance for this processor). In addition, the provenance repositories may be put on encrypted disk partitions.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor ENDPOINT_SUFFIX = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ENDPOINT_SUFFIX).defaultValue("dfs.core.windows.net").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.PROXY_CONFIGURATION_SERVICE).dependsOn(AzureStorageUtils.CREDENTIALS_TYPE, (DescribedValue)AzureStorageCredentialsType.SERVICE_PRINCIPAL, new DescribedValue[]{AzureStorageCredentialsType.MANAGED_IDENTITY}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(ACCOUNT_NAME, ENDPOINT_SUFFIX, AzureStorageUtils.CREDENTIALS_TYPE, ACCOUNT_KEY, SAS_TOKEN, AzureStorageUtils.MANAGED_IDENTITY_CLIENT_ID, AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID, AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_ID, AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_SECRET, PROXY_CONFIGURATION_SERVICE);
    private ConfigurationContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("credentials-type", AzureStorageUtils.CREDENTIALS_TYPE.getName());
        config.renameProperty("storage-account-key", ACCOUNT_KEY.getName());
        config.renameProperty("storage-account-name", ACCOUNT_NAME.getName());
        config.renameProperty("storage-endpoint-suffix", ENDPOINT_SUFFIX.getName());
        config.renameProperty("storage-sas-token", SAS_TOKEN.getName());
        config.renameProperty("managed-identity-client-id", AzureStorageUtils.MANAGED_IDENTITY_CLIENT_ID.getName());
        config.renameProperty("service-principal-tenant-id", AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID.getName());
        config.renameProperty("service-principal-client-id", AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_ID.getName());
        config.renameProperty("service-principal-client-secret", AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_SECRET.getName());
        if (!config.hasProperty(AzureStorageUtils.CREDENTIALS_TYPE)) {
            String propNameUseManagedIdentity = "storage-use-managed-identity";
            if (config.isPropertySet(ACCOUNT_KEY)) {
                config.setProperty(AzureStorageUtils.CREDENTIALS_TYPE, AzureStorageCredentialsType.ACCOUNT_KEY.getValue());
            } else if (config.isPropertySet(SAS_TOKEN)) {
                config.setProperty(AzureStorageUtils.CREDENTIALS_TYPE, AzureStorageCredentialsType.SAS_TOKEN.getValue());
            } else if (config.isPropertySet(AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID)) {
                config.setProperty(AzureStorageUtils.CREDENTIALS_TYPE, AzureStorageCredentialsType.SERVICE_PRINCIPAL.getValue());
            } else {
                config.getPropertyValue("storage-use-managed-identity").ifPresent(value -> {
                    if ("true".equals(value)) {
                        config.setProperty(AzureStorageUtils.CREDENTIALS_TYPE, AzureStorageCredentialsType.MANAGED_IDENTITY.getValue());
                    }
                });
            }
            config.removeProperty("storage-use-managed-identity");
        }
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    public ADLSCredentialsDetails getCredentialsDetails(Map<String, String> attributes) {
        ADLSCredentialsDetails.Builder credentialsBuilder = ADLSCredentialsDetails.Builder.newBuilder();
        this.setValue(credentialsBuilder, ACCOUNT_NAME, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setAccountName, attributes);
        this.setValue(credentialsBuilder, ACCOUNT_KEY, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setAccountKey, attributes);
        this.setValue(credentialsBuilder, SAS_TOKEN, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setSasToken, attributes);
        this.setValue(credentialsBuilder, ENDPOINT_SUFFIX, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setEndpointSuffix, attributes);
        this.setValue(credentialsBuilder, AzureStorageUtils.CREDENTIALS_TYPE, property -> property.asAllowableValue(AzureStorageCredentialsType.class) == AzureStorageCredentialsType.MANAGED_IDENTITY, ADLSCredentialsDetails.Builder::setUseManagedIdentity, attributes);
        this.setValue(credentialsBuilder, AzureStorageUtils.MANAGED_IDENTITY_CLIENT_ID, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setManagedIdentityClientId, attributes);
        this.setValue(credentialsBuilder, AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setServicePrincipalTenantId, attributes);
        this.setValue(credentialsBuilder, AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_ID, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setServicePrincipalClientId, attributes);
        this.setValue(credentialsBuilder, AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_SECRET, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setServicePrincipalClientSecret, attributes);
        credentialsBuilder.setProxyOptions(AzureStorageUtils.getProxyOptions((PropertyContext)this.context));
        return credentialsBuilder.build();
    }

    private <T> void setValue(ADLSCredentialsDetails.Builder credentialsBuilder, PropertyDescriptor propertyDescriptor, Function<PropertyValue, T> getPropertyValue, BiConsumer<ADLSCredentialsDetails.Builder, T> setBuilderValue, Map<String, String> attributes) {
        PropertyValue property = this.context.getProperty(propertyDescriptor);
        if (property.isSet()) {
            if (propertyDescriptor.isExpressionLanguageSupported()) {
                property = propertyDescriptor.getExpressionLanguageScope() == ExpressionLanguageScope.FLOWFILE_ATTRIBUTES ? property.evaluateAttributeExpressions(attributes) : property.evaluateAttributeExpressions();
            }
            T value = getPropertyValue.apply(property);
            setBuilderValue.accept(credentialsBuilder, (ADLSCredentialsDetails.Builder)value);
        }
    }
}

