/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.data.explorer;

import com.microsoft.azure.kusto.data.ClientFactory;
import com.microsoft.azure.kusto.data.StreamingClient;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.services.azure.data.explorer.KustoAuthenticationStrategy;
import org.apache.nifi.services.azure.data.explorer.KustoQueryResponse;
import org.apache.nifi.services.azure.data.explorer.KustoQueryService;

@Tags(value={"Azure", "Data", "Explorer", "ADX", "Kusto"})
@CapabilityDescription(value="Standard implementation of Kusto Query Service for Azure Data Explorer")
public class StandardKustoQueryService
extends AbstractControllerService
implements KustoQueryService {
    public static final PropertyDescriptor CLUSTER_URI = new PropertyDescriptor.Builder().name("Cluster URI").description("Azure Data Explorer Cluster URI").required(true).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor AUTHENTICATION_STRATEGY = new PropertyDescriptor.Builder().name("Authentication Strategy").description("Authentication method for access to Azure Data Explorer").required(true).defaultValue((DescribedValue)KustoAuthenticationStrategy.MANAGED_IDENTITY).allowableValues(KustoAuthenticationStrategy.class).build();
    public static final PropertyDescriptor APPLICATION_CLIENT_ID = new PropertyDescriptor.Builder().name("Application Client ID").description("Azure Data Explorer Application Client Identifier for Authentication").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor APPLICATION_TENANT_ID = new PropertyDescriptor.Builder().name("Application Tenant ID").description("Azure Data Explorer Application Tenant Identifier for Authentication").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(AUTHENTICATION_STRATEGY, (DescribedValue)KustoAuthenticationStrategy.APPLICATION_CREDENTIALS, new DescribedValue[0]).build();
    public static final PropertyDescriptor APPLICATION_KEY = new PropertyDescriptor.Builder().name("Application Key").description("Azure Data Explorer Application Key for Authentication").required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(AUTHENTICATION_STRATEGY, (DescribedValue)KustoAuthenticationStrategy.APPLICATION_CREDENTIALS, new DescribedValue[0]).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CLUSTER_URI, AUTHENTICATION_STRATEGY, APPLICATION_CLIENT_ID, APPLICATION_TENANT_ID, APPLICATION_KEY);
    private volatile StreamingClient kustoClient;
    public static final Map<String, String> NIFI_SOURCE = Map.of("processor", "nifi-source");

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws ProcessException, URISyntaxException {
        if (this.kustoClient == null) {
            this.kustoClient = this.createClient(context);
        }
    }

    @OnStopped
    public final void onStopped() {
        if (this.kustoClient == null) {
            this.getLogger().debug("Kusto Client not configured");
        } else {
            this.kustoClient = null;
        }
    }

    public KustoQueryResponse executeQuery(String databaseName, String query) {
        KustoQueryResponse kustoQueryResponse;
        Objects.requireNonNull(databaseName, "Database Name required");
        Objects.requireNonNull(query, "Query required");
        try {
            InputStream responseStream = this.kustoClient.executeStreamingQuery(databaseName, query);
            kustoQueryResponse = new KustoQueryResponse(responseStream);
        }
        catch (Exception e) {
            this.getLogger().error("Kusto Query execution failed", (Throwable)e);
            kustoQueryResponse = new KustoQueryResponse(true, e.getMessage());
        }
        return kustoQueryResponse;
    }

    protected StreamingClient createClient(ConfigurationContext context) throws URISyntaxException {
        ConnectionStringBuilder connectionStringBuilder = this.getConnectionStringBuilder(context);
        return ClientFactory.createStreamingClient((ConnectionStringBuilder)connectionStringBuilder);
    }

    private ConnectionStringBuilder getConnectionStringBuilder(ConfigurationContext context) {
        String clusterUrl = context.getProperty(CLUSTER_URI).getValue();
        String clientId = context.getProperty(APPLICATION_CLIENT_ID).getValue();
        KustoAuthenticationStrategy kustoAuthenticationStrategy = (KustoAuthenticationStrategy)context.getProperty(AUTHENTICATION_STRATEGY).asAllowableValue(KustoAuthenticationStrategy.class);
        ConnectionStringBuilder builder = switch (kustoAuthenticationStrategy) {
            default -> throw new MatchException(null, null);
            case KustoAuthenticationStrategy.APPLICATION_CREDENTIALS -> {
                String applicationKey = context.getProperty(APPLICATION_KEY).getValue();
                String tenantId = context.getProperty(APPLICATION_TENANT_ID).getValue();
                yield ConnectionStringBuilder.createWithAadApplicationCredentials((String)clusterUrl, (String)clientId, (String)applicationKey, (String)tenantId);
            }
            case KustoAuthenticationStrategy.MANAGED_IDENTITY -> ConnectionStringBuilder.createWithAadManagedIdentity((String)clusterUrl, (String)clientId);
            case KustoAuthenticationStrategy.AZ_CLI_DEV_ONLY -> ConnectionStringBuilder.createWithAzureCli((String)clusterUrl);
        };
        builder.setConnectorDetails("Kusto.Nifi.Source", StandardKustoQueryService.class.getPackage().getImplementationVersion(), null, null, false, null, NIFI_SOURCE);
        return builder;
    }
}

