/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobItemProperties;
import com.azure.storage.blob.models.ListBlobsOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.azure.storage.AbstractListAzureProcessor;
import org.apache.nifi.processors.azure.storage.CopyAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.PutAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.processors.azure.storage.utils.BlobInfo;
import org.apache.nifi.processors.azure.storage.utils.BlobServiceClientFactory;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService_v12;

@PrimaryNodeOnly
@TriggerSerially
@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@SeeAlso(value={FetchAzureBlobStorage_v12.class, PutAzureBlobStorage_v12.class, DeleteAzureBlobStorage_v12.class, CopyAzureBlobStorage_v12.class})
@CapabilityDescription(value="Lists blobs in an Azure Blob Storage container. Listing details are attached to an empty FlowFile for use with FetchAzureBlobStorage. This Processor is designed to run on Primary Node only in a cluster. If the primary node changes, the new Primary Node will pick up where the previous node left off without duplicating all of the data. The processor uses Azure Blob Storage client library v12.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttributes(value={@WritesAttribute(attribute="azure.container", description="The name of the Azure Blob Storage container"), @WritesAttribute(attribute="azure.blobname", description="The name of the blob on Azure Blob Storage"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location of the blob"), @WritesAttribute(attribute="azure.etag", description="ETag of the blob"), @WritesAttribute(attribute="azure.blobtype", description="Type of the blob (either BlockBlob, PageBlob or AppendBlob)"), @WritesAttribute(attribute="mime.type", description="MIME Type of the content"), @WritesAttribute(attribute="lang", description="Language code for the content"), @WritesAttribute(attribute="azure.timestamp", description="Timestamp of the blob"), @WritesAttribute(attribute="azure.length", description="Length of the blob")})
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of blobs, the timestamp of the newest blob is stored if 'Tracking Timestamps' Listing Strategy is in use (by default). This allows the Processor to list only blobs that have been added or modified after this date the next time that the Processor is run. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node can pick up where the previous node left off, without duplicating the data.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListAzureBlobStorage_v12
extends AbstractListAzureProcessor<BlobInfo> {
    public static final PropertyDescriptor CONTAINER = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.CONTAINER).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor BLOB_NAME_PREFIX = new PropertyDescriptor.Builder().name("blob-name-prefix").displayName("Blob Name Prefix").description("Search prefix for listing").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).build();
    public static final PropertyDescriptor TRACKING_STATE_CACHE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_STATE_CACHE).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor TRACKING_TIME_WINDOW = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_TIME_WINDOW).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor INITIAL_LISTING_TARGET = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.INITIAL_LISTING_TARGET).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE, CONTAINER, BLOB_NAME_PREFIX, RECORD_WRITER, LISTING_STRATEGY, TRACKING_STATE_CACHE, TRACKING_TIME_WINDOW, INITIAL_LISTING_TARGET, MIN_AGE, MAX_AGE, MIN_SIZE, MAX_SIZE, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE);
    private volatile BlobServiceClientFactory clientFactory;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientFactory = new BlobServiceClientFactory(this.getLogger(), AzureStorageUtils.getProxyOptions((PropertyContext)context));
    }

    @OnStopped
    public void onStopped() {
        this.clientFactory = null;
    }

    protected String getPath(ProcessContext context) {
        return context.getProperty(CONTAINER).evaluateAttributeExpressions().getValue();
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected RecordSchema getRecordSchema() {
        return BlobInfo.getRecordSchema();
    }

    protected Integer countUnfilteredListing(ProcessContext context) throws IOException {
        return null;
    }

    protected String getListingContainerName(ProcessContext context) {
        return String.format("Azure Blob Storage Container [%s]", this.getPath(context));
    }

    protected String getDefaultTimePrecision() {
        return PRECISION_SECONDS.getValue();
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE.equals((Object)property) || CONTAINER.equals((Object)property) || BLOB_NAME_PREFIX.equals((Object)property) || LISTING_STRATEGY.equals((Object)property);
    }

    protected List<BlobInfo> performListing(ProcessContext context, Long minTimestamp, AbstractListProcessor.ListingMode listingMode) throws IOException {
        String containerName = context.getProperty(CONTAINER).evaluateAttributeExpressions().getValue();
        String prefix = context.getProperty(BLOB_NAME_PREFIX).evaluateAttributeExpressions().getValue();
        long minimumTimestamp = minTimestamp == null ? 0L : minTimestamp;
        try {
            ArrayList<BlobInfo> listing = new ArrayList<BlobInfo>();
            AzureStorageCredentialsService_v12 credentialsService = (AzureStorageCredentialsService_v12)context.getProperty(AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE).asControllerService(AzureStorageCredentialsService_v12.class);
            AzureStorageCredentialsDetails_v12 credentialsDetails = credentialsService.getCredentialsDetails(Collections.emptyMap());
            BlobServiceClient storageClient = (BlobServiceClient)this.clientFactory.getStorageClient(credentialsDetails);
            BlobContainerClient containerClient = storageClient.getBlobContainerClient(containerName);
            ListBlobsOptions options = new ListBlobsOptions().setPrefix(prefix);
            for (BlobItem blob : containerClient.listBlobs(options, null)) {
                BlobItemProperties properties = blob.getProperties();
                if (!this.isFileInfoMatchesWithAgeAndSize(context, minimumTimestamp, properties.getLastModified().toInstant().toEpochMilli(), properties.getContentLength())) continue;
                BlobInfo.Builder builder = new BlobInfo.Builder().containerName(containerName).blobName(blob.getName()).primaryUri(String.format("%s/%s", containerClient.getBlobContainerUrl(), blob.getName())).etag(properties.getETag()).blobType(properties.getBlobType().toString()).contentType(properties.getContentType()).contentLanguage(properties.getContentLanguage()).lastModifiedTime(properties.getLastModified().toInstant().toEpochMilli()).length(properties.getContentLength());
                listing.add(builder.build());
            }
            return listing;
        }
        catch (Throwable t) {
            throw new IOException(ExceptionUtils.getRootCause((Throwable)t));
        }
    }

    protected Map<String, String> createAttributes(BlobInfo entity, ProcessContext context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azure.container", entity.getContainerName());
        attributes.put("azure.blobname", entity.getBlobName());
        attributes.put("azure.primaryUri", entity.getPrimaryUri());
        attributes.put("azure.etag", entity.getEtag());
        attributes.put("azure.blobtype", entity.getBlobType());
        attributes.put("mime.type", entity.getContentType());
        attributes.put("lang", entity.getContentLanguage());
        attributes.put("azure.timestamp", String.valueOf(entity.getTimestamp()));
        attributes.put("azure.length", String.valueOf(entity.getLength()));
        attributes.put(CoreAttributes.FILENAME.key(), entity.getName());
        return attributes;
    }
}

