/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import com.azure.core.http.ProxyOptions;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService_v12;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsType;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob", "credentials", "queue"})
@CapabilityDescription(value="Provides credentials for Azure Storage processors using Azure Storage client library v12.")
public class AzureStorageCredentialsControllerService_v12
extends AbstractControllerService
implements AzureStorageCredentialsService_v12 {
    public static final PropertyDescriptor ENDPOINT_SUFFIX = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ENDPOINT_SUFFIX).defaultValue("blob.core.windows.net").build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.PROXY_CONFIGURATION_SERVICE).dependsOn(AzureStorageUtils.CREDENTIALS_TYPE, (DescribedValue)AzureStorageCredentialsType.SERVICE_PRINCIPAL, new DescribedValue[]{AzureStorageCredentialsType.MANAGED_IDENTITY}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(AzureStorageUtils.ACCOUNT_NAME, ENDPOINT_SUFFIX, AzureStorageUtils.CREDENTIALS_TYPE, AzureStorageUtils.ACCOUNT_KEY, AzureStorageUtils.SAS_TOKEN, AzureStorageUtils.MANAGED_IDENTITY_CLIENT_ID, AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID, AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_ID, AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_SECRET, PROXY_CONFIGURATION_SERVICE);
    private ConfigurationContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    public AzureStorageCredentialsDetails_v12 getCredentialsDetails(Map<String, String> attributes) {
        String accountName = this.context.getProperty(AzureStorageUtils.ACCOUNT_NAME).getValue();
        String endpointSuffix = this.context.getProperty(ENDPOINT_SUFFIX).getValue();
        AzureStorageCredentialsType credentialsType = (AzureStorageCredentialsType)this.context.getProperty(AzureStorageUtils.CREDENTIALS_TYPE).asAllowableValue(AzureStorageCredentialsType.class);
        ProxyOptions proxyOptions = AzureStorageUtils.getProxyOptions((PropertyContext)this.context);
        switch (credentialsType) {
            case ACCOUNT_KEY: {
                String accountKey = this.context.getProperty(AzureStorageUtils.ACCOUNT_KEY).getValue();
                return AzureStorageCredentialsDetails_v12.createWithAccountKey((String)accountName, (String)endpointSuffix, (String)accountKey);
            }
            case SAS_TOKEN: {
                String sasToken = this.context.getProperty(AzureStorageUtils.SAS_TOKEN).getValue();
                return AzureStorageCredentialsDetails_v12.createWithSasToken((String)accountName, (String)endpointSuffix, (String)sasToken);
            }
            case MANAGED_IDENTITY: {
                String managedIdentityClientId = this.context.getProperty(AzureStorageUtils.MANAGED_IDENTITY_CLIENT_ID).getValue();
                return AzureStorageCredentialsDetails_v12.createWithManagedIdentity((String)accountName, (String)endpointSuffix, (String)managedIdentityClientId, (ProxyOptions)proxyOptions);
            }
            case SERVICE_PRINCIPAL: {
                String servicePrincipalTenantId = this.context.getProperty(AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID).getValue();
                String servicePrincipalClientId = this.context.getProperty(AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_ID).getValue();
                String servicePrincipalClientSecret = this.context.getProperty(AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_SECRET).getValue();
                return AzureStorageCredentialsDetails_v12.createWithServicePrincipal((String)accountName, (String)endpointSuffix, (String)servicePrincipalTenantId, (String)servicePrincipalClientId, (String)servicePrincipalClientSecret, (ProxyOptions)proxyOptions);
            }
        }
        throw new IllegalArgumentException("Unhandled credentials type: " + String.valueOf(credentialsType));
    }
}

