/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.s3.AmazonS3EncryptionService;
import org.apache.nifi.processors.aws.s3.encryption.ClientSideCEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ClientSideKMSEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.NoOpEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionKeySpec;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ServerSideCEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ServerSideKMSEncryptionStrategy;
import org.apache.nifi.processors.aws.s3.encryption.ServerSideS3EncryptionStrategy;
import org.apache.nifi.reporting.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.encryption.s3.S3EncryptionClient;

@Tags(value={"service", "aws", "s3", "encryption", "encrypt", "decryption", "decrypt", "key"})
@CapabilityDescription(value="Adds configurable encryption to S3 Put and S3 Fetch operations.")
public class StandardS3EncryptionService
extends AbstractControllerService
implements AmazonS3EncryptionService {
    private static final Logger logger = LoggerFactory.getLogger(StandardS3EncryptionService.class);
    private static final String OBSOLETE_ENCRYPTION_VALUE_1 = "key-id-or-key-material";
    private static final String OBSOLETE_ENCRYPTION_VALUE_2 = "Key ID or Key Material";
    private static final String OBSOLETE_KMS_REGION_1 = "kms-region";
    private static final String OBSOLETE_KMS_REGION_2 = "KMS Region";
    private static final Map<String, S3EncryptionStrategy> NAMED_STRATEGIES = Map.of("NONE", new NoOpEncryptionStrategy(), "SSE_S3", new ServerSideS3EncryptionStrategy(), "SSE_KMS", new ServerSideKMSEncryptionStrategy(), "SSE_C", new ServerSideCEncryptionStrategy(), "CSE_KMS", new ClientSideKMSEncryptionStrategy(), "CSE_C", new ClientSideCEncryptionStrategy());
    private static final AllowableValue NONE = new AllowableValue("NONE", "None", "No encryption.");
    private static final AllowableValue SSE_S3 = new AllowableValue("SSE_S3", "Server-side S3", "Use server-side, S3-managed encryption.");
    private static final AllowableValue SSE_KMS = new AllowableValue("SSE_KMS", "Server-side KMS", "Use server-side, KMS key to perform encryption.");
    private static final AllowableValue SSE_C = new AllowableValue("SSE_C", "Server-side Customer Key", "Use server-side, customer-supplied key to perform encryption.");
    private static final AllowableValue CSE_KMS = new AllowableValue("CSE_KMS", "Client-side KMS", "Use client-side, KMS key to perform encryption.");
    private static final AllowableValue CSE_C = new AllowableValue("CSE_C", "Client-side Customer Key", "Use client-side, customer-supplied key to perform encryption.");
    public static final Map<String, AllowableValue> ENCRYPTION_STRATEGY_ALLOWABLE_VALUES = Map.of("NONE", NONE, "SSE_S3", SSE_S3, "SSE_KMS", SSE_KMS, "SSE_C", SSE_C, "CSE_KMS", CSE_KMS, "CSE_C", CSE_C);
    public static final PropertyDescriptor ENCRYPTION_STRATEGY = new PropertyDescriptor.Builder().name("Encryption Strategy").description("Strategy to use for S3 data encryption and decryption.").allowableValues(new DescribedValue[]{NONE, SSE_S3, SSE_KMS, SSE_C, CSE_KMS, CSE_C}).required(true).defaultValue(NONE.getValue()).build();
    public static final PropertyDescriptor KMS_KEY_ID = new PropertyDescriptor.Builder().name("KMS Key ID").description("The ID (ARN) of the KMS key used for Server-side or Client-side KMS encryption.").required(true).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(ENCRYPTION_STRATEGY, new AllowableValue[]{SSE_KMS, CSE_KMS}).build();
    public static final PropertyDescriptor KEY_MATERIAL = new PropertyDescriptor.Builder().name("Key Material").description("The key material used for Server-side or Client-side Customer Key encryption. The Key Material must be specified in Base64 encoded form. In case of Server-side Customer Key, the key must be an AES-256 key. In case of Client-side Customer Key, it can be an AES-256, AES-192 or AES-128 key.").required(true).sensitive(true).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(ENCRYPTION_STRATEGY, new AllowableValue[]{SSE_C, CSE_C}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(ENCRYPTION_STRATEGY, KMS_KEY_ID, KEY_MATERIAL);
    private S3EncryptionKeySpec keySpec;
    private S3EncryptionStrategy encryptionStrategy = new NoOpEncryptionStrategy();
    private String strategyName = "NONE";

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        String newStrategyName = context.getProperty(ENCRYPTION_STRATEGY).getValue();
        S3EncryptionStrategy newEncryptionStrategy = NAMED_STRATEGIES.get(newStrategyName);
        if (newEncryptionStrategy == null) {
            String msg = "No encryption strategy found for name: " + this.strategyName;
            logger.warn(msg);
            throw new InitializationException(msg);
        }
        this.strategyName = newStrategyName;
        this.encryptionStrategy = newEncryptionStrategy;
        this.keySpec = this.createKeySpec((PropertyContext)context, newStrategyName);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        String encryptionStrategyName = validationContext.getProperty(ENCRYPTION_STRATEGY).getValue();
        S3EncryptionStrategy encryptionStrategy = NAMED_STRATEGIES.get(encryptionStrategyName);
        S3EncryptionKeySpec keySpec = this.createKeySpec((PropertyContext)validationContext, encryptionStrategyName);
        validationResults.add(encryptionStrategy.validateKeySpec(keySpec));
        return validationResults;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("encryption-strategy", ENCRYPTION_STRATEGY.getName());
        this.migrateEncryptionValue(config);
        config.removeProperty(OBSOLETE_KMS_REGION_1);
        config.removeProperty(OBSOLETE_KMS_REGION_2);
    }

    private void migrateEncryptionValue(PropertyConfiguration config) {
        String propertyName = config.hasProperty(OBSOLETE_ENCRYPTION_VALUE_1) ? OBSOLETE_ENCRYPTION_VALUE_1 : (config.hasProperty(OBSOLETE_ENCRYPTION_VALUE_2) ? OBSOLETE_ENCRYPTION_VALUE_2 : null);
        if (propertyName != null) {
            config.getPropertyValue(propertyName).ifPresent(encryptionValue -> {
                String strategyName;
                switch (strategyName = config.getPropertyValue(ENCRYPTION_STRATEGY).orElse("NONE")) {
                    case "SSE_KMS": 
                    case "CSE_KMS": {
                        config.setProperty(KMS_KEY_ID, encryptionValue);
                        break;
                    }
                    case "SSE_C": 
                    case "CSE_C": {
                        config.setProperty(KEY_MATERIAL, encryptionValue);
                    }
                }
            });
            config.removeProperty(propertyName);
        }
    }

    public void configurePutObjectRequest(PutObjectRequest.Builder requestBuilder) {
        this.encryptionStrategy.configurePutObjectRequest(requestBuilder, this.keySpec);
    }

    public void configureCreateMultipartUploadRequest(CreateMultipartUploadRequest.Builder requestBuilder) {
        this.encryptionStrategy.configureCreateMultipartUploadRequest(requestBuilder, this.keySpec);
    }

    public void configureGetObjectRequest(GetObjectRequest.Builder requestBuilder) {
        this.encryptionStrategy.configureGetObjectRequest(requestBuilder, this.keySpec);
    }

    public void configureUploadPartRequest(UploadPartRequest.Builder requestBuilder) {
        this.encryptionStrategy.configureUploadPartRequest(requestBuilder, this.keySpec);
    }

    public S3EncryptionClient.Builder createEncryptionClientBuilder() {
        return this.encryptionStrategy.createEncryptionClientBuilder(this.keySpec);
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public String getStrategyDisplayName() {
        return ENCRYPTION_STRATEGY_ALLOWABLE_VALUES.get(this.strategyName).getDisplayName();
    }

    private S3EncryptionKeySpec createKeySpec(PropertyContext context, String encryptionStrategyName) {
        switch (encryptionStrategyName) {
            case "NONE": 
            case "SSE_S3": {
                return new S3EncryptionKeySpec(null, null, null);
            }
            case "SSE_KMS": 
            case "CSE_KMS": {
                String kmsKeyId = context.getProperty(KMS_KEY_ID).evaluateAttributeExpressions().getValue();
                return new S3EncryptionKeySpec(kmsKeyId, null, null);
            }
            case "SSE_C": 
            case "CSE_C": {
                String keyMaterialMd5;
                String keyMaterial = context.getProperty(KEY_MATERIAL).evaluateAttributeExpressions().getValue();
                try {
                    keyMaterialMd5 = Base64.getEncoder().encodeToString(MessageDigest.getInstance("MD5").digest(Base64.getDecoder().decode(keyMaterial)));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ProcessException("Failed to calculate MD5 hash for Key Material", (Throwable)e);
                }
                return new S3EncryptionKeySpec(null, keyMaterial, keyMaterialMd5);
            }
        }
        throw new IllegalArgumentException("Unknown encryption strategy: " + encryptionStrategyName);
    }
}

