/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionKeySpec;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class ServerSideCEncryptionStrategy
implements S3EncryptionStrategy {
    private static final String SSE_CUSTOMER_ALGORITHM = "AES256";

    @Override
    public void configurePutObjectRequest(PutObjectRequest.Builder requestBuilder, S3EncryptionKeySpec keySpec) {
        requestBuilder.sseCustomerAlgorithm(SSE_CUSTOMER_ALGORITHM);
        requestBuilder.sseCustomerKey(keySpec.material());
        requestBuilder.sseCustomerKeyMD5(keySpec.md5());
    }

    @Override
    public void configureCreateMultipartUploadRequest(CreateMultipartUploadRequest.Builder requestBuilder, S3EncryptionKeySpec keySpec) {
        requestBuilder.sseCustomerAlgorithm(SSE_CUSTOMER_ALGORITHM);
        requestBuilder.sseCustomerKey(keySpec.material());
        requestBuilder.sseCustomerKeyMD5(keySpec.md5());
    }

    @Override
    public void configureGetObjectRequest(GetObjectRequest.Builder requestBuilder, S3EncryptionKeySpec keySpec) {
        requestBuilder.sseCustomerAlgorithm(SSE_CUSTOMER_ALGORITHM);
        requestBuilder.sseCustomerKey(keySpec.material());
        requestBuilder.sseCustomerKeyMD5(keySpec.md5());
    }

    @Override
    public void configureUploadPartRequest(UploadPartRequest.Builder requestBuilder, S3EncryptionKeySpec keySpec) {
        requestBuilder.sseCustomerAlgorithm(SSE_CUSTOMER_ALGORITHM);
        requestBuilder.sseCustomerKey(keySpec.material());
        requestBuilder.sseCustomerKeyMD5(keySpec.md5());
    }

    @Override
    public ValidationResult validateKeySpec(S3EncryptionKeySpec keySpec) {
        byte[] keyMaterial;
        if (StringUtils.isBlank((CharSequence)keySpec.material())) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is empty").build();
        }
        try {
            if (!Base64.isBase64((String)keySpec.material())) {
                throw new Exception();
            }
            keyMaterial = Base64.decodeBase64((String)keySpec.material());
        }
        catch (Exception e) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not in Base64 encoded form").build();
        }
        if (keyMaterial.length != 32) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not a Base64 encoded AES-256 key").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }
}

