/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.GetS3ObjectMetadata;
import org.apache.nifi.processors.aws.s3.GetS3ObjectTags;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.PutS3Object;
import org.apache.nifi.processors.aws.s3.TagS3Object;
import org.apache.nifi.processors.aws.s3.util.S3Util;
import org.apache.nifi.util.StringUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;

@Tags(value={"Amazon", "S3", "AWS", "Archive", "Copy"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Copies a file from one bucket and key to another in AWS S3")
@SeeAlso(value={PutS3Object.class, DeleteS3Object.class, ListS3.class, TagS3Object.class, DeleteS3Object.class, FetchS3Object.class, GetS3ObjectMetadata.class, GetS3ObjectTags.class})
public class CopyS3Object
extends AbstractS3Processor {
    public static final long MULTIPART_THRESHOLD = 0x140000000L;
    static final PropertyDescriptor SOURCE_BUCKET = new PropertyDescriptor.Builder().fromPropertyDescriptor(BUCKET_WITH_DEFAULT_VALUE).name("Source Bucket").description("The bucket that contains the file to be copied.").build();
    static final PropertyDescriptor SOURCE_KEY = new PropertyDescriptor.Builder().fromPropertyDescriptor(KEY).name("Source Key").description("The source key in the source bucket").build();
    static final PropertyDescriptor DESTINATION_BUCKET = new PropertyDescriptor.Builder().fromPropertyDescriptor(BUCKET_WITHOUT_DEFAULT_VALUE).name("Destination Bucket").description("The bucket that will receive the copy.").build();
    static final PropertyDescriptor DESTINATION_KEY = new PropertyDescriptor.Builder().fromPropertyDescriptor(KEY).name("Destination Key").description("The target key in the target bucket").defaultValue("${filename}-1").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SOURCE_BUCKET, SOURCE_KEY, DESTINATION_BUCKET, DESTINATION_KEY, AWS_CREDENTIALS_PROVIDER_SERVICE, RegionUtil.REGION, RegionUtil.CUSTOM_REGION_WITH_FF_EL, TIMEOUT, FULL_CONTROL_USER_LIST, READ_USER_LIST, READ_ACL_LIST, WRITE_ACL_LIST, CANNED_ACL, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.removeProperty("Write Permission User List");
        config.removeProperty("Owner");
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        S3Client client;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            client = (S3Client)this.getClient(context, flowFile.getAttributes());
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize S3 client", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        String sourceBucket = context.getProperty(SOURCE_BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        String sourceKey = context.getProperty(SOURCE_KEY).evaluateAttributeExpressions(flowFile).getValue();
        String destinationBucket = context.getProperty(DESTINATION_BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        String destinationKey = context.getProperty(DESTINATION_KEY).evaluateAttributeExpressions(flowFile).getValue();
        AtomicReference<String> multipartIdRef = new AtomicReference<String>();
        boolean multipartUploadRequired = false;
        try {
            HeadObjectRequest sourceMetadataRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(sourceBucket).key(sourceKey).build();
            HeadObjectResponse sourceMetadataResponse = client.headObject(sourceMetadataRequest);
            long contentLength = sourceMetadataResponse.contentLength();
            boolean bl = multipartUploadRequired = contentLength > 0x140000000L;
            if (multipartUploadRequired) {
                this.copyMultipart(client, context, flowFile, sourceBucket, sourceKey, destinationBucket, destinationKey, multipartIdRef, contentLength);
            } else {
                this.copyObject(client, context, flowFile, sourceBucket, sourceKey, destinationBucket, destinationKey);
            }
            session.getProvenanceReporter().send(flowFile, this.getTransitUrl(destinationBucket, destinationKey));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            if (multipartUploadRequired && StringUtils.isNotEmpty((String)((String)multipartIdRef.get()))) {
                try {
                    AbortMultipartUploadRequest abortRequest = (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(destinationBucket).key(destinationKey).uploadId((String)multipartIdRef.get()).build();
                    client.abortMultipartUpload(abortRequest);
                }
                catch (S3Exception s3e) {
                    this.getLogger().warn("Abort Multipart Upload failed for Bucket [{}] Key [{}]", new Object[]{destinationBucket, destinationKey, s3e});
                }
            }
            flowFile = this.extractExceptionDetails(e, session, flowFile);
            this.getLogger().error("Failed to copy S3 object from Bucket [{}] Key [{}]", new Object[]{sourceBucket, sourceKey, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void copyMultipart(S3Client client, ProcessContext context, FlowFile flowFile, String sourceBucket, String sourceKey, String destinationBucket, String destinationKey, AtomicReference<String> multipartIdRef, long contentLength) {
        CreateMultipartUploadRequest createRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(destinationBucket).key(destinationKey).grantFullControl(this.getFullControlGranteeSpec((PropertyContext)context, flowFile)).grantRead(this.getReadGranteeSpec((PropertyContext)context, flowFile)).grantReadACP(this.getReadACPGranteeSpec((PropertyContext)context, flowFile)).grantWriteACP(this.getWriteACPGranteeSpec((PropertyContext)context, flowFile)).acl(this.createCannedACL(context, flowFile)).build();
        CreateMultipartUploadResponse createResponse = client.createMultipartUpload(createRequest);
        multipartIdRef.set(createResponse.uploadId());
        int partNumber = 1;
        ArrayList copyResponses = new ArrayList();
        for (long bytePosition = 0L; bytePosition < contentLength; bytePosition += 0x140000000L) {
            long lastByte = Math.min(bytePosition + 0x140000000L - 1L, contentLength - 1L);
            UploadPartCopyRequest copyRequest = (UploadPartCopyRequest)UploadPartCopyRequest.builder().sourceBucket(sourceBucket).sourceKey(sourceKey).destinationBucket(destinationBucket).destinationKey(destinationKey).uploadId(createResponse.uploadId()).copySourceRange(S3Util.createRangeSpec(bytePosition, lastByte)).partNumber(Integer.valueOf(partNumber++)).build();
            this.doRetryLoop(request -> copyResponses.add(client.uploadPartCopy((UploadPartCopyRequest)request)), (SdkRequest)copyRequest);
        }
        List<CompletedPart> completedParts = IntStream.range(0, copyResponses.size()).mapToObj(i -> (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(i + 1)).eTag(((UploadPartCopyResponse)copyResponses.get(i)).copyPartResult().eTag()).build()).toList();
        CompleteMultipartUploadRequest completeRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(destinationBucket).key(destinationKey).uploadId(createResponse.uploadId()).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build()).build();
        this.doRetryLoop(complete -> client.completeMultipartUpload(completeRequest), (SdkRequest)completeRequest);
    }

    private void doRetryLoop(Consumer<SdkRequest> consumer, SdkRequest request) {
        boolean requestComplete = false;
        int retryIndex = 0;
        while (!requestComplete) {
            try {
                consumer.accept(request);
                requestComplete = true;
            }
            catch (S3Exception e) {
                if (e.statusCode() == 503 && retryIndex < 3) {
                    ++retryIndex;
                    continue;
                }
                throw e;
            }
        }
    }

    private void copyObject(S3Client client, ProcessContext context, FlowFile flowFile, String sourceBucket, String sourceKey, String destinationBucket, String destinationKey) {
        CopyObjectRequest request = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(sourceBucket).sourceKey(sourceKey).destinationBucket(destinationBucket).destinationKey(destinationKey).grantFullControl(this.getFullControlGranteeSpec((PropertyContext)context, flowFile)).grantRead(this.getReadGranteeSpec((PropertyContext)context, flowFile)).grantReadACP(this.getReadACPGranteeSpec((PropertyContext)context, flowFile)).grantWriteACP(this.getWriteACPGranteeSpec((PropertyContext)context, flowFile)).acl(this.createCannedACL(context, flowFile)).build();
        client.copyObject(request);
    }

    private String getTransitUrl(String destinationBucket, String destinationKey) {
        String spacer = destinationKey.startsWith("/") ? "" : "/";
        return String.format("s3://%s%s%s", destinationBucket, spacer, destinationKey);
    }
}

