/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.transcribe;

import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.transcribe.GetAwsTranscribeJobStatus;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.TranscribeClientBuilder;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Transcribe"})
@CapabilityDescription(value="Trigger a AWS Transcribe job. It should be followed by GetAwsTranscribeStatus processor in order to monitor job status.")
@WritesAttributes(value={@WritesAttribute(attribute="awsTaskId", description="The task ID that can be used to poll for Job completion in GetAwsTranscribeJobStatus")})
@SeeAlso(value={GetAwsTranscribeJobStatus.class})
public class StartAwsTranscribeJob
extends AbstractAwsMachineLearningJobStarter<StartTranscriptionJobRequest, StartTranscriptionJobRequest.Builder, StartTranscriptionJobResponse, TranscribeClient, TranscribeClientBuilder> {
    protected TranscribeClientBuilder createClientBuilder(ProcessContext context) {
        return TranscribeClient.builder();
    }

    protected StartTranscriptionJobResponse sendRequest(StartTranscriptionJobRequest request, ProcessContext context, FlowFile flowFile) {
        return ((TranscribeClient)this.getClient(context)).startTranscriptionJob(request);
    }

    protected Class<? extends StartTranscriptionJobRequest.Builder> getAwsRequestBuilderClass(ProcessContext context, FlowFile flowFile) {
        return StartTranscriptionJobRequest.serializableBuilderClass();
    }

    protected String getAwsTaskId(ProcessContext context, StartTranscriptionJobResponse startTranscriptionJobResponse, FlowFile flowFile) {
        return startTranscriptionJobResponse.transcriptionJob().transcriptionJobName();
    }
}

