/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.polly;

import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.polly.GetAwsPollyJobStatus;
import software.amazon.awssdk.services.polly.PollyClient;
import software.amazon.awssdk.services.polly.PollyClientBuilder;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskResponse;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Polly"})
@CapabilityDescription(value="Trigger a AWS Polly job. It should be followed by GetAwsPollyJobStatus processor in order to monitor job status.")
@WritesAttributes(value={@WritesAttribute(attribute="awsTaskId", description="The task ID that can be used to poll for Job completion in GetAwsPollyJobStatus")})
@SeeAlso(value={GetAwsPollyJobStatus.class})
public class StartAwsPollyJob
extends AbstractAwsMachineLearningJobStarter<StartSpeechSynthesisTaskRequest, StartSpeechSynthesisTaskRequest.Builder, StartSpeechSynthesisTaskResponse, PollyClient, PollyClientBuilder> {
    protected PollyClientBuilder createClientBuilder(ProcessContext context) {
        return PollyClient.builder();
    }

    protected StartSpeechSynthesisTaskResponse sendRequest(StartSpeechSynthesisTaskRequest request, ProcessContext context, FlowFile flowFile) {
        return ((PollyClient)this.getClient(context)).startSpeechSynthesisTask(request);
    }

    protected Class<? extends StartSpeechSynthesisTaskRequest.Builder> getAwsRequestBuilderClass(ProcessContext context, FlowFile flowFile) {
        return StartSpeechSynthesisTaskRequest.serializableBuilderClass();
    }

    protected String getAwsTaskId(ProcessContext context, StartSpeechSynthesisTaskResponse startSpeechSynthesisTaskResponse, FlowFile flowFile) {
        return startSpeechSynthesisTaskResponse.synthesisTask().taskId();
    }
}

