/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.polly;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.ml.polly.StartAwsPollyJob;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.polly.PollyClient;
import software.amazon.awssdk.services.polly.PollyClientBuilder;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.TaskStatus;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Polly"})
@CapabilityDescription(value="Retrieves the current status of an AWS Polly job.")
@SeeAlso(value={StartAwsPollyJob.class})
@WritesAttributes(value={@WritesAttribute(attribute="PollyS3OutputBucket", description="The bucket name where polly output will be located."), @WritesAttribute(attribute="filename", description="Object key of polly output."), @WritesAttribute(attribute="outputLocation", description="S3 path-style output location of the result.")})
public class GetAwsPollyJobStatus
extends AbstractAwsMachineLearningJobStatusProcessor<PollyClient, PollyClientBuilder> {
    private static final String BUCKET = "bucket";
    private static final String KEY = "key";
    private static final Pattern S3_PATH = Pattern.compile("https://s3.*amazonaws.com/(?<bucket>[^/]+)/(?<key>.*)");
    private static final String AWS_S3_BUCKET = "PollyS3OutputBucket";
    private static final String AWS_S3_KEY = "filename";

    public Set<Relationship> getRelationships() {
        HashSet parentRelationships = new HashSet(super.getRelationships());
        parentRelationships.remove(REL_THROTTLED);
        return Set.copyOf(parentRelationships);
    }

    protected PollyClientBuilder createClientBuilder(ProcessContext context) {
        return PollyClient.builder();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        GetSpeechSynthesisTaskResponse speechSynthesisTask;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            speechSynthesisTask = this.getSynthesisTask(context, flowFile);
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to get Polly Job status", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        TaskStatus taskStatus = speechSynthesisTask.synthesisTask().taskStatus();
        if (taskStatus == TaskStatus.IN_PROGRESS || taskStatus == TaskStatus.SCHEDULED) {
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_RUNNING);
        } else if (taskStatus == TaskStatus.COMPLETED) {
            String outputUri = speechSynthesisTask.synthesisTask().outputUri();
            Matcher matcher = S3_PATH.matcher(outputUri);
            if (matcher.find()) {
                flowFile = session.putAttribute(flowFile, AWS_S3_BUCKET, matcher.group(BUCKET));
                flowFile = session.putAttribute(flowFile, AWS_S3_KEY, matcher.group(KEY));
            }
            FlowFile childFlowFile = session.create(flowFile);
            childFlowFile = this.writeToFlowFile(session, childFlowFile, (AwsResponse)speechSynthesisTask);
            childFlowFile = session.putAttribute(childFlowFile, "outputLocation", outputUri);
            session.transfer(flowFile, REL_ORIGINAL);
            session.transfer(childFlowFile, REL_SUCCESS);
            this.getLogger().info("Amazon Polly Task Completed {}", new Object[]{flowFile});
        } else if (taskStatus == TaskStatus.FAILED) {
            String failureReason = speechSynthesisTask.synthesisTask().taskStatusReason();
            flowFile = session.putAttribute(flowFile, "failure.reason", failureReason);
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().error("Amazon Polly Task Failed {} Reason [{}]", new Object[]{flowFile, failureReason});
        } else if (taskStatus == TaskStatus.UNKNOWN_TO_SDK_VERSION) {
            flowFile = session.putAttribute(flowFile, "failure.reason", "Unrecognized job status");
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().error("Amazon Polly Task Failed {} Reason [Unrecognized job status]", new Object[]{flowFile});
        }
    }

    private GetSpeechSynthesisTaskResponse getSynthesisTask(ProcessContext context, FlowFile flowFile) {
        String taskId = context.getProperty(TASK_ID).evaluateAttributeExpressions(flowFile).getValue();
        GetSpeechSynthesisTaskRequest request = (GetSpeechSynthesisTaskRequest)GetSpeechSynthesisTaskRequest.builder().taskId(taskId).build();
        return ((PollyClient)this.getClient(context)).getSpeechSynthesisTask(request);
    }
}

