/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream.record;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.nifi.processors.aws.kinesis.property.SchemaDifferenceHandlingStrategy;
import org.apache.nifi.processors.aws.kinesis.stream.record.AbstractKinesisRecordProcessor;
import org.apache.nifi.processors.aws.kinesis.stream.record.KinesisRecordProcessorRecord;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

class StateHandlerStrategy {
    private final SchemaDifferenceHandlingStrategy strategy;
    private final StateInitializerAction stateInitializerAction;
    private final StateFinalizerAction stateFinalizerAction;
    private final Map<RecordSchema, KinesisRecordProcessorRecord.FlowFileState> activeStateMap = new HashMap<RecordSchema, KinesisRecordProcessorRecord.FlowFileState>();

    StateHandlerStrategy(SchemaDifferenceHandlingStrategy strategy, StateInitializerAction stateInitializerAction, StateFinalizerAction stateFinalizerAction) {
        this.strategy = strategy;
        this.stateInitializerAction = stateInitializerAction;
        this.stateFinalizerAction = stateFinalizerAction;
    }

    KinesisRecordProcessorRecord.FlowFileState getOrCreate(Record record, AbstractKinesisRecordProcessor.BatchProcessingContext flowFileContext) throws KinesisRecordProcessorRecord.FlowFileCompletionException, IOException, SchemaNotFoundException {
        KinesisRecordProcessorRecord.FlowFileState previousState = this.activeStateMap.get(record.getSchema());
        if (previousState != null) {
            return previousState;
        }
        if (this.strategy == SchemaDifferenceHandlingStrategy.CREATE_FLOW_FILE) {
            this.completeAllAvailableFlowFileStates(flowFileContext);
        }
        return this.create(record, flowFileContext);
    }

    private void completeAllAvailableFlowFileStates(AbstractKinesisRecordProcessor.BatchProcessingContext flowFileContext) throws KinesisRecordProcessorRecord.FlowFileCompletionException {
        KinesisRecordProcessorRecord.FlowFileState previousStateForDifferentSchema;
        while ((previousStateForDifferentSchema = this.pop()) != null) {
            this.stateFinalizerAction.complete(previousStateForDifferentSchema, flowFileContext);
        }
    }

    KinesisRecordProcessorRecord.FlowFileState create(Record record, AbstractKinesisRecordProcessor.BatchProcessingContext flowFileContext) throws IOException, SchemaNotFoundException {
        KinesisRecordProcessorRecord.FlowFileState previousState = this.activeStateMap.get(record.getSchema());
        if (previousState != null) {
            throw new IllegalStateException("FlowFile state already exists for schema: " + String.valueOf(record.getSchema()) + ". This should not happen in a batch processing context.");
        }
        if (this.strategy == SchemaDifferenceHandlingStrategy.CREATE_FLOW_FILE && !this.activeStateMap.isEmpty()) {
            throw new IllegalStateException("An uncompleted FlowFileState found while using SchemaDifferenceHandlingStrategy: " + String.valueOf((Object)SchemaDifferenceHandlingStrategy.CREATE_FLOW_FILE) + ". Cannot create a new state until previous is completed or dropped.");
        }
        KinesisRecordProcessorRecord.FlowFileState newState = this.stateInitializerAction.init(record, flowFileContext);
        this.activeStateMap.put(record.getSchema(), newState);
        return newState;
    }

    KinesisRecordProcessorRecord.FlowFileState pop() {
        Iterator<Map.Entry<RecordSchema, KinesisRecordProcessorRecord.FlowFileState>> iterator = this.activeStateMap.entrySet().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return this.activeStateMap.remove(iterator.next().getKey());
    }

    void drop(RecordSchema recordSchema) {
        this.activeStateMap.remove(recordSchema);
    }

    static interface StateInitializerAction {
        public KinesisRecordProcessorRecord.FlowFileState init(Record var1, AbstractKinesisRecordProcessor.BatchProcessingContext var2) throws IOException, SchemaNotFoundException;
    }

    static interface StateFinalizerAction {
        public void complete(KinesisRecordProcessorRecord.FlowFileState var1, AbstractKinesisRecordProcessor.BatchProcessingContext var2) throws KinesisRecordProcessorRecord.FlowFileCompletionException;
    }
}

