/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream.pause;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import org.apache.nifi.processors.aws.kinesis.stream.pause.RecordProcessorBlocker;

public class StandardRecordProcessorBlocker
implements RecordProcessorBlocker {
    static final Duration BLOCK_AFTER_DURATION = Duration.ofSeconds(2L);
    private final Supplier<Long> timestampProvider;
    private long timeoutBase;
    private CountDownLatch blocker = new CountDownLatch(0);

    public static StandardRecordProcessorBlocker create() {
        return new StandardRecordProcessorBlocker(System::currentTimeMillis);
    }

    protected StandardRecordProcessorBlocker(Supplier<Long> timestampProvider) {
        this.timestampProvider = timestampProvider;
        this.timeoutBase = timestampProvider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        long nowTimestamp = this.timestampProvider.get();
        if (!this.isAfterTimeout(nowTimestamp)) {
            return;
        }
        StandardRecordProcessorBlocker standardRecordProcessorBlocker = this;
        synchronized (standardRecordProcessorBlocker) {
            CountDownLatch localTimeoutBlocker = this.blocker;
            if (this.isAfterTimeout(nowTimestamp) && localTimeoutBlocker.getCount() == 0L) {
                localTimeoutBlocker.countDown();
                this.blocker = new CountDownLatch(1);
            }
        }
        this.blocker.await();
    }

    private boolean isAfterTimeout(long nowMillis) {
        return nowMillis - this.timeoutBase > BLOCK_AFTER_DURATION.toMillis();
    }

    public synchronized void block() {
        this.timeoutBase = 0L;
    }

    public void unblock() {
        this.timeoutBase = this.timestampProvider.get();
        this.blocker.countDown();
    }

    public void unblockIndefinitely() {
        this.timeoutBase = Long.MAX_VALUE;
        this.blocker.countDown();
    }
}

