/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import java.net.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderControllerService;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.ssl.SSLContextProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleCredentialsStrategy
extends AbstractCredentialsStrategy {
    public AssumeRoleCredentialsStrategy() {
        super("Assume Role", new PropertyDescriptor[]{AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN, AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME, AWSCredentialsProviderControllerService.MAX_SESSION_TIME});
    }

    @Override
    public boolean canCreatePrimaryCredential(PropertyContext propertyContext) {
        return false;
    }

    @Override
    public boolean canCreateDerivedCredential(PropertyContext propertyContext) {
        if (propertyContext.getProperty(AWSCredentialsProviderControllerService.OAUTH2_ACCESS_TOKEN_PROVIDER).isSet()) {
            return false;
        }
        String assumeRoleArn = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME).getValue();
        return assumeRoleArn != null && !assumeRoleArn.isEmpty() && assumeRoleName != null && !assumeRoleName.isEmpty();
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        return Collections.emptyList();
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AwsCredentialsProvider getDerivedAwsCredentialsProvider(PropertyContext propertyContext, AwsCredentialsProvider primaryCredentialsProvider) {
        org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration;
        String assumeRoleArn = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME).getValue();
        int maxSessionTime = propertyContext.getProperty(AWSCredentialsProviderControllerService.MAX_SESSION_TIME).asInteger();
        String assumeRoleExternalId = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_EXTERNAL_ID).getValue();
        String assumeRoleSTSEndpoint = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_ENDPOINT).getValue();
        String stsRegion = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_REGION).getValue();
        SSLContextProvider sslContextProvider = (SSLContextProvider)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        ProxyConfigurationService proxyConfigurationService = (ProxyConfigurationService)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        StsAssumeRoleCredentialsProvider.Builder builder = StsAssumeRoleCredentialsProvider.builder();
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (sslContextProvider != null) {
            SSLContext sslContext = sslContextProvider.createContext();
            httpClientBuilder.socketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        }
        if (proxyConfigurationService != null && (proxyConfiguration = proxyConfigurationService.getConfiguration()).getProxyType() == Proxy.Type.HTTP) {
            ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxyConfiguration.getProxyServerHost(), proxyConfiguration.getProxyServerPort())));
            if (proxyConfiguration.hasCredential()) {
                proxyConfigBuilder.username(proxyConfiguration.getProxyUserName());
                proxyConfigBuilder.password(proxyConfiguration.getProxyUserPassword());
            }
            httpClientBuilder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
        }
        if (stsRegion == null) {
            throw new IllegalStateException("Assume Role Region is required to interact with STS");
        }
        StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(primaryCredentialsProvider)).region(Region.of((String)stsRegion))).httpClient(httpClientBuilder.build());
        if (assumeRoleSTSEndpoint != null && !assumeRoleSTSEndpoint.isEmpty()) {
            stsClientBuilder.endpointOverride(URI.create(assumeRoleSTSEndpoint));
        }
        StsClient stsClient = (StsClient)stsClientBuilder.build();
        AssumeRoleRequest.Builder roleRequestBuilder = AssumeRoleRequest.builder().roleArn(assumeRoleArn).roleSessionName(assumeRoleName).durationSeconds(Integer.valueOf(maxSessionTime));
        if (assumeRoleExternalId != null && !assumeRoleExternalId.isEmpty()) {
            roleRequestBuilder.externalId(assumeRoleExternalId);
        }
        builder.refreshRequest((AssumeRoleRequest)roleRequestBuilder.build()).stsClient(stsClient);
        return builder.build();
    }
}

