/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.processors.aws.s3.util.Expiration;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;

public final class S3Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Util.class);
    private static final Pattern EXPIRATION_HEADER_PATTERN = Pattern.compile("expiry-date=\"(.*)\", rule-id=\"(.*)\"");

    private S3Util() {
    }

    public static String nullIfBlank(String value) {
        return StringUtils.isNotBlank((String)value) ? value : null;
    }

    public static RequestPayer getRequestPayer(boolean requesterPays) {
        return requesterPays ? RequestPayer.REQUESTER : null;
    }

    public static String getResourceUrl(S3Client client, String bucket, String key) {
        return client.utilities().getUrl((GetUrlRequest)GetUrlRequest.builder().bucket(bucket).key(key).build()).toExternalForm();
    }

    public static String sanitizeETag(String eTag) {
        if (StringUtils.isNotBlank((String)eTag)) {
            return eTag.replaceAll("^\"|\"$", "");
        }
        return eTag;
    }

    public static Expiration parseExpirationHeader(String expirationHeader) {
        Expiration expiration = null;
        if (StringUtils.isNotBlank((String)expirationHeader)) {
            try {
                Matcher matcher = EXPIRATION_HEADER_PATTERN.matcher(expirationHeader);
                if (matcher.matches()) {
                    Instant expirationTime = ZonedDateTime.parse(matcher.group(1), DateTimeFormatter.RFC_1123_DATE_TIME).toInstant();
                    String expirationTimeRuleId = URLDecoder.decode(matcher.group(2), StandardCharsets.UTF_8);
                    expiration = new Expiration(expirationTime, expirationTimeRuleId);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse expiration header [{}]", (Object)expirationHeader, (Object)e);
            }
        }
        return expiration;
    }

    public static String createRangeSpec(long rangeStart) {
        return String.format("bytes=%d-", rangeStart);
    }

    public static String createRangeSpec(long rangeStart, long rangeEnd) {
        return String.format("bytes=%d-%d", rangeStart, rangeEnd);
    }
}

