/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionKeySpec;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

public class ServerSideKMSEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public void configurePutObjectRequest(PutObjectRequest.Builder requestBuilder, S3EncryptionKeySpec keySpec) {
        requestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS);
        requestBuilder.ssekmsKeyId(keySpec.kmsId());
    }

    @Override
    public void configureCreateMultipartUploadRequest(CreateMultipartUploadRequest.Builder requestBuilder, S3EncryptionKeySpec keySpec) {
        requestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS);
        requestBuilder.ssekmsKeyId(keySpec.kmsId());
    }

    @Override
    public ValidationResult validateKeySpec(S3EncryptionKeySpec keySpec) {
        if (StringUtils.isBlank((CharSequence)keySpec.kmsId())) {
            return new ValidationResult.Builder().subject("KMS Key ID").valid(false).explanation("it is empty").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }
}

