/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.fileresource.service.api.FileResourceService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.AbstractAwsProcessor;
import org.apache.nifi.processors.aws.credentials.provider.AwsCredentialsProviderService;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@Tags(value={"Amazon", "S3", "AWS", "file", "resource"})
@SeeAlso(value={FetchS3Object.class})
@CapabilityDescription(value="Provides an Amazon Web Services (AWS) S3 file resource for other components.")
@UseCase(description="Fetch a specific file from S3. The service provides higher performance compared to fetch processors when the data should be moved between different storages without any transformation.", configuration="\"Bucket\" = \"${s3.bucket}\"\n\"Object Key\" = \"${filename}\"\n\nThe \"Region\" property must be set to denote the S3 region that the Bucket resides in.\n\nThe \"AWS Credentials Provider Service\" property should specify an instance of the AwsCredentialsProviderService in order to provide credentials for accessing the bucket.\n")
public class S3FileResourceService
extends AbstractControllerService
implements FileResourceService {
    public static final PropertyDescriptor BUCKET_WITH_DEFAULT_VALUE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractS3Processor.BUCKET_WITH_DEFAULT_VALUE).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractS3Processor.KEY).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BUCKET_WITH_DEFAULT_VALUE, KEY, RegionUtil.REGION, RegionUtil.CUSTOM_REGION, AbstractAwsProcessor.AWS_CREDENTIALS_PROVIDER_SERVICE);
    private final Cache<Region, S3Client> clientCache = Caffeine.newBuilder().build();
    private volatile PropertyContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    @OnDisabled
    public void onDisabled() {
        this.context = null;
        this.clientCache.asMap().values().forEach(SdkAutoCloseable::close);
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
    }

    public FileResource getFileResource(Map<String, String> attributes) {
        AwsCredentialsProviderService awsCredentialsProviderService = (AwsCredentialsProviderService)this.context.getProperty(AbstractAwsProcessor.AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AwsCredentialsProviderService.class);
        S3Client client = this.getS3Client(attributes, awsCredentialsProviderService.getAwsCredentialsProvider());
        try {
            return this.fetchObject(client, attributes);
        }
        catch (ProcessException | SdkException e) {
            throw new ProcessException("Failed to fetch s3 object", e);
        }
    }

    private FileResource fetchObject(S3Client client, Map<String, String> attributes) throws ProcessException {
        ResponseInputStream responseStream;
        String bucketName = this.context.getProperty(BUCKET_WITH_DEFAULT_VALUE).evaluateAttributeExpressions(attributes).getValue();
        String key = this.context.getProperty(KEY).evaluateAttributeExpressions(attributes).getValue();
        if (StringUtils.isBlank((String)bucketName) || StringUtils.isBlank((String)key)) {
            throw new ProcessException("Bucket name or key value is missing");
        }
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
        try {
            responseStream = client.getObject(request);
        }
        catch (NoSuchKeyException e) {
            throw new ProcessException(String.format("Object '%s/%s' does not exist in s3", bucketName, key));
        }
        return new FileResource((InputStream)responseStream, ((GetObjectResponse)responseStream.response()).contentLength().longValue());
    }

    protected S3Client getS3Client(Map<String, String> attributes, AwsCredentialsProvider credentialsProvider) {
        Region region = RegionUtil.getRegion((PropertyContext)this.context, attributes);
        return (S3Client)this.clientCache.get((Object)region, ignored -> (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(region)).credentialsProvider(credentialsProvider)).build());
    }
}

