/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.AmazonS3EncryptionService;
import org.apache.nifi.processors.aws.s3.CopyS3Object;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.GetS3ObjectMetadata;
import org.apache.nifi.processors.aws.s3.GetS3ObjectTags;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.TagS3Object;
import org.apache.nifi.processors.aws.s3.encryption.StandardS3EncryptionService;
import org.apache.nifi.processors.aws.s3.util.Expiration;
import org.apache.nifi.processors.aws.s3.util.S3Util;
import org.apache.nifi.processors.transfer.ResourceTransferProperties;
import org.apache.nifi.processors.transfer.ResourceTransferSource;
import org.apache.nifi.processors.transfer.ResourceTransferUtils;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.SdkPartType;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

@SupportsBatching
@SeeAlso(value={FetchS3Object.class, DeleteS3Object.class, ListS3.class, CopyS3Object.class, GetS3ObjectMetadata.class, GetS3ObjectTags.class, TagS3Object.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "S3", "AWS", "Archive", "Put"})
@CapabilityDescription(value="Writes the contents of a FlowFile as an S3 Object to an Amazon S3 Bucket.")
@DynamicProperty(name="The name of a User-Defined Metadata field to add to the S3 Object", value="The value of a User-Defined Metadata field to add to the S3 Object", description="Allows user-defined metadata to be added to the S3 object as key/value pairs", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@ReadsAttribute(attribute="filename", description="Uses the FlowFile's filename as the filename for the S3 object")
@WritesAttributes(value={@WritesAttribute(attribute="s3.url", description="The URL that can be used to access the S3 object"), @WritesAttribute(attribute="s3.bucket", description="The S3 bucket where the Object was put in S3"), @WritesAttribute(attribute="s3.key", description="The S3 key within where the Object was put in S3"), @WritesAttribute(attribute="s3.contenttype", description="The S3 content type of the S3 Object that put in S3"), @WritesAttribute(attribute="s3.version", description="The version of the S3 Object that was put to S3"), @WritesAttribute(attribute="s3.exception", description="The class name of the exception thrown during processor execution"), @WritesAttribute(attribute="s3.additionalDetails", description="The S3 supplied detail from the failed operation"), @WritesAttribute(attribute="s3.statusCode", description="The HTTP error code (if available) from the failed operation"), @WritesAttribute(attribute="s3.errorCode", description="The S3 moniker of the failed operation"), @WritesAttribute(attribute="s3.errorMessage", description="The S3 exception message from the failed operation"), @WritesAttribute(attribute="s3.etag", description="The ETag of the S3 Object"), @WritesAttribute(attribute="s3.contentdisposition", description="The content disposition of the S3 Object that put in S3"), @WritesAttribute(attribute="s3.cachecontrol", description="The cache-control header of the S3 Object"), @WritesAttribute(attribute="s3.uploadId", description="The uploadId used to upload the Object to S3"), @WritesAttribute(attribute="s3.expirationTime", description="If the S3 object has been assigned an expiration time, this attribute will be set, containing the milliseconds since epoch in UTC time"), @WritesAttribute(attribute="s3.expirationTimeRuleId", description="If the S3 object has been assigned an expiration time, this attribute will be set, containing the ID of the rule that dictates this object's expiration time"), @WritesAttribute(attribute="s3.sseAlgorithm", description="The server side encryption algorithm of the object"), @WritesAttribute(attribute="s3.usermetadata", description="A human-readable form of the User Metadata of the S3 object, if any was set"), @WritesAttribute(attribute="s3.encryptionStrategy", description="The name of the encryption strategy, if any was set")})
public class PutS3Object
extends AbstractS3Processor {
    public static final long MIN_S3_PART_SIZE = 0x3200000L;
    public static final long MAX_S3_PUTOBJECT_SIZE = 0x140000000L;
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final String OBSOLETE_EXPIRATION_RULE_ID = "Expiration Time Rule";
    private static final String OBSOLETE_SERVER_SIDE_ENCRYPTION_1 = "server-side-encryption";
    private static final String OBSOLETE_SERVER_SIDE_ENCRYPTION_2 = "Server Side Encryption";
    private static final String OBSOLETE_SERVER_SIDE_ENCRYPTION_AES256 = "AES256";
    private static final Set<String> STORAGE_CLASSES = Collections.unmodifiableSortedSet(new TreeSet(Arrays.stream(StorageClass.values()).map(Enum::name).collect(Collectors.toSet())));
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content Type").description("Sets the Content-Type HTTP header indicating the type of content stored in the associated object. The value of this header is a standard MIME type.\nAWS S3 Java client will attempt to determine the correct content type if one hasn't been set yet. Users are responsible for ensuring a suitable content type is set when uploading streams. If no content type is provided and cannot be determined by the filename, the default content type \"application/octet-stream\" will be used.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONTENT_DISPOSITION = new PropertyDescriptor.Builder().name("Content Disposition").description("Sets the Content-Disposition HTTP header indicating if the content is intended to be displayed inline or should be downloaded.\n Possible values are 'inline' or 'attachment'. If this property is not specified, object's content-disposition will be set to filename. When 'attachment' is selected, '; filename=' plus object key are automatically appended to form final value 'attachment; filename=\"filename.jpg\"'.").required(false).allowableValues(new String[]{"inline", "attachment"}).build();
    public static final PropertyDescriptor CACHE_CONTROL = new PropertyDescriptor.Builder().name("Cache Control").description("Sets the Cache-Control HTTP header indicating the caching directives of the associated object. Multiple directives are comma-separated.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor STORAGE_CLASS = new PropertyDescriptor.Builder().name("Storage Class").required(true).allowableValues(STORAGE_CLASSES).defaultValue(StorageClass.STANDARD.name()).build();
    public static final PropertyDescriptor MULTIPART_THRESHOLD = new PropertyDescriptor.Builder().name("Multipart Threshold").description("Specifies the file size threshold for switch from the PutS3Object API to the PutS3MultipartUpload API.  Flow files bigger than this limit will be sent using the stateful multipart process. The valid range is 50MB to 5GB.").required(true).defaultValue("5 GB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)0x3200000L, (long)0x140000000L)).build();
    public static final PropertyDescriptor MULTIPART_PART_SIZE = new PropertyDescriptor.Builder().name("Multipart Part Size").description("Specifies the part size for use when the PutS3Multipart Upload API is used. Flow files will be broken into chunks of this size for the upload process, but the last part sent can be smaller since it is not padded. The valid range is 50MB to 5GB.").required(true).defaultValue("5 GB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)0x3200000L, (long)0x140000000L)).build();
    public static final PropertyDescriptor MULTIPART_S3_AGEOFF_INTERVAL = new PropertyDescriptor.Builder().name("Multipart Upload AgeOff Interval").description("Specifies the interval at which existing multipart uploads in AWS S3 will be evaluated for ageoff.  When processor is triggered it will initiate the ageoff evaluation if this interval has been exceeded.").required(true).defaultValue("60 min").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor MULTIPART_S3_MAX_AGE = new PropertyDescriptor.Builder().name("Multipart Upload Max Age Threshold").description("Specifies the maximum age for existing multipart uploads in AWS S3.  When the ageoff process occurs, any upload older than this threshold will be aborted.").required(true).defaultValue("7 days").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor OBJECT_TAGS_PREFIX = new PropertyDescriptor.Builder().name("Object Tags Prefix").description("Specifies the prefix which would be scanned against the incoming FlowFile's attributes and the matching attribute's name and value would be considered as the outgoing S3 object's Tag name and Tag value respectively. For Ex: If the incoming FlowFile carries the attributes tagS3country, tagS3PII, the tag prefix to be specified would be 'tagS3'").required(false).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor REMOVE_TAG_PREFIX = new PropertyDescriptor.Builder().name("Remove Tag Prefix").description("If set to 'True', the value provided for '" + OBJECT_TAGS_PREFIX.getDisplayName() + "' will be removed from the attribute(s) and then considered as the Tag name. For ex: If the incoming FlowFile carries the attributes tagS3country, tagS3PII and the prefix is set to 'tagS3' then the corresponding tag values would be 'country' and 'PII'").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor MULTIPART_TEMP_DIR = new PropertyDescriptor.Builder().name("Temporary Directory Multipart State").description("Directory in which, for multipart uploads, the processor will locally save the state tracking the upload ID and parts uploaded which must both be provided to complete the upload.").required(true).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).defaultValue("${java.io.tmpdir}").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BUCKET_WITH_DEFAULT_VALUE, KEY, RegionUtil.REGION, RegionUtil.CUSTOM_REGION_WITH_FF_EL, AWS_CREDENTIALS_PROVIDER_SERVICE, ResourceTransferProperties.RESOURCE_TRANSFER_SOURCE, ResourceTransferProperties.FILE_RESOURCE_SERVICE, STORAGE_CLASS, ENCRYPTION_SERVICE, CONTENT_TYPE, CONTENT_DISPOSITION, CACHE_CONTROL, OBJECT_TAGS_PREFIX, REMOVE_TAG_PREFIX, TIMEOUT, FULL_CONTROL_USER_LIST, READ_USER_LIST, READ_ACL_LIST, WRITE_ACL_LIST, CANNED_ACL, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, MULTIPART_THRESHOLD, MULTIPART_PART_SIZE, MULTIPART_S3_AGEOFF_INTERVAL, MULTIPART_S3_MAX_AGE, MULTIPART_TEMP_DIR, USE_CHUNKED_ENCODING, USE_PATH_STYLE_ACCESS, PROXY_CONFIGURATION_SERVICE);
    static final String S3_BUCKET_KEY = "s3.bucket";
    static final String S3_OBJECT_KEY = "s3.key";
    static final String S3_CONTENT_TYPE = "s3.contenttype";
    static final String S3_CONTENT_DISPOSITION = "s3.contentdisposition";
    static final String S3_UPLOAD_ID_ATTR_KEY = "s3.uploadId";
    static final String S3_VERSION_ATTR_KEY = "s3.version";
    static final String S3_ETAG_ATTR_KEY = "s3.etag";
    static final String S3_CACHE_CONTROL = "s3.cachecontrol";
    static final String S3_EXPIRATION_TIME_ATTR_KEY = "s3.expirationTime";
    static final String S3_EXPIRATION_TIME_RULE_ID_ATTR_KEY = "s3.expirationTimeRuleId";
    static final String S3_STORAGECLASS_ATTR_KEY = "s3.storeClass";
    static final String S3_USERMETA_ATTR_KEY = "s3.usermetadata";
    static final String S3_API_METHOD_ATTR_KEY = "s3.apimethod";
    static final String S3_API_METHOD_PUTOBJECT = "putobject";
    static final String S3_API_METHOD_MULTIPARTUPLOAD = "multipartupload";
    static final String S3_PROCESS_UNSCHEDULED_MESSAGE = "Processor unscheduled, stopping upload";
    private static final Map<String, String> STORAGE_CLASS_MAPPING = Map.of("Standard", StorageClass.STANDARD.name(), "ReducedRedundancy", StorageClass.REDUCED_REDUNDANCY.name(), "Glacier", StorageClass.GLACIER.name(), "StandardInfrequentAccess", StorageClass.STANDARD_IA.name(), "OneZoneInfrequentAccess", StorageClass.ONEZONE_IA.name(), "IntelligentTiering", StorageClass.INTELLIGENT_TIERING.name(), "DeepArchive", StorageClass.DEEP_ARCHIVE.name(), "Outposts", StorageClass.OUTPOSTS.name(), "GlacierInstantRetrieval", StorageClass.GLACIER_IR.name(), "Snow", StorageClass.SNOW.name());
    private volatile String tempDirMultipart = System.getProperty("java.io.tmpdir");
    private final Lock s3BucketLock = new ReentrantLock();
    private final AtomicLong lastS3AgeOff = new AtomicLong(0L);

    @OnScheduled
    public void setTempDir(ProcessContext context) {
        this.tempDirMultipart = context.getProperty(MULTIPART_TEMP_DIR).evaluateAttributeExpressions().getValue();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("s3-object-tags-prefix", OBJECT_TAGS_PREFIX.getName());
        config.renameProperty("s3-object-remove-tags-prefix", REMOVE_TAG_PREFIX.getName());
        config.renameProperty("s3-temporary-directory-multipart", MULTIPART_TEMP_DIR.getName());
        this.migrateStorageClass(config);
        this.migrateServerSideEncryption(config);
        config.removeProperty("Write Permission User List");
        config.removeProperty("Owner");
        config.removeProperty(OBSOLETE_EXPIRATION_RULE_ID);
    }

    private void migrateStorageClass(PropertyConfiguration config) {
        config.getPropertyValue(STORAGE_CLASS).ifPresent(existingStorageClass -> Optional.ofNullable(STORAGE_CLASS_MAPPING.get(existingStorageClass)).ifPresent(mappedStorageClass -> config.setProperty(STORAGE_CLASS, mappedStorageClass)));
    }

    private void migrateServerSideEncryption(PropertyConfiguration config) {
        String propertyName = config.hasProperty(OBSOLETE_SERVER_SIDE_ENCRYPTION_1) ? OBSOLETE_SERVER_SIDE_ENCRYPTION_1 : (config.hasProperty(OBSOLETE_SERVER_SIDE_ENCRYPTION_2) ? OBSOLETE_SERVER_SIDE_ENCRYPTION_2 : null);
        if (propertyName != null) {
            config.getPropertyValue(propertyName).filter(serverSideEncryption -> serverSideEncryption.equals(OBSOLETE_SERVER_SIDE_ENCRYPTION_AES256)).ifPresent(serverSideEncryption -> {
                String serviceId = config.createControllerService(StandardS3EncryptionService.class.getName(), Map.of(StandardS3EncryptionService.ENCRYPTION_STRATEGY.getName(), "SSE_S3"));
                config.setProperty(ENCRYPTION_SERVICE, serviceId);
            });
            config.removeProperty(propertyName);
        }
    }

    protected File getPersistenceFile() {
        return new File(this.tempDirMultipart + File.separator + this.getIdentifier());
    }

    protected boolean localUploadExistsInS3(S3Client client, String bucket, MultipartState localState) {
        ListMultipartUploadsRequest listRequest = (ListMultipartUploadsRequest)ListMultipartUploadsRequest.builder().bucket(bucket).build();
        ListMultipartUploadsResponse listResponse = client.listMultipartUploads(listRequest);
        for (MultipartUpload upload : listResponse.uploads()) {
            if (!upload.uploadId().equals(localState.getUploadId())) continue;
            return true;
        }
        return false;
    }

    protected synchronized MultipartState getLocalStateIfInS3(S3Client client, String bucket, String s3ObjectKey) throws IOException {
        MultipartState currState = this.getLocalState(s3ObjectKey);
        if (currState == null) {
            return null;
        }
        if (this.localUploadExistsInS3(client, bucket, currState)) {
            this.getLogger().info("Local state for {} loaded with uploadId {} and {} partETags", new Object[]{s3ObjectKey, currState.getUploadId(), currState.getCompletedParts().size()});
            return currState;
        }
        this.getLogger().info("Local state for {} with uploadId {} does not exist in S3, deleting local state", new Object[]{s3ObjectKey, currState.getUploadId()});
        this.persistLocalState(s3ObjectKey, null);
        return null;
    }

    protected synchronized MultipartState getLocalState(String s3ObjectKey) throws IOException {
        File persistenceFile = this.getPersistenceFile();
        if (persistenceFile.exists()) {
            String localSerialState;
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
            catch (IOException ioe) {
                this.getLogger().warn("Assuming no local state and restarting upload since failed to recover local state for {}", new Object[]{s3ObjectKey, ioe});
                return null;
            }
            if (props.containsKey(s3ObjectKey) && (localSerialState = props.getProperty(s3ObjectKey)) != null) {
                try {
                    return new MultipartState(localSerialState);
                }
                catch (RuntimeException rte) {
                    this.getLogger().warn("Failed to recover local state for {} due to corrupt data in state.", new Object[]{s3ObjectKey, rte});
                    return null;
                }
            }
        }
        return null;
    }

    protected synchronized void persistLocalState(String s3ObjectKey, MultipartState currState) throws IOException {
        String currStateStr = currState == null ? null : currState.toString();
        File persistenceFile = this.getPersistenceFile();
        File parentDir = persistenceFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Persistence directory (" + parentDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        Properties props = new Properties();
        if (persistenceFile.exists()) {
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
        }
        if (currStateStr != null) {
            currState.setTimestamp(System.currentTimeMillis());
            props.setProperty(s3ObjectKey, currStateStr);
        } else {
            props.remove(s3ObjectKey);
        }
        if (!props.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(persistenceFile);){
                props.store(fos, null);
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not store state {}", new Object[]{persistenceFile.getAbsolutePath(), ioe});
            }
        } else if (persistenceFile.exists()) {
            try {
                Files.delete(persistenceFile.toPath());
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not remove state file {}", new Object[]{persistenceFile.getAbsolutePath(), ioe});
            }
        }
    }

    protected synchronized void removeLocalState(String s3ObjectKey) throws IOException {
        this.persistLocalState(s3ObjectKey, null);
    }

    private synchronized void ageoffLocalState(long ageCutoff) {
        File persistenceFile = this.getPersistenceFile();
        if (persistenceFile.exists()) {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
            catch (IOException ioe) {
                this.getLogger().warn("Failed to ageoff remove local state", (Throwable)ioe);
                return;
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                MultipartState state;
                String key = (String)entry.getKey();
                String localSerialState = props.getProperty(key);
                if (localSerialState == null || (state = new MultipartState(localSerialState)).getTimestamp() >= ageCutoff) continue;
                this.getLogger().warn("Removing local state for {} due to exceeding ageoff time", new Object[]{key});
                try {
                    this.removeLocalState(key);
                }
                catch (IOException ioe) {
                    this.getLogger().warn("Failed to remove local state for {}", new Object[]{key, ioe});
                }
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        S3Client client;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            client = (S3Client)this.getClient(context, flowFile.getAttributes());
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize S3 client", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        long startNanos = System.nanoTime();
        String bucket = context.getProperty(BUCKET_WITH_DEFAULT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        String cacheKey = this.getIdentifier() + "/" + bucket + "/" + key;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String ffFilename = (String)flowFile.getAttributes().get(CoreAttributes.FILENAME.key());
        ResourceTransferSource resourceTransferSource = (ResourceTransferSource)context.getProperty(ResourceTransferProperties.RESOURCE_TRANSFER_SOURCE).asAllowableValue(ResourceTransferSource.class);
        attributes.put(S3_BUCKET_KEY, bucket);
        attributes.put(S3_OBJECT_KEY, key);
        Long multipartThreshold = context.getProperty(MULTIPART_THRESHOLD).asDataSize(DataUnit.B).longValue();
        Long multipartPartSize = context.getProperty(MULTIPART_PART_SIZE).asDataSize(DataUnit.B).longValue();
        long now = System.currentTimeMillis();
        this.ageoffS3Uploads(context, client, now, bucket);
        try {
            block64: {
                FlowFile flowFileCopy = flowFile;
                Optional optFileResource = ResourceTransferUtils.getFileResource((ResourceTransferSource)resourceTransferSource, (ProcessContext)context, (Map)flowFile.getAttributes());
                try (InputStream in = optFileResource.map(FileResource::getInputStream).orElseGet(() -> session.read(flowFileCopy));){
                    MultipartState currentState;
                    Object contentDisposition;
                    String cacheControl;
                    long contentLength = optFileResource.map(FileResource::getSize).orElseGet(() -> ((FlowFile)flowFile).getSize());
                    String contentType = context.getProperty(CONTENT_TYPE).evaluateAttributeExpressions(flowFile).getValue();
                    if (contentType != null) {
                        attributes.put(S3_CONTENT_TYPE, contentType);
                    }
                    if ((cacheControl = context.getProperty(CACHE_CONTROL).evaluateAttributeExpressions(flowFile).getValue()) != null) {
                        attributes.put(S3_CACHE_CONTROL, cacheControl);
                    }
                    String contentDispositionPropertyValue = context.getProperty(CONTENT_DISPOSITION).getValue();
                    String fileName = URLEncoder.encode(flowFile.getAttribute(CoreAttributes.FILENAME.key()), StandardCharsets.UTF_8);
                    if (contentDispositionPropertyValue != null && contentDispositionPropertyValue.equals(CONTENT_DISPOSITION_INLINE)) {
                        contentDisposition = CONTENT_DISPOSITION_INLINE;
                        attributes.put(S3_CONTENT_DISPOSITION, contentDisposition);
                    } else if (contentDispositionPropertyValue != null && contentDispositionPropertyValue.equals(CONTENT_DISPOSITION_ATTACHMENT)) {
                        contentDisposition = "attachment; filename=\"" + fileName + "\"";
                        attributes.put(S3_CONTENT_DISPOSITION, contentDisposition);
                    } else {
                        contentDisposition = fileName;
                    }
                    HashMap<String, String> userMetadata = new HashMap<String, String>();
                    for (Map.Entry entry2 : context.getProperties().entrySet()) {
                        if (!((PropertyDescriptor)entry2.getKey()).isDynamic()) continue;
                        String value = context.getProperty((PropertyDescriptor)entry2.getKey()).evaluateAttributeExpressions(flowFile).getValue();
                        userMetadata.put(((PropertyDescriptor)entry2.getKey()).getName(), value);
                    }
                    String userMetadataAttributeValue = userMetadata.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
                    if (StringUtils.isNotBlank((CharSequence)userMetadataAttributeValue)) {
                        attributes.put(S3_USERMETA_ATTR_KEY, userMetadataAttributeValue);
                    }
                    AmazonS3EncryptionService encryptionService = (AmazonS3EncryptionService)context.getProperty(ENCRYPTION_SERVICE).asControllerService(AmazonS3EncryptionService.class);
                    StorageClass storageClass = StorageClass.valueOf((String)context.getProperty(STORAGE_CLASS).getValue());
                    attributes.put(S3_STORAGECLASS_ATTR_KEY, storageClass.name());
                    if (flowFile.getSize() <= multipartThreshold) {
                        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(bucket).key(key).contentLength(Long.valueOf(contentLength)).contentType(contentType).cacheControl(cacheControl).contentDisposition((String)contentDisposition).metadata(userMetadata).storageClass(storageClass).grantFullControl(this.getFullControlGranteeSpec((PropertyContext)context, flowFile)).grantRead(this.getReadGranteeSpec((PropertyContext)context, flowFile)).grantReadACP(this.getReadACPGranteeSpec((PropertyContext)context, flowFile)).grantWriteACP(this.getWriteACPGranteeSpec((PropertyContext)context, flowFile)).acl(this.createCannedACL(context, flowFile));
                        if (encryptionService != null) {
                            encryptionService.configurePutObjectRequest(requestBuilder);
                        }
                        if (context.getProperty(OBJECT_TAGS_PREFIX).isSet()) {
                            requestBuilder.tagging((Tagging)Tagging.builder().tagSet(this.getObjectTags(context, flowFile)).build());
                        }
                        RequestBody requestBody = RequestBody.fromInputStream((InputStream)in, (long)contentLength);
                        try {
                            Expiration expiration;
                            PutObjectResponse response = client.putObject((PutObjectRequest)requestBuilder.build(), requestBody);
                            if (response.versionId() != null) {
                                attributes.put(S3_VERSION_ATTR_KEY, response.versionId());
                            }
                            if (response.eTag() != null) {
                                attributes.put(S3_ETAG_ATTR_KEY, S3Util.sanitizeETag(response.eTag()));
                            }
                            if ((expiration = S3Util.parseExpirationHeader(response.expiration())) != null) {
                                attributes.put(S3_EXPIRATION_TIME_ATTR_KEY, String.valueOf(expiration.expirationTime().toEpochMilli()));
                                attributes.put(S3_EXPIRATION_TIME_RULE_ID_ATTR_KEY, expiration.expirationTimeRuleId());
                            }
                            this.setEncryptionAttributes(attributes, response.serverSideEncryption(), response.sseCustomerAlgorithm(), encryptionService);
                            attributes.put(S3_API_METHOD_ATTR_KEY, S3_API_METHOD_PUTOBJECT);
                            break block64;
                        }
                        catch (SdkException e) {
                            this.getLogger().info("Failure completing upload flowfile={} bucket={} key={} reason={}", new Object[]{ffFilename, bucket, key, e.getMessage()});
                            throw e;
                        }
                    }
                    try {
                        currentState = this.getLocalStateIfInS3(client, bucket, cacheKey);
                        if (currentState != null) {
                            if (!currentState.getCompletedParts().isEmpty()) {
                                CompletedPart lastCompletedPart = currentState.getCompletedParts().getLast();
                                this.getLogger().info("Resuming upload for flowfile='{}' bucket='{}' key='{}' uploadID='{}' filePosition='{}' partSize='{}' storageClass='{}' contentLength='{}' partsLoaded={} lastPart={}/{}", new Object[]{ffFilename, bucket, key, currentState.getUploadId(), currentState.getFilePosition(), currentState.getPartSize(), currentState.getStorageClass().toString(), currentState.getContentLength(), currentState.getCompletedParts().size(), Integer.toString(lastCompletedPart.partNumber()), lastCompletedPart.eTag()});
                            } else {
                                this.getLogger().info("Resuming upload for flowfile='{}' bucket='{}' key='{}' uploadID='{}' filePosition='{}' partSize='{}' storageClass='{}' contentLength='{}' no partsLoaded", new Object[]{ffFilename, bucket, key, currentState.getUploadId(), currentState.getFilePosition(), currentState.getPartSize(), currentState.getStorageClass().toString(), currentState.getContentLength()});
                            }
                        } else {
                            currentState = new MultipartState();
                            currentState.setPartSize(multipartPartSize);
                            currentState.setStorageClass(storageClass);
                            currentState.setContentLength(flowFile.getSize());
                            this.persistLocalState(cacheKey, currentState);
                            this.getLogger().info("Starting new upload for flowfile='{}' bucket='{}' key='{}'", new Object[]{ffFilename, bucket, key});
                        }
                    }
                    catch (IOException e) {
                        this.getLogger().error("IOException initiating cache state while processing flow files", (Throwable)e);
                        throw e;
                    }
                    if (currentState.getUploadId().isEmpty()) {
                        CreateMultipartUploadRequest.Builder createRequestBuilder = CreateMultipartUploadRequest.builder().bucket(bucket).key(key).contentType(contentType).cacheControl(cacheControl).contentDisposition((String)contentDisposition).metadata(userMetadata).storageClass(storageClass).grantFullControl(this.getFullControlGranteeSpec((PropertyContext)context, flowFile)).grantRead(this.getReadGranteeSpec((PropertyContext)context, flowFile)).grantReadACP(this.getReadACPGranteeSpec((PropertyContext)context, flowFile)).grantWriteACP(this.getWriteACPGranteeSpec((PropertyContext)context, flowFile)).acl(this.createCannedACL(context, flowFile));
                        if (encryptionService != null) {
                            encryptionService.configureCreateMultipartUploadRequest(createRequestBuilder);
                        }
                        if (context.getProperty(OBJECT_TAGS_PREFIX).isSet()) {
                            createRequestBuilder.tagging((Tagging)Tagging.builder().tagSet(this.getObjectTags(context, flowFile)).build());
                        }
                        try {
                            CreateMultipartUploadResponse createResponse = client.createMultipartUpload((CreateMultipartUploadRequest)createRequestBuilder.build());
                            if (StringUtils.isBlank((CharSequence)createResponse.uploadId())) {
                                throw new ProcessException(String.format("UploadId is missing in CreateMultipartUploadResponse [%s]", createResponse));
                            }
                            currentState.setUploadId(createResponse.uploadId());
                            currentState.getCompletedParts().clear();
                            try {
                                this.persistLocalState(cacheKey, currentState);
                            }
                            catch (Exception e) {
                                this.getLogger().info("Exception saving cache state while processing flow file", (Throwable)e);
                                throw new ProcessException("Exception saving cache state", (Throwable)e);
                            }
                            this.getLogger().info("Success initiating upload flowfile={} available={} position={} length={} bucket={} key={} uploadId={}", new Object[]{ffFilename, in.available(), currentState.getFilePosition(), currentState.getContentLength(), bucket, key, currentState.getUploadId()});
                            attributes.put(S3_UPLOAD_ID_ATTR_KEY, createResponse.uploadId());
                            this.setEncryptionAttributes(attributes, createResponse.serverSideEncryption(), createResponse.sseCustomerAlgorithm(), encryptionService);
                        }
                        catch (SdkException e) {
                            this.getLogger().info("Failure initiating upload flowfile={} bucket={} key={}", new Object[]{ffFilename, bucket, key, e});
                            throw e;
                        }
                    }
                    if (currentState.getFilePosition() > 0L) {
                        try {
                            long skipped = in.skip(currentState.getFilePosition());
                            if (skipped != currentState.getFilePosition()) {
                                this.getLogger().info("Failure skipping to resume upload flowfile={} bucket={} key={} position={} skipped={}", new Object[]{ffFilename, bucket, key, currentState.getFilePosition(), skipped});
                            }
                        }
                        catch (Exception e) {
                            this.getLogger().info("Failure skipping to resume upload flowfile={} bucket={} key={} position={}", new Object[]{ffFilename, bucket, key, currentState.getFilePosition(), e});
                            throw new ProcessException((Throwable)e);
                        }
                    }
                    int part = currentState.getCompletedParts().size() + 1;
                    while (currentState.getFilePosition() < currentState.getContentLength()) {
                        if (!this.isScheduled()) {
                            throw new IOException("Processor unscheduled, stopping upload flowfile=" + ffFilename + " part=" + part + " uploadId=" + currentState.getUploadId());
                        }
                        long thisPartSize = Math.min(currentState.getPartSize(), currentState.getContentLength() - currentState.getFilePosition());
                        boolean isLastPart = currentState.getContentLength() == currentState.getFilePosition() + thisPartSize;
                        UploadPartRequest.Builder uploadRequestBuilder = UploadPartRequest.builder().bucket(bucket).key(key).uploadId(currentState.getUploadId()).partNumber(Integer.valueOf(part)).sdkPartType(isLastPart ? SdkPartType.LAST : SdkPartType.DEFAULT).contentLength(Long.valueOf(thisPartSize));
                        if (encryptionService != null) {
                            encryptionService.configureUploadPartRequest(uploadRequestBuilder);
                        }
                        RequestBody requestBody = RequestBody.fromInputStream((InputStream)in, (long)thisPartSize);
                        try {
                            UploadPartResponse uploadPartResponse = client.uploadPart((UploadPartRequest)uploadRequestBuilder.build(), requestBody);
                            currentState.addCompletedPart((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(part)).eTag(uploadPartResponse.eTag()).build());
                            currentState.setFilePosition(currentState.getFilePosition() + thisPartSize);
                            try {
                                this.persistLocalState(cacheKey, currentState);
                            }
                            catch (Exception e) {
                                this.getLogger().info("Exception saving cache state processing flow file", (Throwable)e);
                            }
                            int available = 0;
                            try {
                                available = in.available();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.getLogger().info("Success uploading part flowfile={} part={} available={} etag={} uploadId={}", new Object[]{ffFilename, part, available, uploadPartResponse.eTag(), currentState.getUploadId()});
                        }
                        catch (SdkException e) {
                            this.getLogger().info("Failure uploading part flowfile={} part={} bucket={} key={}", new Object[]{ffFilename, part, bucket, key, e});
                            throw e;
                        }
                        ++part;
                    }
                    CompleteMultipartUploadRequest completeRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(bucket).key(key).uploadId(currentState.getUploadId()).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(currentState.getCompletedParts()).build()).build();
                    try {
                        Expiration expiration;
                        CompleteMultipartUploadResponse completeResponse = client.completeMultipartUpload(completeRequest);
                        this.getLogger().info("Success completing upload flowfile={} etag={} uploadId={}", new Object[]{ffFilename, completeResponse.eTag(), currentState.getUploadId()});
                        if (completeResponse.versionId() != null) {
                            attributes.put(S3_VERSION_ATTR_KEY, completeResponse.versionId());
                        }
                        if (completeResponse.eTag() != null) {
                            attributes.put(S3_ETAG_ATTR_KEY, S3Util.sanitizeETag(completeResponse.eTag()));
                        }
                        if ((expiration = S3Util.parseExpirationHeader(completeResponse.expiration())) != null) {
                            attributes.put(S3_EXPIRATION_TIME_ATTR_KEY, String.valueOf(expiration.expirationTime().toEpochMilli()));
                            attributes.put(S3_EXPIRATION_TIME_RULE_ID_ATTR_KEY, expiration.expirationTimeRuleId());
                        }
                        attributes.put(S3_API_METHOD_ATTR_KEY, S3_API_METHOD_MULTIPARTUPLOAD);
                    }
                    catch (SdkException e) {
                        this.getLogger().info("Failure completing upload flowfile={} bucket={} key={}", new Object[]{ffFilename, bucket, key, e});
                        throw e;
                    }
                }
                catch (IOException e) {
                    this.getLogger().error("Error during upload of flow files", (Throwable)e);
                    throw e;
                }
            }
            String url = S3Util.getResourceUrl(client, bucket, key);
            attributes.put("s3.url", url);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, REL_SUCCESS);
            long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().send(flowFile, url, millis);
            this.getLogger().info("Successfully put {} to Amazon S3 in {} milliseconds", new Object[]{flowFile, millis});
            try {
                this.removeLocalState(cacheKey);
            }
            catch (IOException e) {
                this.getLogger().info("Error trying to delete key {} from cache:", new Object[]{cacheKey, e});
            }
        }
        catch (IOException | IllegalArgumentException | ProcessException | SdkException e) {
            this.extractExceptionDetails((Exception)e, session, flowFile);
            if (e.getMessage().contains(S3_PROCESS_UNSCHEDULED_MESSAGE)) {
                this.getLogger().info(e.getMessage());
                session.rollback();
            }
            this.getLogger().error("Failed to put {} to Amazon S3 due to {}", new Object[]{flowFile, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected void ageoffS3Uploads(ProcessContext context, S3Client client, long now, String bucket) {
        List<MultipartUpload> oldUploads = this.getS3AgeoffListAndAgeoffLocalState(context, client, now, bucket);
        for (MultipartUpload upload : oldUploads) {
            this.abortS3MultipartUpload(client, bucket, upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MultipartUpload> getS3AgeoffListAndAgeoffLocalState(ProcessContext context, S3Client client, long now, String bucket) {
        long ageoffInterval = context.getProperty(MULTIPART_S3_AGEOFF_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS);
        Long maxAge = context.getProperty(MULTIPART_S3_MAX_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        long ageCutoff = now - maxAge;
        ArrayList<MultipartUpload> ageoffList = new ArrayList<MultipartUpload>();
        if (this.lastS3AgeOff.get() < now - ageoffInterval && this.s3BucketLock.tryLock()) {
            try {
                ListMultipartUploadsRequest listRequest = (ListMultipartUploadsRequest)ListMultipartUploadsRequest.builder().bucket(bucket).build();
                ListMultipartUploadsResponse listResponse = client.listMultipartUploads(listRequest);
                for (MultipartUpload upload : listResponse.uploads()) {
                    long uploadTime = upload.initiated().toEpochMilli();
                    if (uploadTime >= ageCutoff) continue;
                    ageoffList.add(upload);
                }
                this.ageoffLocalState(ageCutoff);
                this.lastS3AgeOff.set(System.currentTimeMillis());
            }
            catch (SdkException e) {
                S3Exception s3e;
                if (e instanceof S3Exception && (s3e = (S3Exception)((Object)e)).statusCode() == 403 && s3e.awsErrorDetails().errorCode().equals("AccessDenied")) {
                    this.getLogger().warn("AccessDenied checking S3 Multipart Upload list for {}: {} ** The configured user does not have the s3:ListBucketMultipartUploads permission for this bucket, S3 ageoff cannot occur without this permission.  Next ageoff check time is being advanced by interval to prevent checking on every upload **", new Object[]{bucket, e.getMessage()});
                    this.lastS3AgeOff.set(System.currentTimeMillis());
                } else {
                    this.getLogger().error("Error checking S3 Multipart Upload list for {}", new Object[]{bucket, e});
                }
            }
            finally {
                this.s3BucketLock.unlock();
            }
        }
        return ageoffList;
    }

    protected void abortS3MultipartUpload(S3Client client, String bucket, MultipartUpload upload) {
        String key = upload.key();
        String uploadId = upload.uploadId();
        AbortMultipartUploadRequest abortRequest = (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(bucket).key(key).uploadId(uploadId).build();
        try {
            client.abortMultipartUpload(abortRequest);
            this.getLogger().info("Aborting out of date multipart upload, bucket {} key {} ID {}, initiated {}", new Object[]{bucket, key, uploadId, upload.initiated()});
        }
        catch (SdkException e) {
            this.getLogger().info("Error trying to abort multipart upload from bucket {} with key {} and ID {}: {}", new Object[]{bucket, key, uploadId, e.getMessage()});
        }
    }

    private List<Tag> getObjectTags(ProcessContext context, FlowFile flowFile) {
        String prefix = context.getProperty(OBJECT_TAGS_PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        ArrayList<Tag> objectTags = new ArrayList<Tag>();
        Map attributesMap = flowFile.getAttributes();
        attributesMap.entrySet().stream().filter(attribute -> ((String)attribute.getKey()).startsWith(prefix)).forEach(attribute -> {
            String tagKey = (String)attribute.getKey();
            String tagValue = (String)attribute.getValue();
            if (context.getProperty(REMOVE_TAG_PREFIX).asBoolean().booleanValue()) {
                tagKey = tagKey.replace(prefix, "");
            }
            objectTags.add((Tag)Tag.builder().key(tagKey).value(tagValue).build());
        });
        return objectTags;
    }

    protected static class MultipartState
    implements Serializable {
        private static final long serialVersionUID = 9006072180563519740L;
        private static final String SEPARATOR = "#";
        private String uploadId;
        private Long filePosition;
        private List<CompletedPart> completedParts;
        private Long partSize;
        private StorageClass storageClass;
        private Long contentLength;
        private Long timestamp;

        public MultipartState() {
            this.uploadId = "";
            this.filePosition = 0L;
            this.completedParts = new ArrayList<CompletedPart>();
            this.partSize = 0L;
            this.storageClass = StorageClass.STANDARD;
            this.contentLength = 0L;
            this.timestamp = System.currentTimeMillis();
        }

        public MultipartState(String buf) {
            String[] fields = buf.split(SEPARATOR);
            this.uploadId = fields[0];
            this.filePosition = Long.parseLong(fields[1]);
            this.completedParts = new ArrayList<CompletedPart>();
            for (String part : fields[2].split(",")) {
                if (part == null || part.isEmpty()) continue;
                String[] partFields = part.split("/");
                this.completedParts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(Integer.parseInt(partFields[0]))).eTag(partFields[1]).build());
            }
            this.partSize = Long.parseLong(fields[3]);
            this.storageClass = StorageClass.fromValue((String)fields[4]);
            this.contentLength = Long.parseLong(fields[5]);
            this.timestamp = Long.parseLong(fields[6]);
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public void setUploadId(String id) {
            this.uploadId = id;
        }

        public Long getFilePosition() {
            return this.filePosition;
        }

        public void setFilePosition(Long pos) {
            this.filePosition = pos;
        }

        public List<CompletedPart> getCompletedParts() {
            return this.completedParts;
        }

        public void addCompletedPart(CompletedPart completedPart) {
            this.completedParts.add(completedPart);
        }

        public Long getPartSize() {
            return this.partSize;
        }

        public void setPartSize(Long size) {
            this.partSize = size;
        }

        public StorageClass getStorageClass() {
            return this.storageClass;
        }

        public void setStorageClass(StorageClass aClass) {
            this.storageClass = aClass;
        }

        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(Long length) {
            this.contentLength = length;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.uploadId).append(SEPARATOR).append(this.filePosition.toString()).append(SEPARATOR);
            if (!this.completedParts.isEmpty()) {
                boolean first = true;
                for (CompletedPart completedPart : this.completedParts) {
                    if (!first) {
                        buf.append(",");
                    } else {
                        first = false;
                    }
                    buf.append(String.format("%d/%s", completedPart.partNumber(), completedPart.eTag()));
                }
            }
            buf.append(SEPARATOR).append(this.partSize.toString()).append(SEPARATOR).append(this.storageClass.toString()).append(SEPARATOR).append(this.contentLength.toString()).append(SEPARATOR).append(this.timestamp.toString());
            return buf.toString();
        }
    }
}

