/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.GetS3ObjectTags;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.PutS3Object;
import org.apache.nifi.processors.aws.s3.TagS3Object;
import org.apache.nifi.processors.aws.s3.api.MetadataTarget;
import org.apache.nifi.processors.aws.s3.util.S3Util;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;

@Tags(value={"Amazon", "S3", "AWS", "Archive", "Exists"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Check for the existence of an Object in S3 and fetch its Metadata without attempting to download it. This processor can be used as a router for workflows that need to check on an Object in S3 before proceeding with data processing")
@SeeAlso(value={PutS3Object.class, DeleteS3Object.class, ListS3.class, TagS3Object.class, DeleteS3Object.class, FetchS3Object.class, GetS3ObjectTags.class})
public class GetS3ObjectMetadata
extends AbstractS3Processor {
    static final PropertyDescriptor METADATA_TARGET = new PropertyDescriptor.Builder().name("Metadata Target").description("This determines where the metadata will be written when found.").addValidator(Validator.VALID).required(true).allowableValues(MetadataTarget.class).defaultValue((DescribedValue)MetadataTarget.ATTRIBUTES).build();
    static final PropertyDescriptor ATTRIBUTE_INCLUDE_PATTERN = new PropertyDescriptor.Builder().name("Metadata Attribute Include Pattern").description("A regular expression pattern to use for determining which object metadata entries are included as FlowFile\nattributes. This pattern is only applied to the 'found' relationship and will not be used to\nfilter the error attributes in the 'failure' relationship.\n").addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(".*").dependsOn(METADATA_TARGET, (DescribedValue)MetadataTarget.ATTRIBUTES, new DescribedValue[0]).build();
    static final PropertyDescriptor VERSION_ID = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractS3Processor.VERSION_ID).description("The Version of the Object for which to retrieve Metadata").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(METADATA_TARGET, ATTRIBUTE_INCLUDE_PATTERN, BUCKET_WITH_DEFAULT_VALUE, KEY, VERSION_ID, AWS_CREDENTIALS_PROVIDER_SERVICE, RegionUtil.REGION, RegionUtil.CUSTOM_REGION_WITH_FF_EL, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, PROXY_CONFIGURATION_SERVICE);
    static final Relationship REL_FOUND = new Relationship.Builder().name("found").description("An object was found in the bucket at the supplied key").build();
    static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("No object was found in the bucket the supplied key").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_FOUND, REL_NOT_FOUND, REL_FAILURE);
    private static final String ATTRIBUTE_FORMAT = "s3.%s";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.removeProperty(FULL_CONTROL_USER_LIST.getName());
        config.removeProperty(READ_USER_LIST.getName());
        config.removeProperty(READ_ACL_LIST.getName());
        config.removeProperty("Owner");
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String attributeRegex;
        S3Client client;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            client = (S3Client)this.getClient(context, flowFile.getAttributes());
        }
        catch (Exception e2) {
            this.getLogger().error("Failed to initialize S3 client", (Throwable)e2);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        String bucket = context.getProperty(BUCKET_WITH_DEFAULT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        String version = context.getProperty(VERSION_ID).evaluateAttributeExpressions(flowFile).getValue();
        MetadataTarget metadataTarget = (MetadataTarget)context.getProperty(METADATA_TARGET).asAllowableValue(MetadataTarget.class);
        Pattern attributePattern = metadataTarget == MetadataTarget.ATTRIBUTES ? ((attributeRegex = context.getProperty(ATTRIBUTE_INCLUDE_PATTERN).evaluateAttributeExpressions(flowFile).getValue()) == null ? null : Pattern.compile(attributeRegex)) : null;
        try {
            Relationship relationship;
            try {
                HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(key).versionId(S3Util.nullIfBlank(version)).build();
                HeadObjectResponse response = client.headObject(request);
                Map<String, Object> metadata = GetS3ObjectMetadata.extractMetadata(response);
                if (MetadataTarget.ATTRIBUTES == metadataTarget) {
                    Map<String, String> newAttributes = metadata.entrySet().stream().filter(e -> {
                        if (attributePattern == null) {
                            return true;
                        }
                        return attributePattern.matcher((CharSequence)e.getKey()).find();
                    }).collect(Collectors.toMap(e -> ATTRIBUTE_FORMAT.formatted(e.getKey()), e -> {
                        String attributeValue;
                        Object value = e.getValue();
                        if (value instanceof Instant) {
                            Instant instantValue = (Instant)value;
                            attributeValue = Long.toString(instantValue.toEpochMilli());
                        } else {
                            attributeValue = value.toString();
                        }
                        return attributeValue;
                    }));
                    flowFile = session.putAllAttributes(flowFile, newAttributes);
                } else if (MetadataTarget.FLOWFILE_BODY == metadataTarget) {
                    flowFile = session.write(flowFile, outputStream -> MAPPER.writeValue(outputStream, (Object)metadata));
                }
                relationship = REL_FOUND;
            }
            catch (S3Exception e3) {
                if (e3.statusCode() == 404) {
                    relationship = REL_NOT_FOUND;
                    flowFile = this.extractExceptionDetails((Exception)((Object)e3), session, flowFile);
                }
                throw e3;
            }
            session.transfer(flowFile, relationship);
        }
        catch (IllegalArgumentException | SdkException e4) {
            this.getLogger().error("Failed to get S3 Object Metadata from Bucket [{}] Key [{}] Version [{}]", new Object[]{bucket, key, version, e4});
            flowFile = this.extractExceptionDetails((Exception)e4, session, flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private static Map<String, Object> extractMetadata(HeadObjectResponse head) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (head.contentLength() != null) {
            metadata.put("Content-Length", head.contentLength());
        }
        if (head.contentType() != null) {
            metadata.put("Content-Type", head.contentType());
        }
        if (head.eTag() != null) {
            metadata.put("ETag", S3Util.sanitizeETag(head.eTag()));
        }
        if (head.lastModified() != null) {
            metadata.put("Last-Modified", head.lastModified());
        }
        if (head.cacheControl() != null) {
            metadata.put("Cache-Control", head.cacheControl());
        }
        if (head.contentEncoding() != null) {
            metadata.put("Content-Encoding", head.contentEncoding());
        }
        if (head.contentDisposition() != null) {
            metadata.put("Content-Disposition", head.contentDisposition());
        }
        if (head.contentLanguage() != null) {
            metadata.put("Content-Language", head.contentLanguage());
        }
        if (head.acceptRanges() != null) {
            metadata.put("Accept-Ranges", head.acceptRanges());
        }
        if (head.serverSideEncryption() != null) {
            metadata.put("x-amz-server-side-encryption", head.serverSideEncryptionAsString());
        }
        if (head.ssekmsKeyId() != null) {
            metadata.put("x-amz-server-side-encryption-aws-kms-key-id", head.ssekmsKeyId());
        }
        if (head.storageClass() != null) {
            metadata.put("x-amz-storage-class", head.storageClassAsString());
        }
        if (head.versionId() != null) {
            metadata.put("x-amz-version-id", head.versionId());
        }
        if (head.tagCount() != null) {
            metadata.put("x-amz-tagging-count", head.tagCount());
        }
        head.metadata().forEach((key, value) -> metadata.put(key.toLowerCase(), value));
        return metadata;
    }
}

