/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.rds;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.api.DatabasePasswordProvider;
import org.apache.nifi.dbcp.api.DatabasePasswordRequestContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.credentials.provider.AwsCredentialsProviderService;
import org.apache.nifi.processors.aws.region.RegionUtil;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsUtilities;
import software.amazon.awssdk.services.rds.model.GenerateAuthenticationTokenRequest;

@Tags(value={"aws", "rds", "iam", "jdbc", "password"})
@CapabilityDescription(value="Generates Amazon RDS IAM authentication tokens each time a JDBC connection is requested.\nThe generated token replaces the database user password so that NiFi does not need to store long-lived credentials inside DBCP services.\n")
public class AwsRdsIamDatabasePasswordProvider
extends AbstractControllerService
implements DatabasePasswordProvider {
    static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("AWS Credentials Provider Service").description("Controller Service that provides the AWS credentials used to sign IAM authentication requests.").identifiesControllerService(AwsCredentialsProviderService.class).required(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(AWS_CREDENTIALS_PROVIDER_SERVICE, RegionUtil.REGION, RegionUtil.CUSTOM_REGION);
    private volatile AwsCredentialsProvider awsCredentialsProvider;
    private volatile RdsUtilities rdsUtilities;
    private volatile Region awsRegion;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (RegionUtil.isDynamicRegion((PropertyContext)validationContext)) {
            results.add(new ValidationResult.Builder().subject(RegionUtil.REGION.getDisplayName()).valid(false).explanation("FlowFile or attribute-driven regions are not supported").build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        AwsCredentialsProviderService credentialsService = (AwsCredentialsProviderService)context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AwsCredentialsProviderService.class);
        this.awsCredentialsProvider = credentialsService.getAwsCredentialsProvider();
        this.awsRegion = RegionUtil.getRegion((PropertyContext)context);
        this.rdsUtilities = this.createRdsUtilities(this.awsRegion, this.awsCredentialsProvider);
    }

    @OnDisabled
    public void onDisabled() {
        this.awsCredentialsProvider = null;
        this.rdsUtilities = null;
        this.awsRegion = null;
    }

    public char[] getPassword(DatabasePasswordRequestContext requestContext) {
        String token;
        Objects.requireNonNull(requestContext, "Database Password Request Context required");
        ParsedEndpoint parsedEndpoint = this.parseEndpoint(requestContext.getJdbcUrl());
        String hostname = this.resolveHostname(parsedEndpoint, requestContext.getJdbcUrl());
        int port = this.resolvePort(parsedEndpoint);
        String username = this.resolveUsername(requestContext.getDatabaseUser());
        GenerateAuthenticationTokenRequest tokenRequest = GenerateAuthenticationTokenRequest.builder().hostname(hostname).port(port).username(username).build();
        try {
            token = this.rdsUtilities.generateAuthenticationToken(tokenRequest);
        }
        catch (RuntimeException e) {
            throw new ProcessException("Failed to generate RDS IAM authentication token", (Throwable)e);
        }
        return token.toCharArray();
    }

    protected RdsUtilities createRdsUtilities(Region region, AwsCredentialsProvider credentialsProvider) {
        return RdsUtilities.builder().region(region).credentialsProvider(credentialsProvider).build();
    }

    private String resolveHostname(ParsedEndpoint parsedEndpoint, String jdbcUrl) {
        String hostname = parsedEndpoint.hostname();
        if (StringUtils.isBlank((CharSequence)hostname)) {
            throw new ProcessException("Database Endpoint not configured and JDBC URL [%s] does not contain a hostname".formatted(jdbcUrl));
        }
        return hostname;
    }

    private int resolvePort(ParsedEndpoint parsedEndpoint) {
        Integer parsedPort = parsedEndpoint.port();
        if (parsedPort == null) {
            throw new IllegalStateException("Database Endpoint not configured and JDBC URL does not contain a port number");
        }
        return parsedPort;
    }

    private String resolveUsername(String contextUser) {
        String username = StringUtils.trimToNull((String)contextUser);
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new ProcessException("Database Username not configured and referencing DBCP service did not provide a username");
        }
        return username;
    }

    private ParsedEndpoint parseEndpoint(String jdbcUrl) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            return ParsedEndpoint.EMPTY;
        }
        String normalized = jdbcUrl.startsWith("jdbc:") ? jdbcUrl.substring(5) : jdbcUrl;
        try {
            URI uri = URI.create(normalized);
            String host = uri.getHost();
            int port = uri.getPort();
            return new ParsedEndpoint(host, port >= 0 ? Integer.valueOf(port) : null);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().debug("Unable to parse JDBC URL [{}] for hostname and port", new Object[]{jdbcUrl, e});
            return ParsedEndpoint.EMPTY;
        }
    }

    private record ParsedEndpoint(String hostname, Integer port) {
        private static final ParsedEndpoint EMPTY = new ParsedEndpoint(null, null);
    }
}

