/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import java.io.File;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.PropertiesCredentialsProvider;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderControllerService;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class FileCredentialsStrategy
extends AbstractCredentialsStrategy {
    public FileCredentialsStrategy() {
        super("Credentials File", new PropertyDescriptor[]{AWSCredentialsProviderControllerService.CREDENTIALS_FILE});
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        String credentialsFile = propertyContext.getProperty(AWSCredentialsProviderControllerService.CREDENTIALS_FILE).getValue();
        return new PropertiesCredentialsProvider(new File(credentialsFile));
    }
}

