/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.AmazonS3EncryptionService;
import org.apache.nifi.processors.aws.s3.CopyS3Object;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.GetS3ObjectMetadata;
import org.apache.nifi.processors.aws.s3.GetS3ObjectTags;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.TagS3Object;
import org.apache.nifi.processors.aws.util.RegionUtilV1;
import org.apache.nifi.processors.transfer.ResourceTransferProperties;
import org.apache.nifi.processors.transfer.ResourceTransferSource;
import org.apache.nifi.processors.transfer.ResourceTransferUtils;

@SupportsBatching
@SeeAlso(value={FetchS3Object.class, DeleteS3Object.class, ListS3.class, CopyS3Object.class, GetS3ObjectMetadata.class, GetS3ObjectTags.class, TagS3Object.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "S3", "AWS", "Archive", "Put"})
@CapabilityDescription(value="Writes the contents of a FlowFile as an S3 Object to an Amazon S3 Bucket.")
@DynamicProperty(name="The name of a User-Defined Metadata field to add to the S3 Object", value="The value of a User-Defined Metadata field to add to the S3 Object", description="Allows user-defined metadata to be added to the S3 object as key/value pairs", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@ReadsAttribute(attribute="filename", description="Uses the FlowFile's filename as the filename for the S3 object")
@WritesAttributes(value={@WritesAttribute(attribute="s3.url", description="The URL that can be used to access the S3 object"), @WritesAttribute(attribute="s3.bucket", description="The S3 bucket where the Object was put in S3"), @WritesAttribute(attribute="s3.key", description="The S3 key within where the Object was put in S3"), @WritesAttribute(attribute="s3.contenttype", description="The S3 content type of the S3 Object that put in S3"), @WritesAttribute(attribute="s3.version", description="The version of the S3 Object that was put to S3"), @WritesAttribute(attribute="s3.exception", description="The class name of the exception thrown during processor execution"), @WritesAttribute(attribute="s3.additionalDetails", description="The S3 supplied detail from the failed operation"), @WritesAttribute(attribute="s3.statusCode", description="The HTTP error code (if available) from the failed operation"), @WritesAttribute(attribute="s3.errorCode", description="The S3 moniker of the failed operation"), @WritesAttribute(attribute="s3.errorMessage", description="The S3 exception message from the failed operation"), @WritesAttribute(attribute="s3.etag", description="The ETag of the S3 Object"), @WritesAttribute(attribute="s3.contentdisposition", description="The content disposition of the S3 Object that put in S3"), @WritesAttribute(attribute="s3.cachecontrol", description="The cache-control header of the S3 Object"), @WritesAttribute(attribute="s3.uploadId", description="The uploadId used to upload the Object to S3"), @WritesAttribute(attribute="s3.expiration", description="A human-readable form of the expiration date of the S3 object, if one is set"), @WritesAttribute(attribute="s3.sseAlgorithm", description="The server side encryption algorithm of the object"), @WritesAttribute(attribute="s3.usermetadata", description="A human-readable form of the User Metadata of the S3 object, if any was set"), @WritesAttribute(attribute="s3.encryptionStrategy", description="The name of the encryption strategy, if any was set")})
public class PutS3Object
extends AbstractS3Processor {
    public static final long MIN_S3_PART_SIZE = 0x3200000L;
    public static final long MAX_S3_PUTOBJECT_SIZE = 0x140000000L;
    public static final String NO_SERVER_SIDE_ENCRYPTION = "None";
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final Set<String> STORAGE_CLASSES = Collections.unmodifiableSortedSet(new TreeSet(Arrays.stream(StorageClass.values()).map(Enum::name).collect(Collectors.toSet())));
    public static final PropertyDescriptor EXPIRATION_RULE_ID = new PropertyDescriptor.Builder().name("Expiration Time Rule").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content Type").displayName("Content Type").description("Sets the Content-Type HTTP header indicating the type of content stored in the associated object. The value of this header is a standard MIME type.\nAWS S3 Java client will attempt to determine the correct content type if one hasn't been set yet. Users are responsible for ensuring a suitable content type is set when uploading streams. If no content type is provided and cannot be determined by the filename, the default content type \"application/octet-stream\" will be used.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONTENT_DISPOSITION = new PropertyDescriptor.Builder().name("Content Disposition").displayName("Content Disposition").description("Sets the Content-Disposition HTTP header indicating if the content is intended to be displayed inline or should be downloaded.\n Possible values are 'inline' or 'attachment'. If this property is not specified, object's content-disposition will be set to filename. When 'attachment' is selected, '; filename=' plus object key are automatically appended to form final value 'attachment; filename=\"filename.jpg\"'.").required(false).allowableValues(new String[]{"inline", "attachment"}).build();
    public static final PropertyDescriptor CACHE_CONTROL = new PropertyDescriptor.Builder().name("Cache Control").displayName("Cache Control").description("Sets the Cache-Control HTTP header indicating the caching directives of the associated object. Multiple directives are comma-separated.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor STORAGE_CLASS = new PropertyDescriptor.Builder().name("Storage Class").required(true).allowableValues(STORAGE_CLASSES).defaultValue(StorageClass.Standard.name()).build();
    public static final PropertyDescriptor MULTIPART_THRESHOLD = new PropertyDescriptor.Builder().name("Multipart Threshold").description("Specifies the file size threshold for switch from the PutS3Object API to the PutS3MultipartUpload API.  Flow files bigger than this limit will be sent using the stateful multipart process. The valid range is 50MB to 5GB.").required(true).defaultValue("5 GB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)0x3200000L, (long)0x140000000L)).build();
    public static final PropertyDescriptor MULTIPART_PART_SIZE = new PropertyDescriptor.Builder().name("Multipart Part Size").description("Specifies the part size for use when the PutS3Multipart Upload API is used. Flow files will be broken into chunks of this size for the upload process, but the last part sent can be smaller since it is not padded. The valid range is 50MB to 5GB.").required(true).defaultValue("5 GB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)0x3200000L, (long)0x140000000L)).build();
    public static final PropertyDescriptor MULTIPART_S3_AGEOFF_INTERVAL = new PropertyDescriptor.Builder().name("Multipart Upload AgeOff Interval").description("Specifies the interval at which existing multipart uploads in AWS S3 will be evaluated for ageoff.  When processor is triggered it will initiate the ageoff evaluation if this interval has been exceeded.").required(true).defaultValue("60 min").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor MULTIPART_S3_MAX_AGE = new PropertyDescriptor.Builder().name("Multipart Upload Max Age Threshold").description("Specifies the maximum age for existing multipart uploads in AWS S3.  When the ageoff process occurs, any upload older than this threshold will be aborted.").required(true).defaultValue("7 days").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor SERVER_SIDE_ENCRYPTION = new PropertyDescriptor.Builder().name("server-side-encryption").displayName("Server Side Encryption").description("Specifies the algorithm used for server side encryption.").required(true).allowableValues(new String[]{"None", ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION}).defaultValue("None").build();
    public static final PropertyDescriptor OBJECT_TAGS_PREFIX = new PropertyDescriptor.Builder().name("s3-object-tags-prefix").displayName("Object Tags Prefix").description("Specifies the prefix which would be scanned against the incoming FlowFile's attributes and the matching attribute's name and value would be considered as the outgoing S3 object's Tag name and Tag value respectively. For Ex: If the incoming FlowFile carries the attributes tagS3country, tagS3PII, the tag prefix to be specified would be 'tagS3'").required(false).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor REMOVE_TAG_PREFIX = new PropertyDescriptor.Builder().name("s3-object-remove-tags-prefix").displayName("Remove Tag Prefix").description("If set to 'True', the value provided for '" + OBJECT_TAGS_PREFIX.getDisplayName() + "' will be removed from the attribute(s) and then considered as the Tag name. For ex: If the incoming FlowFile carries the attributes tagS3country, tagS3PII and the prefix is set to 'tagS3' then the corresponding tag values would be 'country' and 'PII'").allowableValues(new DescribedValue[]{new AllowableValue("true", "True"), new AllowableValue("false", "False")}).defaultValue("false").build();
    public static final PropertyDescriptor MULTIPART_TEMP_DIR = new PropertyDescriptor.Builder().name("s3-temporary-directory-multipart").displayName("Temporary Directory Multipart State").description("Directory in which, for multipart uploads, the processor will locally save the state tracking the upload ID and parts uploaded which must both be provided to complete the upload.").required(true).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).defaultValue("${java.io.tmpdir}").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BUCKET_WITH_DEFAULT_VALUE, KEY, RegionUtilV1.S3_REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, ResourceTransferProperties.RESOURCE_TRANSFER_SOURCE, ResourceTransferProperties.FILE_RESOURCE_SERVICE, STORAGE_CLASS, ENCRYPTION_SERVICE, SERVER_SIDE_ENCRYPTION, CONTENT_TYPE, CONTENT_DISPOSITION, CACHE_CONTROL, OBJECT_TAGS_PREFIX, REMOVE_TAG_PREFIX, TIMEOUT, EXPIRATION_RULE_ID, FULL_CONTROL_USER_LIST, READ_USER_LIST, WRITE_USER_LIST, READ_ACL_LIST, WRITE_ACL_LIST, OWNER, CANNED_ACL, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, SIGNER_OVERRIDE, S3_CUSTOM_SIGNER_CLASS_NAME, S3_CUSTOM_SIGNER_MODULE_LOCATION, MULTIPART_THRESHOLD, MULTIPART_PART_SIZE, MULTIPART_S3_AGEOFF_INTERVAL, MULTIPART_S3_MAX_AGE, MULTIPART_TEMP_DIR, USE_CHUNKED_ENCODING, USE_PATH_STYLE_ACCESS, PROXY_CONFIGURATION_SERVICE);
    static final String S3_BUCKET_KEY = "s3.bucket";
    static final String S3_OBJECT_KEY = "s3.key";
    static final String S3_CONTENT_TYPE = "s3.contenttype";
    static final String S3_CONTENT_DISPOSITION = "s3.contentdisposition";
    static final String S3_UPLOAD_ID_ATTR_KEY = "s3.uploadId";
    static final String S3_VERSION_ATTR_KEY = "s3.version";
    static final String S3_ETAG_ATTR_KEY = "s3.etag";
    static final String S3_CACHE_CONTROL = "s3.cachecontrol";
    static final String S3_EXPIRATION_ATTR_KEY = "s3.expiration";
    static final String S3_STORAGECLASS_ATTR_KEY = "s3.storeClass";
    static final String S3_USERMETA_ATTR_KEY = "s3.usermetadata";
    static final String S3_API_METHOD_ATTR_KEY = "s3.apimethod";
    static final String S3_API_METHOD_PUTOBJECT = "putobject";
    static final String S3_API_METHOD_MULTIPARTUPLOAD = "multipartupload";
    static final String S3_SSE_ALGORITHM = "s3.sseAlgorithm";
    static final String S3_ENCRYPTION_STRATEGY = "s3.encryptionStrategy";
    static final String S3_PROCESS_UNSCHEDULED_MESSAGE = "Processor unscheduled, stopping upload";
    private volatile String tempDirMultipart = System.getProperty("java.io.tmpdir");
    private final Lock s3BucketLock = new ReentrantLock();
    private final AtomicLong lastS3AgeOff = new AtomicLong(0L);

    @OnScheduled
    public void setTempDir(ProcessContext context) {
        this.tempDirMultipart = context.getProperty(MULTIPART_TEMP_DIR).evaluateAttributeExpressions().getValue();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    protected File getPersistenceFile() {
        return new File(this.tempDirMultipart + File.separator + this.getIdentifier());
    }

    protected boolean localUploadExistsInS3(AmazonS3 s3, String bucket, MultipartState localState) {
        ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(bucket);
        MultipartUploadListing listing = s3.listMultipartUploads(listRequest);
        for (MultipartUpload upload : listing.getMultipartUploads()) {
            if (!upload.getUploadId().equals(localState.getUploadId())) continue;
            return true;
        }
        return false;
    }

    protected synchronized MultipartState getLocalStateIfInS3(AmazonS3 s3, String bucket, String s3ObjectKey) throws IOException {
        MultipartState currState = this.getLocalState(s3ObjectKey);
        if (currState == null) {
            return null;
        }
        if (this.localUploadExistsInS3(s3, bucket, currState)) {
            this.getLogger().info("Local state for {} loaded with uploadId {} and {} partETags", new Object[]{s3ObjectKey, currState.getUploadId(), currState.getPartETags().size()});
            return currState;
        }
        this.getLogger().info("Local state for {} with uploadId {} does not exist in S3, deleting local state", new Object[]{s3ObjectKey, currState.getUploadId()});
        this.persistLocalState(s3ObjectKey, null);
        return null;
    }

    protected synchronized MultipartState getLocalState(String s3ObjectKey) throws IOException {
        File persistenceFile = this.getPersistenceFile();
        if (persistenceFile.exists()) {
            String localSerialState;
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
            catch (IOException ioe) {
                this.getLogger().warn("Assuming no local state and restarting upload since failed to recover local state for {}", new Object[]{s3ObjectKey, ioe});
                return null;
            }
            if (props.containsKey(s3ObjectKey) && (localSerialState = props.getProperty(s3ObjectKey)) != null) {
                try {
                    return new MultipartState(localSerialState);
                }
                catch (RuntimeException rte) {
                    this.getLogger().warn("Failed to recover local state for {} due to corrupt data in state.", new Object[]{s3ObjectKey, rte});
                    return null;
                }
            }
        }
        return null;
    }

    protected synchronized void persistLocalState(String s3ObjectKey, MultipartState currState) throws IOException {
        String currStateStr = currState == null ? null : currState.toString();
        File persistenceFile = this.getPersistenceFile();
        File parentDir = persistenceFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Persistence directory (" + parentDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        Properties props = new Properties();
        if (persistenceFile.exists()) {
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
        }
        if (currStateStr != null) {
            currState.setTimestamp(System.currentTimeMillis());
            props.setProperty(s3ObjectKey, currStateStr);
        } else {
            props.remove(s3ObjectKey);
        }
        if (!props.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(persistenceFile);){
                props.store(fos, null);
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not store state {}", new Object[]{persistenceFile.getAbsolutePath(), ioe});
            }
        } else if (persistenceFile.exists()) {
            try {
                Files.delete(persistenceFile.toPath());
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not remove state file {}", new Object[]{persistenceFile.getAbsolutePath(), ioe});
            }
        }
    }

    protected synchronized void removeLocalState(String s3ObjectKey) throws IOException {
        this.persistLocalState(s3ObjectKey, null);
    }

    private synchronized void ageoffLocalState(long ageCutoff) {
        File persistenceFile = this.getPersistenceFile();
        if (persistenceFile.exists()) {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
            catch (IOException ioe) {
                this.getLogger().warn("Failed to ageoff remove local state", (Throwable)ioe);
                return;
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                MultipartState state;
                String key = (String)entry.getKey();
                String localSerialState = props.getProperty(key);
                if (localSerialState == null || (state = new MultipartState(localSerialState)).getTimestamp() >= ageCutoff) continue;
                this.getLogger().warn("Removing local state for {} due to exceeding ageoff time", new Object[]{key});
                try {
                    this.removeLocalState(key);
                }
                catch (IOException ioe) {
                    this.getLogger().warn("Failed to remove local state for {}", new Object[]{key, ioe});
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onTrigger(ProcessContext context, ProcessSession session) {
        flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            s3 = this.getS3Client(context, flowFile.getAttributes());
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize S3 client", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, PutS3Object.REL_FAILURE);
            return;
        }
        startNanos = System.nanoTime();
        bucket = context.getProperty(PutS3Object.BUCKET_WITH_DEFAULT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        key = context.getProperty(PutS3Object.KEY).evaluateAttributeExpressions(flowFile).getValue();
        cacheKey = this.getIdentifier() + "/" + bucket + "/" + key;
        ff = flowFile;
        attributes = new HashMap<String, Object>();
        ffFilename = (String)ff.getAttributes().get(CoreAttributes.FILENAME.key());
        resourceTransferSource = (ResourceTransferSource)context.getProperty(ResourceTransferProperties.RESOURCE_TRANSFER_SOURCE).asAllowableValue(ResourceTransferSource.class);
        attributes.put("s3.bucket", bucket);
        attributes.put("s3.key", key);
        multipartThreshold = context.getProperty(PutS3Object.MULTIPART_THRESHOLD).asDataSize(DataUnit.B).longValue();
        multipartPartSize = context.getProperty(PutS3Object.MULTIPART_PART_SIZE).asDataSize(DataUnit.B).longValue();
        now = System.currentTimeMillis();
        this.ageoffS3Uploads(context, (AmazonS3)s3, now, bucket);
        try {
            block78: {
                flowFileCopy = flowFile;
                optFileResource = ResourceTransferUtils.getFileResource((ResourceTransferSource)resourceTransferSource, (ProcessContext)context, (Map)flowFile.getAttributes());
                try {
                    in = optFileResource.map((Function<FileResource, InputStream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getInputStream(), (Lorg/apache/nifi/fileresource/service/api/FileResource;)Ljava/io/InputStream;)()).orElseGet((Supplier<InputStream>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onTrigger$0(org.apache.nifi.processor.ProcessSession org.apache.nifi.flowfile.FlowFile ), ()Ljava/io/InputStream;)((ProcessSession)session, (FlowFile)flowFileCopy));
                    try {
                        objectMetadata = new ObjectMetadata();
                        objectMetadata.setContentLength(optFileResource.map((Function<FileResource, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSize(), (Lorg/apache/nifi/fileresource/service/api/FileResource;)Ljava/lang/Long;)()).orElseGet((Supplier<Long>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getSize(), ()Ljava/lang/Long;)((FlowFile)ff)).longValue());
                        contentType = context.getProperty(PutS3Object.CONTENT_TYPE).evaluateAttributeExpressions(ff).getValue();
                        if (contentType != null) {
                            objectMetadata.setContentType(contentType);
                            attributes.put("s3.contenttype", contentType);
                        }
                        if ((cacheControl = context.getProperty(PutS3Object.CACHE_CONTROL).evaluateAttributeExpressions(ff).getValue()) != null) {
                            objectMetadata.setCacheControl(cacheControl);
                            attributes.put("s3.cachecontrol", cacheControl);
                        }
                        contentDisposition = context.getProperty(PutS3Object.CONTENT_DISPOSITION).getValue();
                        fileName = URLEncoder.encode(ff.getAttribute(CoreAttributes.FILENAME.key()), StandardCharsets.UTF_8);
                        if (contentDisposition != null && contentDisposition.equals("inline")) {
                            objectMetadata.setContentDisposition("inline");
                            attributes.put("s3.contentdisposition", "inline");
                        } else if (contentDisposition != null && contentDisposition.equals("attachment")) {
                            contentDispositionValue = "attachment; filename=\"" + fileName + "\"";
                            objectMetadata.setContentDisposition(contentDispositionValue);
                            attributes.put("s3.contentdisposition", contentDispositionValue);
                        } else {
                            objectMetadata.setContentDisposition(fileName);
                        }
                        expirationRule = context.getProperty(PutS3Object.EXPIRATION_RULE_ID).evaluateAttributeExpressions(ff).getValue();
                        if (expirationRule != null) {
                            objectMetadata.setExpirationTimeRuleId(expirationRule);
                        }
                        userMetadata = new HashMap<String, String>();
                        for (Map.Entry<K, V> entry : context.getProperties().entrySet()) {
                            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
                            value = context.getProperty((PropertyDescriptor)entry.getKey()).evaluateAttributeExpressions(ff).getValue();
                            userMetadata.put(((PropertyDescriptor)entry.getKey()).getName(), value);
                        }
                        serverSideEncryption = context.getProperty(PutS3Object.SERVER_SIDE_ENCRYPTION).getValue();
                        encryptionService = null;
                        if (!serverSideEncryption.equals("None")) {
                            objectMetadata.setSSEAlgorithm(serverSideEncryption);
                            attributes.put("s3.sseAlgorithm", serverSideEncryption);
                        } else {
                            encryptionService = (AmazonS3EncryptionService)context.getProperty(PutS3Object.ENCRYPTION_SERVICE).asControllerService(AmazonS3EncryptionService.class);
                        }
                        if (!userMetadata.isEmpty()) {
                            objectMetadata.setUserMetadata(userMetadata);
                        }
                        if (ff.getSize() <= multipartThreshold) {
                            request = new PutObjectRequest(bucket, key, in, objectMetadata);
                            if (encryptionService != null) {
                                encryptionService.configurePutObjectRequest(request, objectMetadata);
                                attributes.put("s3.encryptionStrategy", encryptionService.getStrategyName());
                            }
                            request.setStorageClass(StorageClass.valueOf((String)context.getProperty(PutS3Object.STORAGE_CLASS).getValue()));
                            acl = this.createACL(context, ff);
                            if (acl != null) {
                                request.setAccessControlList(acl);
                            }
                            if ((cannedAcl = this.createCannedACL(context, ff)) != null) {
                                request.withCannedAcl(cannedAcl);
                            }
                            if (context.getProperty(PutS3Object.OBJECT_TAGS_PREFIX).isSet()) {
                                request.setTagging(new ObjectTagging(this.getObjectTags(context, flowFileCopy)));
                            }
                            try {
                                result = s3.putObject(request);
                                if (result.getVersionId() != null) {
                                    attributes.put("s3.version", result.getVersionId());
                                }
                                if (result.getETag() != null) {
                                    attributes.put("s3.etag", result.getETag());
                                }
                                if (result.getExpirationTime() != null) {
                                    attributes.put("s3.expiration", result.getExpirationTime().toString());
                                }
                                if (result.getMetadata().getStorageClass() != null) {
                                    attributes.put("s3.storeClass", result.getMetadata().getStorageClass());
                                } else {
                                    attributes.put("s3.storeClass", StorageClass.Standard.toString());
                                }
                                if (!userMetadata.isEmpty()) {
                                    userMetaBldr = new StringBuilder();
                                    for (String userKey : userMetadata.keySet()) {
                                        userMetaBldr.append(userKey).append("=").append((String)userMetadata.get(userKey));
                                    }
                                    attributes.put("s3.usermetadata", userMetaBldr.toString());
                                }
                                attributes.put("s3.apimethod", "putobject");
                                break block78;
                            }
                            catch (AmazonClientException e) {
                                this.getLogger().info("Failure completing upload flowfile={} bucket={} key={} reason={}", new Object[]{ffFilename, bucket, key, e.getMessage()});
                                throw e;
                            }
                        }
                        try {
                            currentState = this.getLocalStateIfInS3((AmazonS3)s3, bucket, cacheKey);
                            if (currentState != null) {
                                if (!currentState.getPartETags().isEmpty()) {
                                    lastETag = currentState.getPartETags().get(currentState.getPartETags().size() - 1);
                                    this.getLogger().info("Resuming upload for flowfile='{}' bucket='{}' key='{}' uploadID='{}' filePosition='{}' partSize='{}' storageClass='{}' contentLength='{}' partsLoaded={} lastPart={}/{}", new Object[]{ffFilename, bucket, key, currentState.getUploadId(), currentState.getFilePosition(), currentState.getPartSize(), currentState.getStorageClass().toString(), currentState.getContentLength(), currentState.getPartETags().size(), Integer.toString(lastETag.getPartNumber()), lastETag.getETag()});
                                } else {
                                    this.getLogger().info("Resuming upload for flowfile='{}' bucket='{}' key='{}' uploadID='{}' filePosition='{}' partSize='{}' storageClass='{}' contentLength='{}' no partsLoaded", new Object[]{ffFilename, bucket, key, currentState.getUploadId(), currentState.getFilePosition(), currentState.getPartSize(), currentState.getStorageClass().toString(), currentState.getContentLength()});
                                }
                            } else {
                                currentState = new MultipartState();
                                currentState.setPartSize(multipartPartSize);
                                currentState.setStorageClass(StorageClass.valueOf((String)context.getProperty(PutS3Object.STORAGE_CLASS).getValue()));
                                currentState.setContentLength(ff.getSize());
                                this.persistLocalState(cacheKey, currentState);
                                this.getLogger().info("Starting new upload for flowfile='{}' bucket='{}' key='{}'", new Object[]{ffFilename, bucket, key});
                            }
                        }
                        catch (IOException e) {
                            this.getLogger().error("IOException initiating cache state while processing flow files", (Throwable)e);
                            throw e;
                        }
                        if (currentState.getUploadId().isEmpty()) {
                            initiateRequest = new InitiateMultipartUploadRequest(bucket, key, objectMetadata);
                            if (encryptionService != null) {
                                encryptionService.configureInitiateMultipartUploadRequest(initiateRequest, objectMetadata);
                                attributes.put("s3.encryptionStrategy", encryptionService.getStrategyName());
                            }
                            initiateRequest.setStorageClass(currentState.getStorageClass());
                            acl = this.createACL(context, ff);
                            if (acl != null) {
                                initiateRequest.setAccessControlList(acl);
                            }
                            if ((cannedAcl = this.createCannedACL(context, ff)) != null) {
                                initiateRequest.withCannedACL(cannedAcl);
                            }
                            if (context.getProperty(PutS3Object.OBJECT_TAGS_PREFIX).isSet()) {
                                initiateRequest.setTagging(new ObjectTagging(this.getObjectTags(context, flowFileCopy)));
                            }
                            try {
                                initiateResult = s3.initiateMultipartUpload(initiateRequest);
                                currentState.setUploadId(initiateResult.getUploadId());
                                currentState.getPartETags().clear();
                                try {
                                    this.persistLocalState(cacheKey, currentState);
                                }
                                catch (Exception e) {
                                    this.getLogger().info("Exception saving cache state while processing flow file", (Throwable)e);
                                    throw new ProcessException("Exception saving cache state", (Throwable)e);
                                }
                                this.getLogger().info("Success initiating upload flowfile={} available={} position={} length={} bucket={} key={} uploadId={}", new Object[]{ffFilename, in.available(), currentState.getFilePosition(), currentState.getContentLength(), bucket, key, currentState.getUploadId()});
                                if (initiateResult.getUploadId() == null) ** GOTO lbl189
                                attributes.put("s3.uploadId", initiateResult.getUploadId());
                            }
                            catch (AmazonClientException e) {
                                this.getLogger().info("Failure initiating upload flowfile={} bucket={} key={}", new Object[]{ffFilename, bucket, key, e});
                                throw e;
                            }
                        } else if (currentState.getFilePosition() > 0L) {
                            try {
                                skipped = in.skip(currentState.getFilePosition());
                                if (skipped != currentState.getFilePosition()) {
                                    this.getLogger().info("Failure skipping to resume upload flowfile={} bucket={} key={} position={} skipped={}", new Object[]{ffFilename, bucket, key, currentState.getFilePosition(), skipped});
                                }
                            }
                            catch (Exception e) {
                                this.getLogger().info("Failure skipping to resume upload flowfile={} bucket={} key={} position={}", new Object[]{ffFilename, bucket, key, currentState.getFilePosition(), e});
                                throw new ProcessException((Throwable)e);
                            }
                        }
lbl189:
                        // 5 sources

                        part = currentState.getPartETags().size() + 1;
                        while (currentState.getFilePosition() < currentState.getContentLength()) {
                            if (!this.isScheduled()) {
                                throw new IOException("Processor unscheduled, stopping upload flowfile=" + ffFilename + " part=" + part + " uploadId=" + currentState.getUploadId());
                            }
                            thisPartSize = Math.min(currentState.getPartSize(), currentState.getContentLength() - currentState.getFilePosition());
                            isLastPart = currentState.getContentLength() == currentState.getFilePosition() + thisPartSize;
                            uploadRequest = new UploadPartRequest().withBucketName(bucket).withKey(key).withUploadId(currentState.getUploadId()).withInputStream(in).withPartNumber(part).withPartSize(thisPartSize).withLastPart(isLastPart);
                            if (encryptionService != null) {
                                encryptionService.configureUploadPartRequest(uploadRequest, objectMetadata);
                            }
                            try {
                                uploadPartResult = s3.uploadPart(uploadRequest);
                                currentState.addPartETag(uploadPartResult.getPartETag());
                                currentState.setFilePosition(currentState.getFilePosition() + thisPartSize);
                                try {
                                    this.persistLocalState(cacheKey, currentState);
                                }
                                catch (Exception e) {
                                    this.getLogger().info("Exception saving cache state processing flow file", (Throwable)e);
                                }
                                available = 0;
                                try {
                                    available = in.available();
                                }
                                catch (IOException var38_63) {
                                    // empty catch block
                                }
                                this.getLogger().info("Success uploading part flowfile={} part={} available={} etag={} uploadId={}", new Object[]{ffFilename, part, available, uploadPartResult.getETag(), currentState.getUploadId()});
                            }
                            catch (AmazonClientException e) {
                                this.getLogger().info("Failure uploading part flowfile={} part={} bucket={} key={}", new Object[]{ffFilename, part, bucket, key, e});
                                throw e;
                            }
                            ++part;
                        }
                        completeRequest = new CompleteMultipartUploadRequest(bucket, key, currentState.getUploadId(), currentState.getPartETags());
                        try {
                            completeResult = s3.completeMultipartUpload(completeRequest);
                            this.getLogger().info("Success completing upload flowfile={} etag={} uploadId={}", new Object[]{ffFilename, completeResult.getETag(), currentState.getUploadId()});
                            if (completeResult.getVersionId() != null) {
                                attributes.put("s3.version", completeResult.getVersionId());
                            }
                            if (completeResult.getETag() != null) {
                                attributes.put("s3.etag", completeResult.getETag());
                            }
                            if (completeResult.getExpirationTime() != null) {
                                attributes.put("s3.expiration", completeResult.getExpirationTime().toString());
                            }
                            if (currentState.getStorageClass() != null) {
                                attributes.put("s3.storeClass", currentState.getStorageClass().toString());
                            }
                            if (!userMetadata.isEmpty()) {
                                userMetaBldr = new StringBuilder();
                                for (String userKey : userMetadata.keySet()) {
                                    userMetaBldr.append(userKey).append("=").append((String)userMetadata.get(userKey));
                                }
                                attributes.put("s3.usermetadata", userMetaBldr.toString());
                            }
                            attributes.put("s3.apimethod", "multipartupload");
                        }
                        catch (AmazonClientException e) {
                            this.getLogger().info("Failure completing upload flowfile={} bucket={} key={}", new Object[]{ffFilename, bucket, key, e});
                            throw e;
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (IOException e) {
                    this.getLogger().error("Error during upload of flow files", (Throwable)e);
                    throw e;
                }
            }
            url = s3.getResourceUrl(bucket, key);
            attributes.put("s3.url", url);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, PutS3Object.REL_SUCCESS);
            millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().send(flowFile, url, millis);
            this.getLogger().info("Successfully put {} to Amazon S3 in {} milliseconds", new Object[]{ff, millis});
            try {
                this.removeLocalState(cacheKey);
            }
            catch (IOException e) {
                this.getLogger().info("Error trying to delete key {} from cache:", new Object[]{cacheKey, e});
            }
        }
        catch (AmazonClientException | IOException | IllegalArgumentException | ProcessException e) {
            this.extractExceptionDetails((Exception)e, session, flowFile);
            if (e.getMessage().contains("Processor unscheduled, stopping upload")) {
                this.getLogger().info(e.getMessage());
                session.rollback();
            }
            this.getLogger().error("Failed to put {} to Amazon S3 due to {}", new Object[]{flowFile, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, PutS3Object.REL_FAILURE);
        }
    }

    protected void ageoffS3Uploads(ProcessContext context, AmazonS3 s3, long now, String bucket) {
        MultipartUploadListing oldUploads = this.getS3AgeoffListAndAgeoffLocalState(context, s3, now, bucket);
        for (MultipartUpload upload : oldUploads.getMultipartUploads()) {
            this.abortS3MultipartUpload(s3, oldUploads.getBucketName(), upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultipartUploadListing getS3AgeoffListAndAgeoffLocalState(ProcessContext context, AmazonS3 s3, long now, String bucket) {
        long ageoffInterval = context.getProperty(MULTIPART_S3_AGEOFF_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS);
        Long maxAge = context.getProperty(MULTIPART_S3_MAX_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        long ageCutoff = now - maxAge;
        ArrayList<MultipartUpload> ageoffList = new ArrayList<MultipartUpload>();
        if (this.lastS3AgeOff.get() < now - ageoffInterval && this.s3BucketLock.tryLock()) {
            try {
                ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(bucket);
                MultipartUploadListing listing = s3.listMultipartUploads(listRequest);
                for (MultipartUpload upload : listing.getMultipartUploads()) {
                    long uploadTime = upload.getInitiated().getTime();
                    if (uploadTime >= ageCutoff) continue;
                    ageoffList.add(upload);
                }
                this.ageoffLocalState(ageCutoff);
                this.lastS3AgeOff.set(System.currentTimeMillis());
            }
            catch (AmazonClientException e) {
                if (e instanceof AmazonS3Exception && ((AmazonS3Exception)((Object)e)).getStatusCode() == 403 && ((AmazonS3Exception)((Object)e)).getErrorCode().equals("AccessDenied")) {
                    this.getLogger().warn("AccessDenied checking S3 Multipart Upload list for {}: {} ** The configured user does not have the s3:ListBucketMultipartUploads permission for this bucket, S3 ageoff cannot occur without this permission.  Next ageoff check time is being advanced by interval to prevent checking on every upload **", new Object[]{bucket, e.getMessage()});
                    this.lastS3AgeOff.set(System.currentTimeMillis());
                } else {
                    this.getLogger().error("Error checking S3 Multipart Upload list for {}", new Object[]{bucket, e});
                }
            }
            finally {
                this.s3BucketLock.unlock();
            }
        }
        MultipartUploadListing result = new MultipartUploadListing();
        result.setBucketName(bucket);
        result.setMultipartUploads(ageoffList);
        return result;
    }

    protected void abortS3MultipartUpload(AmazonS3 s3, String bucket, MultipartUpload upload) {
        String uploadKey = upload.getKey();
        String uploadId = upload.getUploadId();
        AbortMultipartUploadRequest abortRequest = new AbortMultipartUploadRequest(bucket, uploadKey, uploadId);
        try {
            s3.abortMultipartUpload(abortRequest);
            this.getLogger().info("Aborting out of date multipart upload, bucket {} key {} ID {}, initiated {}", new Object[]{bucket, uploadKey, uploadId, upload.getInitiated()});
        }
        catch (AmazonClientException ace) {
            this.getLogger().info("Error trying to abort multipart upload from bucket {} with key {} and ID {}: {}", new Object[]{bucket, uploadKey, uploadId, ace.getMessage()});
        }
    }

    private List<Tag> getObjectTags(ProcessContext context, FlowFile flowFile) {
        String prefix = context.getProperty(OBJECT_TAGS_PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        ArrayList<Tag> objectTags = new ArrayList<Tag>();
        Map attributesMap = flowFile.getAttributes();
        attributesMap.entrySet().stream().filter(attribute -> ((String)attribute.getKey()).startsWith(prefix)).forEach(attribute -> {
            String tagKey = (String)attribute.getKey();
            String tagValue = (String)attribute.getValue();
            if (context.getProperty(REMOVE_TAG_PREFIX).asBoolean().booleanValue()) {
                tagKey = tagKey.replace(prefix, "");
            }
            objectTags.add(new Tag(tagKey, tagValue));
        });
        return objectTags;
    }

    private static /* synthetic */ InputStream lambda$onTrigger$0(ProcessSession session, FlowFile flowFileCopy) {
        return session.read(flowFileCopy);
    }

    protected static class MultipartState
    implements Serializable {
        private static final long serialVersionUID = 9006072180563519740L;
        private static final String SEPARATOR = "#";
        private String uploadId;
        private Long filePosition;
        private List<PartETag> partETags;
        private Long partSize;
        private StorageClass storageClass;
        private Long contentLength;
        private Long timestamp;

        public MultipartState() {
            this.uploadId = "";
            this.filePosition = 0L;
            this.partETags = new ArrayList<PartETag>();
            this.partSize = 0L;
            this.storageClass = StorageClass.Standard;
            this.contentLength = 0L;
            this.timestamp = System.currentTimeMillis();
        }

        public MultipartState(String buf) {
            String[] fields = buf.split(SEPARATOR);
            this.uploadId = fields[0];
            this.filePosition = Long.parseLong(fields[1]);
            this.partETags = new ArrayList<PartETag>();
            for (String part : fields[2].split(",")) {
                if (part == null || part.isEmpty()) continue;
                String[] partFields = part.split("/");
                this.partETags.add(new PartETag(Integer.parseInt(partFields[0]), partFields[1]));
            }
            this.partSize = Long.parseLong(fields[3]);
            this.storageClass = StorageClass.fromValue((String)fields[4]);
            this.contentLength = Long.parseLong(fields[5]);
            this.timestamp = Long.parseLong(fields[6]);
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public void setUploadId(String id) {
            this.uploadId = id;
        }

        public Long getFilePosition() {
            return this.filePosition;
        }

        public void setFilePosition(Long pos) {
            this.filePosition = pos;
        }

        public List<PartETag> getPartETags() {
            return this.partETags;
        }

        public void addPartETag(PartETag tag) {
            this.partETags.add(tag);
        }

        public Long getPartSize() {
            return this.partSize;
        }

        public void setPartSize(Long size) {
            this.partSize = size;
        }

        public StorageClass getStorageClass() {
            return this.storageClass;
        }

        public void setStorageClass(StorageClass aClass) {
            this.storageClass = aClass;
        }

        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(Long length) {
            this.contentLength = length;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.uploadId).append(SEPARATOR).append(this.filePosition.toString()).append(SEPARATOR);
            if (!this.partETags.isEmpty()) {
                boolean first = true;
                for (PartETag tag : this.partETags) {
                    if (!first) {
                        buf.append(",");
                    } else {
                        first = false;
                    }
                    buf.append(String.format("%d/%s", tag.getPartNumber(), tag.getETag()));
                }
            }
            buf.append(SEPARATOR).append(this.partSize.toString()).append(SEPARATOR).append(this.storageClass.toString()).append(SEPARATOR).append(this.contentLength.toString()).append(SEPARATOR).append(this.timestamp.toString());
            return buf.toString();
        }
    }
}

