/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.transcribe;

import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.ml.transcribe.StartAwsTranscribeJob;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.TranscribeClientBuilder;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.LimitExceededException;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Transcribe"})
@CapabilityDescription(value="Retrieves the current status of an AWS Transcribe job.")
@SeeAlso(value={StartAwsTranscribeJob.class})
@WritesAttributes(value={@WritesAttribute(attribute="outputLocation", description="S3 path-style output location of the result.")})
public class GetAwsTranscribeJobStatus
extends AbstractAwsMachineLearningJobStatusProcessor<TranscribeClient, TranscribeClientBuilder> {
    protected TranscribeClientBuilder createClientBuilder(ProcessContext context) {
        return TranscribeClient.builder();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        block7: {
            FlowFile flowFile = session.get();
            if (flowFile == null) {
                return;
            }
            try {
                GetTranscriptionJobResponse job = this.getJob(context, flowFile);
                TranscriptionJobStatus status = job.transcriptionJob().transcriptionJobStatus();
                if (TranscriptionJobStatus.COMPLETED == status) {
                    flowFile = this.writeToFlowFile(session, flowFile, (AwsResponse)job);
                    flowFile = session.putAttribute(flowFile, "outputLocation", job.transcriptionJob().transcript().transcriptFileUri());
                    session.transfer(flowFile, REL_SUCCESS);
                    break block7;
                }
                if (TranscriptionJobStatus.IN_PROGRESS == status || TranscriptionJobStatus.QUEUED == status) {
                    session.transfer(flowFile, REL_RUNNING);
                    break block7;
                }
                if (TranscriptionJobStatus.FAILED == status) {
                    String failureReason = job.transcriptionJob().failureReason();
                    flowFile = session.putAttribute(flowFile, "failure.reason", failureReason);
                    session.transfer(flowFile, REL_FAILURE);
                    this.getLogger().error("Transcribe Task Failed {} Reason [{}]", new Object[]{flowFile, failureReason});
                    break block7;
                }
                flowFile = session.putAttribute(flowFile, "failure.reason", "Unrecognized job status");
                throw new IllegalStateException("Unrecognized job status");
            }
            catch (LimitExceededException e) {
                this.getLogger().info("Request Rate Limit exceeded", (Throwable)e);
                session.transfer(flowFile, REL_THROTTLED);
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to get Transcribe Job status", (Throwable)e);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
    }

    private GetTranscriptionJobResponse getJob(ProcessContext context, FlowFile flowFile) {
        String taskId = context.getProperty(TASK_ID).evaluateAttributeExpressions(flowFile).getValue();
        GetTranscriptionJobRequest request = (GetTranscriptionJobRequest)GetTranscriptionJobRequest.builder().transcriptionJobName(taskId).build();
        return ((TranscribeClient)this.getClient(context)).getTranscriptionJob(request);
    }
}

