/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.aws.dynamodb.AbstractDynamoDBProcessor;
import org.apache.nifi.processors.aws.dynamodb.GetDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.ItemKeys;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDBRecord;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.CollectionUtils;

@SupportsBatching
@SeeAlso(value={GetDynamoDB.class, PutDynamoDB.class, PutDynamoDBRecord.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "DynamoDB", "AWS", "Delete", "Remove"})
@CapabilityDescription(value="Deletes a document from DynamoDB based on hash and range key. The key can be string or number. The request requires all the primary keys for the operation (hash or hash and range key)")
@WritesAttributes(value={@WritesAttribute(attribute="dynamodb.key.error.unprocessed", description="DynamoDB unprocessed keys"), @WritesAttribute(attribute="dynmodb.range.key.value.error", description="DynamoDB range key error"), @WritesAttribute(attribute="dynamodb.key.error.not.found", description="DynamoDB key not found"), @WritesAttribute(attribute="dynamodb.error.exception.message", description="DynamoDB exception message"), @WritesAttribute(attribute="dynamodb.error.code", description="DynamoDB error code"), @WritesAttribute(attribute="dynamodb.error.message", description="DynamoDB error message"), @WritesAttribute(attribute="dynamodb.error.service", description="DynamoDB error service"), @WritesAttribute(attribute="dynamodb.error.retryable", description="DynamoDB error is retryable"), @WritesAttribute(attribute="dynamodb.error.request.id", description="DynamoDB error request id"), @WritesAttribute(attribute="dynamodb.error.status.code", description="DynamoDB status code")})
@ReadsAttributes(value={@ReadsAttribute(attribute="  dynamodb.item.hash.key.value", description="Items hash key value"), @ReadsAttribute(attribute="  dynamodb.item.range.key.value", description="Items range key value")})
public class DeleteDynamoDB
extends AbstractDynamoDBProcessor {
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(TABLE, REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, HASH_KEY_NAME, RANGE_KEY_NAME, HASH_KEY_VALUE, RANGE_KEY_VALUE, HASH_KEY_VALUE_TYPE, RANGE_KEY_VALUE_TYPE, BATCH_SIZE, TIMEOUT, ENDPOINT_OVERRIDE, SSL_CONTEXT_SERVICE, PROXY_CONFIGURATION_SERVICE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        List failedFlowFiles;
        List flowFiles = session.get(context.getProperty(BATCH_SIZE).evaluateAttributeExpressions().asInteger().intValue());
        if (flowFiles == null || flowFiles.isEmpty()) {
            return;
        }
        HashMap<ItemKeys, FlowFile> keysToFlowFileMap = new HashMap<ItemKeys, FlowFile>();
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        HashMap tableNameRequestItemsMap = new HashMap();
        ArrayList<WriteRequest> requestItems = new ArrayList<WriteRequest>();
        tableNameRequestItemsMap.put(table, requestItems);
        for (FlowFile flowFile : flowFiles) {
            AttributeValue hashKeyValue = this.getAttributeValue(context, HASH_KEY_VALUE_TYPE, HASH_KEY_VALUE, flowFile.getAttributes());
            AttributeValue rangeKeyValue = this.getAttributeValue(context, RANGE_KEY_VALUE_TYPE, RANGE_KEY_VALUE, flowFile.getAttributes());
            if (!this.isHashKeyValueConsistent(hashKeyName, hashKeyValue, session, flowFile) || !this.isRangeKeyValueConsistent(rangeKeyName, rangeKeyValue, session, flowFile)) continue;
            HashMap keyMap = new HashMap();
            keyMap.put(hashKeyName, hashKeyValue);
            if (!DeleteDynamoDB.isBlank((AttributeValue)rangeKeyValue)) {
                keyMap.put(rangeKeyName, rangeKeyValue);
            }
            DeleteRequest deleteRequest = (DeleteRequest)DeleteRequest.builder().key((Map)keyMap).build();
            WriteRequest writeRequest = (WriteRequest)WriteRequest.builder().deleteRequest(deleteRequest).build();
            requestItems.add(writeRequest);
            keysToFlowFileMap.put(new ItemKeys(hashKeyValue, rangeKeyValue), flowFile);
        }
        if (keysToFlowFileMap.isEmpty()) {
            return;
        }
        DynamoDbClient client = (DynamoDbClient)this.getClient(context);
        try {
            BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(tableNameRequestItemsMap).build();
            BatchWriteItemResponse response = client.batchWriteItem(batchWriteItemRequest);
            if (CollectionUtils.isNotEmpty((Map)response.unprocessedItems())) {
                List unprocessedItems = (List)response.unprocessedItems().get(table);
                for (WriteRequest writeRequest : unprocessedItems) {
                    Map item = writeRequest.deleteRequest().key();
                    AttributeValue hashKeyValue = (AttributeValue)item.get(hashKeyName);
                    AttributeValue rangeKeyValue = (AttributeValue)item.get(rangeKeyName);
                    this.sendUnprocessedToUnprocessedRelationship(session, keysToFlowFileMap, hashKeyValue, rangeKeyValue);
                }
            }
            for (FlowFile flowFile : keysToFlowFileMap.values()) {
                this.getLogger().debug("Successfully deleted item from dynamodb : {}", new Object[]{table});
                session.transfer(flowFile, REL_SUCCESS);
            }
        }
        catch (AwsServiceException exception) {
            this.getLogger().error("Could not process flowFiles due to service exception", (Throwable)exception);
            failedFlowFiles = this.processServiceException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (SdkException exception) {
            this.getLogger().error("Could not process flowFiles due to SDK exception", (Throwable)exception);
            failedFlowFiles = this.processSdkException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (Exception exception) {
            this.getLogger().error("Could not process flowFiles", (Throwable)exception);
            failedFlowFiles = this.processException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
    }
}

