/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderControllerService;
import org.apache.nifi.processors.aws.signer.AwsCustomSignerUtil;
import org.apache.nifi.processors.aws.signer.AwsSignerType;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.ssl.SSLContextProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleCredentialsStrategy
extends AbstractCredentialsStrategy {
    public AssumeRoleCredentialsStrategy() {
        super("Assume Role", new PropertyDescriptor[]{AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN, AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME, AWSCredentialsProviderControllerService.MAX_SESSION_TIME});
    }

    @Override
    public boolean canCreatePrimaryCredential(PropertyContext propertyContext) {
        return false;
    }

    @Override
    public boolean canCreateDerivedCredential(PropertyContext propertyContext) {
        String assumeRoleArn = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME).getValue();
        return assumeRoleArn != null && !assumeRoleArn.isEmpty() && assumeRoleName != null && !assumeRoleName.isEmpty();
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        Integer maxSessionTime;
        ArrayList<ValidationResult> validationFailureResults = new ArrayList<ValidationResult>();
        boolean assumeRoleArnIsSet = validationContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN).isSet();
        if (assumeRoleArnIsSet && ((maxSessionTime = validationContext.getProperty(AWSCredentialsProviderControllerService.MAX_SESSION_TIME).asInteger()) < 900 || maxSessionTime > 3600)) {
            validationFailureResults.add(new ValidationResult.Builder().valid(false).input("" + maxSessionTime).explanation(AWSCredentialsProviderControllerService.MAX_SESSION_TIME.getDisplayName() + " must be between 900 and 3600 seconds").build());
        }
        return validationFailureResults;
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider(PropertyContext propertyContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AWSCredentialsProvider getDerivedCredentialsProvider(PropertyContext propertyContext, AWSCredentialsProvider primaryCredentialsProvider) {
        AwsSignerType assumeRoleSTSSignerType;
        org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration;
        String assumeRoleArn = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME).getValue();
        int maxSessionTime = propertyContext.getProperty(AWSCredentialsProviderControllerService.MAX_SESSION_TIME).asInteger();
        String assumeRoleExternalId = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_EXTERNAL_ID).getValue();
        String assumeRoleSTSRegion = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_REGION).getValue();
        String assumeRoleSTSEndpoint = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_ENDPOINT).getValue();
        String assumeRoleSTSSigner = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_SIGNER_OVERRIDE).getValue();
        SSLContextProvider sslContextProvider = (SSLContextProvider)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        ProxyConfigurationService proxyConfigurationService = (ProxyConfigurationService)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        ClientConfiguration config = new ClientConfiguration();
        if (sslContextProvider != null) {
            SSLContext sslContext = sslContextProvider.createContext();
            config.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        }
        if (proxyConfigurationService != null && (proxyConfiguration = proxyConfigurationService.getConfiguration()).getProxyType() == Proxy.Type.HTTP) {
            config.withProxyHost(proxyConfiguration.getProxyServerHost());
            config.withProxyPort(proxyConfiguration.getProxyServerPort().intValue());
            if (proxyConfiguration.hasCredential()) {
                config.withProxyUsername(proxyConfiguration.getProxyUserName());
                config.withProxyPassword(proxyConfiguration.getProxyUserPassword());
            }
        }
        if ((assumeRoleSTSSignerType = AwsSignerType.forValue((String)assumeRoleSTSSigner)) == AwsSignerType.CUSTOM_SIGNER) {
            String signerClassName = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_CUSTOM_SIGNER_CLASS_NAME).evaluateAttributeExpressions().getValue();
            config.withSignerOverride(AwsCustomSignerUtil.registerCustomSigner((String)signerClassName));
        } else if (assumeRoleSTSSignerType != AwsSignerType.DEFAULT_SIGNER) {
            config.withSignerOverride(assumeRoleSTSSigner);
        }
        AWSSecurityTokenServiceClientBuilder securityTokenServiceBuilder = (AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClient.builder().withCredentials(primaryCredentialsProvider)).withClientConfiguration(config);
        if (assumeRoleSTSEndpoint != null && !assumeRoleSTSEndpoint.isEmpty()) {
            AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(assumeRoleSTSEndpoint, assumeRoleSTSRegion);
            securityTokenServiceBuilder.withEndpointConfiguration(endpointConfiguration);
        } else {
            securityTokenServiceBuilder.withRegion(assumeRoleSTSRegion);
        }
        STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(assumeRoleArn, assumeRoleName).withStsClient((AWSSecurityTokenService)securityTokenServiceBuilder.build()).withRoleSessionDurationSeconds(maxSessionTime);
        if (assumeRoleExternalId != null && !assumeRoleExternalId.isEmpty()) {
            builder.withExternalId(assumeRoleExternalId);
        }
        STSAssumeRoleSessionCredentialsProvider credsProvider = builder.build();
        return credsProvider;
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AwsCredentialsProvider getDerivedAwsCredentialsProvider(PropertyContext propertyContext, AwsCredentialsProvider primaryCredentialsProvider) {
        org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration;
        String assumeRoleArn = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_NAME).getValue();
        int maxSessionTime = propertyContext.getProperty(AWSCredentialsProviderControllerService.MAX_SESSION_TIME).asInteger();
        String assumeRoleExternalId = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_EXTERNAL_ID).getValue();
        String assumeRoleSTSEndpoint = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_ENDPOINT).getValue();
        String stsRegion = propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_STS_REGION).getValue();
        SSLContextProvider sslContextProvider = (SSLContextProvider)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        ProxyConfigurationService proxyConfigurationService = (ProxyConfigurationService)propertyContext.getProperty(AWSCredentialsProviderControllerService.ASSUME_ROLE_PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        StsAssumeRoleCredentialsProvider.Builder builder = StsAssumeRoleCredentialsProvider.builder();
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (sslContextProvider != null) {
            SSLContext sslContext = sslContextProvider.createContext();
            httpClientBuilder.socketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        }
        if (proxyConfigurationService != null && (proxyConfiguration = proxyConfigurationService.getConfiguration()).getProxyType() == Proxy.Type.HTTP) {
            ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxyConfiguration.getProxyServerHost(), proxyConfiguration.getProxyServerPort())));
            if (proxyConfiguration.hasCredential()) {
                proxyConfigBuilder.username(proxyConfiguration.getProxyUserName());
                proxyConfigBuilder.password(proxyConfiguration.getProxyUserPassword());
            }
            httpClientBuilder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
        }
        if (stsRegion == null) {
            throw new IllegalStateException("Assume Role Region is required to interact with STS");
        }
        StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(primaryCredentialsProvider)).region(Region.of((String)stsRegion))).httpClient(httpClientBuilder.build());
        if (assumeRoleSTSEndpoint != null && !assumeRoleSTSEndpoint.isEmpty()) {
            stsClientBuilder.endpointOverride(URI.create(assumeRoleSTSEndpoint));
        }
        StsClient stsClient = (StsClient)stsClientBuilder.build();
        AssumeRoleRequest.Builder roleRequestBuilder = AssumeRoleRequest.builder().roleArn(assumeRoleArn).roleSessionName(assumeRoleName);
        if (assumeRoleExternalId != null && !assumeRoleExternalId.isEmpty()) {
            roleRequestBuilder.externalId(assumeRoleExternalId);
        }
        ((StsAssumeRoleCredentialsProvider.Builder)builder.refreshRequest((AssumeRoleRequest)roleRequestBuilder.build()).stsClient(stsClient)).staleTime(Duration.ofSeconds(maxSessionTime));
        return builder.build();
    }
}

