/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2Builder;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;

public class ClientSideKMSEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public AmazonS3 createEncryptionClient(Consumer<AmazonS3Builder<?, ?>> clientBuilder, String kmsRegion, String keyIdOrMaterial) {
        KMSEncryptionMaterialsProvider encryptionMaterialsProvider = new KMSEncryptionMaterialsProvider(keyIdOrMaterial);
        CryptoConfigurationV2 cryptoConfig = new CryptoConfigurationV2();
        if (StringUtils.isNotBlank((CharSequence)kmsRegion)) {
            cryptoConfig.setAwsKmsRegion(RegionUtils.getRegion((String)kmsRegion));
        }
        AmazonS3EncryptionClientV2Builder builder = AmazonS3EncryptionClientV2.encryptionBuilder().withCryptoConfiguration(cryptoConfig).withEncryptionMaterialsProvider((EncryptionMaterialsProvider)encryptionMaterialsProvider);
        clientBuilder.accept((AmazonS3Builder<?, ?>)builder);
        return (AmazonS3)builder.build();
    }
}

