/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.firehose;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.kinesis.KinesisProcessorUtils;
import org.apache.nifi.processors.aws.v2.AbstractAwsSyncProcessor;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.amazon.awssdk.services.firehose.FirehoseClientBuilder;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry;
import software.amazon.awssdk.services.firehose.model.Record;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"amazon", "aws", "firehose", "kinesis", "put", "stream"})
@CapabilityDescription(value="Sends the contents to a specified Amazon Kinesis Firehose. In order to send data to firehose, the firehose delivery stream name has to be specified.")
@WritesAttributes(value={@WritesAttribute(attribute="aws.kinesis.firehose.error.message", description="Error message on posting message to AWS Kinesis Firehose"), @WritesAttribute(attribute="aws.kinesis.firehose.error.code", description="Error code for the message when posting to AWS Kinesis Firehose"), @WritesAttribute(attribute="aws.kinesis.firehose.record.id", description="Record id of the message posted to Kinesis Firehose")})
public class PutKinesisFirehose
extends AbstractAwsSyncProcessor<FirehoseClient, FirehoseClientBuilder> {
    public static final String AWS_KINESIS_FIREHOSE_ERROR_MESSAGE = "aws.kinesis.firehose.error.message";
    public static final String AWS_KINESIS_FIREHOSE_ERROR_CODE = "aws.kinesis.firehose.error.code";
    public static final String AWS_KINESIS_FIREHOSE_RECORD_ID = "aws.kinesis.firehose.record.id";
    public static final PropertyDescriptor KINESIS_FIREHOSE_DELIVERY_STREAM_NAME = new PropertyDescriptor.Builder().name("Amazon Kinesis Firehose Delivery Stream Name").description("The name of kinesis firehose delivery stream").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("Batch size for messages (1-500).").defaultValue("250").required(false).addValidator(StandardValidators.createLongValidator((long)1L, (long)500L, (boolean)true)).sensitive(false).build();
    public static final PropertyDescriptor MAX_MESSAGE_BUFFER_SIZE_MB = new PropertyDescriptor.Builder().name("Max message buffer size").description("Max message buffer").defaultValue("1 MB").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).sensitive(false).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(KINESIS_FIREHOSE_DELIVERY_STREAM_NAME, BATCH_SIZE, REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, MAX_MESSAGE_BUFFER_SIZE_MB, TIMEOUT, PROXY_CONFIGURATION_SERVICE, ENDPOINT_OVERRIDE);
    public static final int MAX_MESSAGE_SIZE = 1024000;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected FirehoseClientBuilder createClientBuilder(ProcessContext context) {
        return FirehoseClient.builder();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        long maxBufferSizeBytes = context.getProperty(MAX_MESSAGE_BUFFER_SIZE_MB).asDataSize(DataUnit.B).longValue();
        List flowFiles = KinesisProcessorUtils.filterMessagesByMaxSize((ProcessSession)session, (int)batchSize, (long)maxBufferSizeBytes, (String)AWS_KINESIS_FIREHOSE_ERROR_MESSAGE, (ComponentLog)this.getLogger());
        HashMap<String, List> hashFlowFiles = new HashMap<String, List>();
        HashMap<String, List> recordHash = new HashMap<String, List>();
        FirehoseClient client = (FirehoseClient)this.getClient(context);
        try {
            ArrayList<FlowFile> failedFlowFiles = new ArrayList<FlowFile>();
            ArrayList<FlowFile> successfulFlowFiles = new ArrayList<FlowFile>();
            for (FlowFile flowFile : flowFiles) {
                String firehoseStreamName = context.getProperty(KINESIS_FIREHOSE_DELIVERY_STREAM_NAME).evaluateAttributeExpressions(flowFile).getValue();
                recordHash.computeIfAbsent(firehoseStreamName, k -> new ArrayList());
                session.read(flowFile, in -> ((List)recordHash.get(firehoseStreamName)).add((Record)Record.builder().data(SdkBytes.fromInputStream((InputStream)in)).build()));
                List flowFilesForStream = hashFlowFiles.computeIfAbsent(firehoseStreamName, k -> new ArrayList());
                flowFilesForStream.add(flowFile);
            }
            for (Map.Entry entry : recordHash.entrySet()) {
                String streamName = (String)entry.getKey();
                List records = (List)entry.getValue();
                if (records.size() <= 0) continue;
                PutRecordBatchRequest putRecordBatchRequest = (PutRecordBatchRequest)PutRecordBatchRequest.builder().deliveryStreamName(streamName).records((Collection)records).build();
                PutRecordBatchResponse response = client.putRecordBatch(putRecordBatchRequest);
                List responseEntries = response.requestResponses();
                for (int i = 0; i < responseEntries.size(); ++i) {
                    PutRecordBatchResponseEntry responseEntry = (PutRecordBatchResponseEntry)responseEntries.get(i);
                    FlowFile flowFile = (FlowFile)((List)hashFlowFiles.get(streamName)).get(i);
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put(AWS_KINESIS_FIREHOSE_RECORD_ID, responseEntry.recordId());
                    flowFile = session.putAttribute(flowFile, AWS_KINESIS_FIREHOSE_RECORD_ID, responseEntry.recordId());
                    if (StringUtils.isNotBlank((CharSequence)responseEntry.errorCode())) {
                        attributes.put(AWS_KINESIS_FIREHOSE_ERROR_CODE, responseEntry.errorCode());
                        attributes.put(AWS_KINESIS_FIREHOSE_ERROR_MESSAGE, responseEntry.errorMessage());
                        flowFile = session.putAllAttributes(flowFile, attributes);
                        failedFlowFiles.add(flowFile);
                        continue;
                    }
                    flowFile = session.putAllAttributes(flowFile, attributes);
                    successfulFlowFiles.add(flowFile);
                }
                ((List)recordHash.get(streamName)).clear();
                records.clear();
            }
            if (failedFlowFiles.size() > 0) {
                session.transfer(failedFlowFiles, REL_FAILURE);
                this.getLogger().error("Failed to publish to kinesis firehose {}", new Object[]{failedFlowFiles});
            }
            if (successfulFlowFiles.size() > 0) {
                session.transfer(successfulFlowFiles, REL_SUCCESS);
                this.getLogger().info("Successfully published to kinesis firehose {}", new Object[]{successfulFlowFiles});
            }
        }
        catch (Exception exception) {
            this.getLogger().error("Failed to publish to kinesis firehose {} with exception {}", new Object[]{flowFiles, exception});
            session.transfer((Collection)flowFiles, REL_FAILURE);
            context.yield();
        }
    }
}

