/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.aws.dynamodb.AbstractDynamoDBProcessor;
import org.apache.nifi.processors.aws.dynamodb.DeleteDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.ItemKeys;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDBRecord;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.utils.CollectionUtils;

@SupportsBatching
@SeeAlso(value={DeleteDynamoDB.class, PutDynamoDB.class, PutDynamoDBRecord.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "DynamoDB", "AWS", "Get", "Fetch"})
@CapabilityDescription(value="Retrieves a document from DynamoDB based on hash and range key.  The key can be string or number.For any get request all the primary keys are required (hash or hash and range based on the table keys).A Json Document ('Map') attribute of the DynamoDB item is read into the content of the FlowFile.")
@WritesAttributes(value={@WritesAttribute(attribute="dynamodb.key.error.unprocessed", description="DynamoDB unprocessed keys"), @WritesAttribute(attribute="dynmodb.range.key.value.error", description="DynamoDB range key error"), @WritesAttribute(attribute="dynamodb.key.error.not.found", description="DynamoDB key not found"), @WritesAttribute(attribute="dynamodb.error.exception.message", description="DynamoDB exception message"), @WritesAttribute(attribute="dynamodb.error.code", description="DynamoDB error code"), @WritesAttribute(attribute="dynamodb.error.message", description="DynamoDB error message"), @WritesAttribute(attribute="dynamodb.error.service", description="DynamoDB error service"), @WritesAttribute(attribute="dynamodb.error.retryable", description="DynamoDB error is retryable"), @WritesAttribute(attribute="dynamodb.error.request.id", description="DynamoDB error request id"), @WritesAttribute(attribute="dynamodb.error.status.code", description="DynamoDB status code")})
@ReadsAttributes(value={@ReadsAttribute(attribute="  dynamodb.item.hash.key.value", description="Items hash key value"), @ReadsAttribute(attribute="  dynamodb.item.range.key.value", description="Items range key value")})
public class GetDynamoDB
extends AbstractDynamoDBProcessor {
    private static final PropertyDescriptor DOCUMENT_CHARSET = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractDynamoDBProcessor.DOCUMENT_CHARSET).required(false).build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(TABLE, REGION, AWS_CREDENTIALS_PROVIDER_SERVICE, JSON_DOCUMENT, HASH_KEY_NAME, RANGE_KEY_NAME, HASH_KEY_VALUE, RANGE_KEY_VALUE, HASH_KEY_VALUE_TYPE, RANGE_KEY_VALUE_TYPE, BATCH_SIZE, TIMEOUT, ENDPOINT_OVERRIDE, SSL_CONTEXT_SERVICE, PROXY_CONFIGURATION_SERVICE);
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("FlowFiles are routed to not found relationship if key not found in the table").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_UNPROCESSED, REL_NOT_FOUND);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        BatchGetItemRequest batchGetItemRequest;
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>(super.verify(context, verificationLogger, attributes));
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        String jsonDocument = context.getProperty(JSON_DOCUMENT).evaluateAttributeExpressions().getValue();
        try {
            batchGetItemRequest = this.getBatchGetItemRequest(context, attributes);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Configure DynamoDB BatchGetItems Request").explanation(String.format("Successfully configured BatchGetItems Request", new Object[0])).build());
        }
        catch (IllegalArgumentException e) {
            verificationLogger.error("Failed to configured BatchGetItems Request", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Configure DynamoDB BatchGetItems Request").explanation(String.format("Failed to configured BatchGetItems Request: " + e.getMessage(), new Object[0])).build());
            return results;
        }
        if (!batchGetItemRequest.hasRequestItems()) {
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SKIPPED).verificationStepName("Get DynamoDB Items").explanation(String.format("Skipped getting DynamoDB items because no primary keys would be included in retrieval", new Object[0])).build());
        } else {
            try {
                DynamoDbClient client = (DynamoDbClient)this.getClient(context);
                int totalCount = 0;
                int jsonDocumentCount = 0;
                BatchGetItemResponse response = client.batchGetItem(batchGetItemRequest);
                if (!response.hasResponses()) {
                    results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Get DynamoDB Items").explanation(String.format("Successfully issued request, although no items were returned from DynamoDB", new Object[0])).build());
                } else {
                    List items = (List)response.responses().get(table);
                    if (items != null) {
                        for (Map item : items) {
                            ++totalCount;
                            if (item.get(jsonDocument) == null || ((AttributeValue)item.get(jsonDocument)).s() == null) continue;
                            ++jsonDocumentCount;
                        }
                    }
                    results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Get DynamoDB Items").explanation(String.format("Successfully retrieved %s items, including %s JSON documents, from DynamoDB", totalCount, jsonDocumentCount)).build());
                }
            }
            catch (Exception e) {
                verificationLogger.error("Failed to retrieve items from DynamoDB", (Throwable)e);
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Get DynamoDB Items").explanation(String.format("Failed to retrieve items from DynamoDB: %s", e.getMessage())).build());
            }
        }
        return results;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        BatchGetItemRequest request;
        List flowFiles = session.get(context.getProperty(BATCH_SIZE).evaluateAttributeExpressions().asInteger().intValue());
        if (flowFiles == null || flowFiles.size() == 0) {
            return;
        }
        Map<ItemKeys, FlowFile> keysToFlowFileMap = this.getKeysToFlowFileMap(context, session, flowFiles);
        try {
            request = this.getBatchGetItemRequest(context, flowFiles.stream().map(FlowFile::getAttributes).collect(Collectors.toList()).toArray(new Map[0]));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return;
        }
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        String jsonDocument = context.getProperty(JSON_DOCUMENT).evaluateAttributeExpressions().getValue();
        if (keysToFlowFileMap.isEmpty()) {
            return;
        }
        DynamoDbClient client = (DynamoDbClient)this.getClient(context);
        try {
            Map unprocessedKeys;
            BatchGetItemResponse response = client.batchGetItem(request);
            if (CollectionUtils.isNotEmpty((Map)response.responses())) {
                List items = (List)response.responses().get(table);
                for (Map item : items) {
                    ItemKeys itemKeys = new ItemKeys((AttributeValue)item.get(hashKeyName), (AttributeValue)item.get(rangeKeyName));
                    FlowFile flowFile = keysToFlowFileMap.get(itemKeys);
                    if (item.get(jsonDocument) != null && ((AttributeValue)item.get(jsonDocument)).s() != null) {
                        String charsetPropertyValue = context.getProperty(DOCUMENT_CHARSET).getValue();
                        String charset = charsetPropertyValue == null ? Charset.defaultCharset().name() : charsetPropertyValue;
                        ByteArrayInputStream bais = new ByteArrayInputStream(((AttributeValue)item.get(jsonDocument)).s().getBytes(charset));
                        flowFile = session.importFrom((InputStream)bais, flowFile);
                    }
                    session.transfer(flowFile, REL_SUCCESS);
                    keysToFlowFileMap.remove(itemKeys);
                }
            }
            if (CollectionUtils.isNotEmpty((Map)(unprocessedKeys = response.unprocessedKeys()))) {
                KeysAndAttributes keysAndAttributes = (KeysAndAttributes)unprocessedKeys.get(table);
                List keys = keysAndAttributes.keys();
                for (Map unprocessedKey : keys) {
                    AttributeValue hashKeyValue = (AttributeValue)unprocessedKey.get(hashKeyName);
                    AttributeValue rangeKeyValue = (AttributeValue)unprocessedKey.get(rangeKeyName);
                    this.sendUnprocessedToUnprocessedRelationship(session, keysToFlowFileMap, hashKeyValue, rangeKeyValue);
                }
            }
            for (ItemKeys key : keysToFlowFileMap.keySet()) {
                FlowFile flowFile = keysToFlowFileMap.get(key);
                flowFile = session.putAttribute(flowFile, "dynamodb.key.error.not.found", "DynamoDB key not found : " + key.toString());
                session.transfer(flowFile, REL_NOT_FOUND);
                keysToFlowFileMap.remove(key);
            }
        }
        catch (AwsServiceException exception) {
            this.getLogger().error("Could not process flowFiles due to service exception", (Throwable)exception);
            List failedFlowFiles = this.processServiceException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (SdkException exception) {
            this.getLogger().error("Could not process flowFiles due to SDK exception", (Throwable)exception);
            List failedFlowFiles = this.processSdkException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (Exception exception) {
            this.getLogger().error("Could not process flowFiles", (Throwable)exception);
            List failedFlowFiles = this.processException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
    }

    private Map<ItemKeys, FlowFile> getKeysToFlowFileMap(ProcessContext context, ProcessSession session, List<FlowFile> flowFiles) {
        HashMap<ItemKeys, FlowFile> keysToFlowFileMap = new HashMap<ItemKeys, FlowFile>();
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        for (FlowFile flowFile : flowFiles) {
            AttributeValue hashKeyValue = this.getAttributeValue(context, HASH_KEY_VALUE_TYPE, HASH_KEY_VALUE, flowFile.getAttributes());
            AttributeValue rangeKeyValue = this.getAttributeValue(context, RANGE_KEY_VALUE_TYPE, RANGE_KEY_VALUE, flowFile.getAttributes());
            if (!this.isHashKeyValueConsistent(hashKeyName, hashKeyValue, session, flowFile) || !this.isRangeKeyValueConsistent(rangeKeyName, rangeKeyValue, session, flowFile)) continue;
            keysToFlowFileMap.put(new ItemKeys(hashKeyValue, rangeKeyValue), flowFile);
        }
        return keysToFlowFileMap;
    }

    private BatchGetItemRequest getBatchGetItemRequest(ProcessContext context, Map<String, String> ... attributes) {
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        HashSet keys = new HashSet();
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        for (Map<String, String> attributeMap : attributes) {
            HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
            AttributeValue hashKeyValue = this.getAttributeValue(context, HASH_KEY_VALUE_TYPE, HASH_KEY_VALUE, attributeMap);
            AttributeValue rangeKeyValue = this.getAttributeValue(context, RANGE_KEY_VALUE_TYPE, RANGE_KEY_VALUE, attributeMap);
            this.validateHashKeyValue(hashKeyValue);
            this.validateRangeKeyValue(rangeKeyName, rangeKeyValue);
            keyMap.put(hashKeyName, hashKeyValue);
            if (!GetDynamoDB.isBlank((AttributeValue)rangeKeyValue)) {
                keyMap.put(rangeKeyName, rangeKeyValue);
            }
            keys.add(keyMap);
        }
        return (BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(Map.of(table, (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).build())).build();
    }
}

