/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.parameter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stateless.parameter.AbstractSecretBasedParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProviderInitializationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

public class AwsSecretsManagerParameterValueProvider
extends AbstractSecretBasedParameterValueProvider
implements ParameterValueProvider {
    private static final Logger logger = LoggerFactory.getLogger(AwsSecretsManagerParameterValueProvider.class);
    private static final String ACCESS_KEY_PROPS_NAME = "aws.access.key.id";
    private static final String SECRET_KEY_PROPS_NAME = "aws.secret.access.key";
    private static final String REGION_KEY_PROPS_NAME = "aws.region";
    public static final PropertyDescriptor AWS_CREDENTIALS_FILE = new PropertyDescriptor.Builder().displayName("AWS Credentials File").name("aws-credentials-file").required(false).description("Location of the configuration file (e.g., ./conf/bootstrap-aws.conf) that configures the AWS credentials.  If not provided, the default AWS credentials will be used.").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).build();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private SecretsManagerClient secretsManager;

    protected List<PropertyDescriptor> getAdditionalSupportedPropertyDescriptors() {
        return Collections.singletonList(AWS_CREDENTIALS_FILE);
    }

    protected void additionalInit(ParameterValueProviderInitializationContext context) {
        String awsCredentialsFilename = context.getProperty(AWS_CREDENTIALS_FILE).getValue();
        try {
            this.secretsManager = this.configureClient(awsCredentialsFilename);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not configure AWS Secrets Manager Client", e);
        }
    }

    protected String getSecretValue(String secretName, String keyName) {
        GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        try {
            GetSecretValueResponse getSecretValueResponse = this.secretsManager.getSecretValue(getSecretValueRequest);
            if (getSecretValueResponse.secretString() == null) {
                logger.debug("Secret [{}] not configured", (Object)secretName);
                return null;
            }
            return this.parseParameterValue(getSecretValueResponse.secretString(), keyName);
        }
        catch (ResourceNotFoundException e) {
            logger.debug("Secret [{}] not found", (Object)secretName);
            return null;
        }
        catch (SecretsManagerException e) {
            logger.debug("Error retrieving secret [{}]", (Object)secretName);
            return null;
        }
    }

    private String parseParameterValue(String secretString, String parameterName) {
        try {
            JsonNode root = this.objectMapper.readTree(secretString);
            JsonNode parameter = root.get(parameterName);
            if (parameter == null) {
                logger.debug("Parameter [{}] not found", (Object)parameterName);
                return null;
            }
            if (!parameter.isValueNode() || parameter.isNull()) {
                logger.debug("Parameter [{}] is null or not a supported value type", (Object)parameterName);
                return null;
            }
            return parameter.asText();
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Secret String for [%s] could not be parsed", parameterName), e);
        }
    }

    private Properties loadProperties(String propertiesFilename) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(Paths.get(propertiesFilename, new String[0]).toFile());){
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    SecretsManagerClient configureClient(String awsCredentialsFilename) throws IOException {
        if (awsCredentialsFilename == null) {
            return this.getDefaultClient();
        }
        Properties properties = this.loadProperties(awsCredentialsFilename);
        String accessKey = properties.getProperty(ACCESS_KEY_PROPS_NAME);
        String secretKey = properties.getProperty(SECRET_KEY_PROPS_NAME);
        String region = properties.getProperty(REGION_KEY_PROPS_NAME);
        if (AwsSecretsManagerParameterValueProvider.isNotBlank(accessKey) && AwsSecretsManagerParameterValueProvider.isNotBlank(secretKey) && AwsSecretsManagerParameterValueProvider.isNotBlank(region)) {
            return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)region))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)))).build();
        }
        return this.getDefaultClient();
    }

    private SecretsManagerClient getDefaultClient() {
        return (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build())).build();
    }

    private static boolean isNotBlank(String value) {
        return value != null && !value.trim().equals("");
    }
}

