/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAwsSyncProcessor;
import org.apache.nifi.processors.aws.region.RegionUtil;
import org.apache.nifi.processors.aws.s3.AmazonS3EncryptionService;
import org.apache.nifi.processors.aws.s3.S3ClientBuilderWrapper;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

public abstract class AbstractS3Processor
extends AbstractAwsSyncProcessor<S3Client, S3ClientBuilderWrapper> {
    protected static final String OBSOLETE_WRITE_USER_LIST = "Write Permission User List";
    protected static final String OBSOLETE_OWNER = "Owner";
    private static final String OBSOLETE_SIGNER_OVERRIDE = "Signer Override";
    private static final String OBSOLETE_CUSTOM_SIGNER_CLASS_NAME_1 = "custom-signer-class-name";
    private static final String OBSOLETE_CUSTOM_SIGNER_CLASS_NAME_2 = "Custom Signer Class Name";
    private static final String OBSOLETE_CUSTOM_SIGNER_MODULE_LOCATION_1 = "custom-signer-module-location";
    private static final String OBSOLETE_CUSTOM_SIGNER_MODULE_LOCATION_2 = "Custom Signer Module Location";
    private static final String OBSOLETE_ATTRIBUTE_DEFINED_REGION = "attribute-defined-region";
    private static final String OBSOLETE_S3_REGION_ATTRIBUTE = "s3.region";
    public static final PropertyDescriptor FULL_CONTROL_USER_LIST = new PropertyDescriptor.Builder().name("FullControl User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Full Control for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.full.users}").build();
    public static final PropertyDescriptor READ_USER_LIST = new PropertyDescriptor.Builder().name("Read Permission User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Read Access for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.read.users}").build();
    public static final PropertyDescriptor READ_ACL_LIST = new PropertyDescriptor.Builder().name("Read ACL User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to read the Access Control List for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.readacl.users}").build();
    public static final PropertyDescriptor WRITE_ACL_LIST = new PropertyDescriptor.Builder().name("Write ACL User List").description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to change the Access Control List for an object").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.writeacl.users}").build();
    public static final PropertyDescriptor CANNED_ACL = new PropertyDescriptor.Builder().name("Canned ACL").description("Amazon Canned ACL for an object, one of: BucketOwnerFullControl, BucketOwnerRead, AuthenticatedRead, PublicReadWrite, PublicRead, Private; will be ignored if any other ACL/permission/owner property is specified").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${s3.permissions.cannedacl}").build();
    public static final PropertyDescriptor BUCKET_WITHOUT_DEFAULT_VALUE = new PropertyDescriptor.Builder().name("Bucket").description("The S3 Bucket to interact with").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BUCKET_WITH_DEFAULT_VALUE = new PropertyDescriptor.Builder().fromPropertyDescriptor(BUCKET_WITHOUT_DEFAULT_VALUE).defaultValue("${s3.bucket}").build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("Object Key").description("The S3 Object Key to use. This is analogous to a filename for traditional file systems.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${filename}").build();
    public static final PropertyDescriptor VERSION_ID = new PropertyDescriptor.Builder().name("Version").description("The Version of the Object to download").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor ENCRYPTION_SERVICE = new PropertyDescriptor.Builder().name("Encryption Service").description("Specifies the Encryption Service Controller used to configure requests. FetchS3Object: Only needs to be configured in case of Server-side Customer Key encryption.").required(false).identifiesControllerService(AmazonS3EncryptionService.class).build();
    public static final PropertyDescriptor USE_CHUNKED_ENCODING = new PropertyDescriptor.Builder().name("Use Chunked Encoding").description("Enables / disables chunked encoding for upload requests. Set it to false only if your endpoint does not support chunked uploading.").allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor USE_PATH_STYLE_ACCESS = new PropertyDescriptor.Builder().name("Use Path Style Access").description("Path-style access can be enforced by setting this property to true. Set it to true if your endpoint does not support virtual-hosted-style requests, only path-style requests.").allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    private static final Map<String, ObjectCannedACL> CANNED_ACL_MAPPING = Map.of("Private", ObjectCannedACL.PRIVATE, "PublicRead", ObjectCannedACL.PUBLIC_READ, "PublicReadWrite", ObjectCannedACL.PUBLIC_READ_WRITE, "AuthenticatedRead", ObjectCannedACL.AUTHENTICATED_READ, "BucketOwnerRead", ObjectCannedACL.BUCKET_OWNER_READ, "BucketOwnerFullControl", ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL, "AwsExecRead", ObjectCannedACL.AWS_EXEC_READ);
    static final String S3_ENCRYPTION_STRATEGY = "s3.encryptionStrategy";
    static final String S3_SSE_ALGORITHM = "s3.sseAlgorithm";

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("canned-acl", CANNED_ACL.getName());
        config.renameProperty("encryption-service", ENCRYPTION_SERVICE.getName());
        config.renameProperty("use-chunked-encoding", USE_CHUNKED_ENCODING.getName());
        config.renameProperty("use-path-style-access", USE_PATH_STYLE_ACCESS.getName());
        this.migrateAttributeDefinedRegion(config);
        this.migrateCannedAcl(config);
        config.removeProperty(OBSOLETE_SIGNER_OVERRIDE);
        config.removeProperty(OBSOLETE_CUSTOM_SIGNER_CLASS_NAME_1);
        config.removeProperty(OBSOLETE_CUSTOM_SIGNER_CLASS_NAME_2);
        config.removeProperty(OBSOLETE_CUSTOM_SIGNER_MODULE_LOCATION_1);
        config.removeProperty(OBSOLETE_CUSTOM_SIGNER_MODULE_LOCATION_2);
    }

    private void migrateAttributeDefinedRegion(PropertyConfiguration config) {
        if (config.getPropertyValue(RegionUtil.REGION).map(OBSOLETE_ATTRIBUTE_DEFINED_REGION::equals).orElse(false).booleanValue()) {
            config.setProperty(RegionUtil.REGION, RegionUtil.USE_CUSTOM_REGION.getValue());
            config.setProperty(RegionUtil.CUSTOM_REGION, String.format("${%s}", OBSOLETE_S3_REGION_ATTRIBUTE));
        }
    }

    private void migrateCannedAcl(PropertyConfiguration config) {
        if (config.getPropertyValue(CANNED_ACL).map("LogDeliveryWrite"::equals).orElse(false).booleanValue()) {
            config.setProperty(CANNED_ACL, null);
        }
    }

    @Override
    protected S3ClientBuilderWrapper createClientBuilder(ProcessContext context) {
        AmazonS3EncryptionService encryptionService = (AmazonS3EncryptionService)context.getProperty(ENCRYPTION_SERVICE).asControllerService(AmazonS3EncryptionService.class);
        S3ClientBuilderWrapper clientBuilder = Optional.ofNullable(encryptionService).map(AmazonS3EncryptionService::createEncryptionClientBuilder).map(S3ClientBuilderWrapper::new).orElse(new S3ClientBuilderWrapper(S3Client.builder()));
        S3Configuration.Builder configurationBuilder = S3Configuration.builder();
        Boolean useChunkedEncoding = context.getProperty(USE_CHUNKED_ENCODING).asBoolean();
        if (useChunkedEncoding == Boolean.FALSE) {
            configurationBuilder.chunkedEncodingEnabled(Boolean.valueOf(false));
        }
        Boolean usePathStyleAccess = context.getProperty(USE_PATH_STYLE_ACCESS).asBoolean();
        boolean endpointOverrideSet = StringUtils.isNotBlank((CharSequence)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue());
        if (usePathStyleAccess == Boolean.TRUE || endpointOverrideSet) {
            configurationBuilder.pathStyleAccessEnabled(Boolean.valueOf(true));
        }
        clientBuilder.serviceConfiguration((S3Configuration)configurationBuilder.build());
        return clientBuilder;
    }

    protected String getFullControlGranteeSpec(PropertyContext context, FlowFile flowFile) {
        return this.getGranteeSpec(context, flowFile, FULL_CONTROL_USER_LIST);
    }

    protected String getReadGranteeSpec(PropertyContext context, FlowFile flowFile) {
        return this.getGranteeSpec(context, flowFile, READ_USER_LIST);
    }

    protected String getReadACPGranteeSpec(PropertyContext context, FlowFile flowFile) {
        return this.getGranteeSpec(context, flowFile, READ_ACL_LIST);
    }

    protected String getWriteACPGranteeSpec(PropertyContext context, FlowFile flowFile) {
        return this.getGranteeSpec(context, flowFile, WRITE_ACL_LIST);
    }

    private String getGranteeSpec(PropertyContext context, FlowFile flowFile, PropertyDescriptor propertyDescriptor) {
        String value = context.getProperty(propertyDescriptor).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Arrays.stream(value.split(",")).filter(grantee -> !grantee.isBlank()).map(grantee -> {
            if (grantee.contains("@")) {
                return String.format("emailAddress=%s", grantee);
            }
            return String.format("id=%s", grantee);
        }).collect(Collectors.joining(","));
    }

    protected FlowFile extractExceptionDetails(Exception e, ProcessSession session, FlowFile flowFile) {
        flowFile = session.putAttribute(flowFile, "s3.exception", e.getClass().getName());
        if (e instanceof AwsServiceException) {
            AwsServiceException ase = (AwsServiceException)e;
            flowFile = this.putAttribute(session, flowFile, "s3.statusCode", ase.statusCode());
            AwsErrorDetails errorDetails = ase.awsErrorDetails();
            if (errorDetails != null) {
                flowFile = this.putAttribute(session, flowFile, "s3.errorCode", errorDetails.errorCode());
                flowFile = this.putAttribute(session, flowFile, "s3.errorMessage", errorDetails.errorMessage());
                flowFile = this.putAttribute(session, flowFile, "s3.additionalDetails", errorDetails.sdkHttpResponse().headers());
            }
        }
        return flowFile;
    }

    private FlowFile putAttribute(ProcessSession session, FlowFile flowFile, String key, Object value) {
        return value == null ? flowFile : session.putAttribute(flowFile, key, value.toString());
    }

    protected final ObjectCannedACL createCannedACL(ProcessContext context, FlowFile flowFile) {
        if (this.getFullControlGranteeSpec((PropertyContext)context, flowFile) != null || this.getReadGranteeSpec((PropertyContext)context, flowFile) != null || this.getReadACPGranteeSpec((PropertyContext)context, flowFile) != null || this.getWriteACPGranteeSpec((PropertyContext)context, flowFile) != null) {
            return null;
        }
        ObjectCannedACL cannedAcl = null;
        String cannedAclName = context.getProperty(CANNED_ACL).evaluateAttributeExpressions(flowFile).getValue();
        if (!StringUtils.isEmpty((CharSequence)cannedAclName)) {
            cannedAcl = CANNED_ACL_MAPPING.get(cannedAclName);
        }
        return cannedAcl;
    }

    protected void setEncryptionAttributes(Map<String, String> attributes, ServerSideEncryption serverSideEncryption, String customerAlgorithm, AmazonS3EncryptionService encryptionService) {
        if (serverSideEncryption == ServerSideEncryption.AES256) {
            attributes.put(S3_ENCRYPTION_STRATEGY, "SSE_S3");
            attributes.put(S3_SSE_ALGORITHM, serverSideEncryption.toString());
        } else if (serverSideEncryption == ServerSideEncryption.AWS_KMS) {
            attributes.put(S3_ENCRYPTION_STRATEGY, "SSE_KMS");
            attributes.put(S3_SSE_ALGORITHM, serverSideEncryption.toString());
        } else if (customerAlgorithm != null) {
            attributes.put(S3_ENCRYPTION_STRATEGY, "SSE_C");
        } else if (encryptionService != null) {
            attributes.put(S3_ENCRYPTION_STRATEGY, encryptionService.getStrategyName());
        }
    }
}

