/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import java.time.Duration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.AbstractAwsProcessor;
import org.apache.nifi.processors.aws.AwsHttpClientConfigurer;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;

public abstract class AbstractAwsAsyncProcessor<C extends AwsClient, B extends AwsClientBuilder<B, C> & AwsAsyncClientBuilder<B, C>>
extends AbstractAwsProcessor<C, B> {
    @Override
    protected void configureHttpClient(AwsClientBuilder<?, ?> clientBuilder, ProcessContext context) {
        ((AwsAsyncClientBuilder)clientBuilder).httpClient(this.createSdkAsyncHttpClient(clientBuilder, context));
    }

    private <B extends AwsClientBuilder<?, ?>> SdkAsyncHttpClient createSdkAsyncHttpClient(B clientBuilder, ProcessContext context) {
        final NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        AwsHttpClientConfigurer configurer = new AwsHttpClientConfigurer(){

            @Override
            public void configureBasicSettings(Duration communicationsTimeout, int maxConcurrentTasks) {
                builder.connectionTimeout(communicationsTimeout);
                builder.readTimeout(communicationsTimeout);
                builder.maxConcurrency(Integer.valueOf(maxConcurrentTasks));
            }

            @Override
            public void configureTls(TlsTrustManagersProvider trustManagersProvider, TlsKeyManagersProvider keyManagersProvider) {
                builder.tlsTrustManagersProvider(trustManagersProvider);
                builder.tlsKeyManagersProvider(keyManagersProvider);
            }

            @Override
            public void configureProxy(org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration) {
                ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().host(proxyConfiguration.getProxyServerHost()).port(proxyConfiguration.getProxyServerPort().intValue());
                if (proxyConfiguration.hasCredential()) {
                    proxyConfigBuilder.username(proxyConfiguration.getProxyUserName());
                    proxyConfigBuilder.password(proxyConfiguration.getProxyUserPassword());
                }
                builder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
            }
        };
        this.configureSdkHttpClient(context, configurer);
        this.customizeAsyncHttpClientBuilderConfiguration(context, builder, clientBuilder.getClass());
        return builder.build();
    }

    protected void customizeAsyncHttpClientBuilderConfiguration(ProcessContext context, NettyNioAsyncHttpClient.Builder builder, Class<? extends AwsClientBuilder> customizationTargetClass) {
    }
}

