/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.aws.AbstractAwsProcessor;

public class KinesisProcessorUtils {
    public static final int MAX_MESSAGE_SIZE = 1024000;

    private KinesisProcessorUtils() {
    }

    public static List<FlowFile> filterMessagesByMaxSize(ProcessSession session, int batchSize, long maxBufferSizeBytes, String errorMessageAttribute, ComponentLog logger) {
        FlowFile flowFileCandidate;
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>();
        long currentBufferSizeBytes = 0L;
        for (int i = 0; i < batchSize && currentBufferSizeBytes <= maxBufferSizeBytes && (flowFileCandidate = session.get()) != null; ++i) {
            if (flowFileCandidate.getSize() > 1024000L) {
                KinesisProcessorUtils.handleFlowFileTooBig(session, flowFileCandidate, errorMessageAttribute, logger);
                continue;
            }
            currentBufferSizeBytes += flowFileCandidate.getSize();
            flowFiles.add(flowFileCandidate);
        }
        return flowFiles;
    }

    private static void handleFlowFileTooBig(ProcessSession session, FlowFile flowFileCandidate, String message, ComponentLog logger) {
        FlowFile tooBig = session.putAttribute(flowFileCandidate, message, "record too big " + flowFileCandidate.getSize() + " max allowed 1024000");
        session.transfer(tooBig, AbstractAwsProcessor.REL_FAILURE);
        logger.error("Failed to publish to kinesis records {} because the size was greater than {} bytes", new Object[]{tooBig, 1024000});
    }
}

