/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.v2;

import java.net.URI;
import java.time.Duration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.v2.AbstractAwsProcessor;
import org.apache.nifi.processors.aws.v2.AwsHttpClientConfigurer;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public abstract class AbstractAwsSyncProcessor<T extends SdkClient, U extends AwsSyncClientBuilder<U, T> & AwsClientBuilder<U, T>>
extends AbstractAwsProcessor<T> {
    protected abstract U createClientBuilder(ProcessContext var1);

    @Override
    public T createClient(ProcessContext context) {
        return this.createClient(context, this.getRegion(context));
    }

    @Override
    public T createClient(ProcessContext context, Region region) {
        U clientBuilder = this.createClientBuilder(context);
        this.configureClientBuilder(clientBuilder, region, context);
        return (T)((SdkClient)((SdkBuilder)clientBuilder).build());
    }

    @Override
    protected <B extends AwsClientBuilder<?, ?>> void configureHttpClient(B clientBuilder, ProcessContext context) {
        ((AwsSyncClientBuilder)clientBuilder).httpClient(this.createSdkHttpClient(context));
    }

    private SdkHttpClient createSdkHttpClient(final ProcessContext context) {
        final ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        AwsHttpClientConfigurer configurer = new AwsHttpClientConfigurer(){

            @Override
            public void configureBasicSettings(Duration communicationsTimeout, int maxConcurrentTasks) {
                builder.connectionTimeout(communicationsTimeout);
                builder.socketTimeout(communicationsTimeout);
                builder.maxConnections(Integer.valueOf(context.getMaxConcurrentTasks()));
            }

            @Override
            public void configureTls(TlsTrustManagersProvider trustManagersProvider, TlsKeyManagersProvider keyManagersProvider) {
                builder.tlsTrustManagersProvider(trustManagersProvider);
                builder.tlsKeyManagersProvider(keyManagersProvider);
            }

            @Override
            public void configureProxy(org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration) {
                ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxyConfiguration.getProxyServerHost(), proxyConfiguration.getProxyServerPort())));
                if (proxyConfiguration.hasCredential()) {
                    proxyConfigBuilder.username(proxyConfiguration.getProxyUserName());
                    proxyConfigBuilder.password(proxyConfiguration.getProxyUserPassword());
                }
                builder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
            }
        };
        this.configureSdkHttpClient(context, configurer);
        return builder.build();
    }
}

