/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.v2;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderService;
import org.apache.nifi.processors.aws.v2.AwsHttpClientConfigurer;
import org.apache.nifi.processors.aws.v2.RegionUtilV2;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public abstract class AbstractAwsProcessor<T extends SdkClient>
extends AbstractSessionFactoryProcessor
implements VerifiableProcessor {
    private static final String CREDENTIALS_SERVICE_CLASSNAME = "org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderControllerService";
    private static final String OBSOLETE_ACCESS_KEY = "Access Key";
    private static final String OBSOLETE_SECRET_KEY = "Secret Key";
    private static final String OBSOLETE_CREDENTIALS_FILE = "Credentials File";
    private static final String OBSOLETE_PROXY_HOST = "Proxy Host";
    private static final String OBSOLETE_PROXY_PORT = "Proxy Host Port";
    private static final String OBSOLETE_PROXY_USERNAME = "proxy-user-name";
    private static final String OBSOLETE_PROXY_PASSWORD = "proxy-user-password";
    private static final String AUTH_SERVICE_ACCESS_KEY = "Access Key";
    private static final String AUTH_SERVICE_SECRET_KEY = "Secret Key";
    private static final String AUTH_SERVICE_CREDENTIALS_FILE = "Credentials File";
    private static final String AUTH_SERVICE_ANONYMOUS_CREDENTIALS = "anonymous-credentials";
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to success relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to failure relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    public static final PropertyDescriptor REGION = new PropertyDescriptor.Builder().name("Region").required(true).allowableValues((DescribedValue[])RegionUtilV2.getAvailableRegions()).defaultValue(RegionUtilV2.createAllowableValue(Region.US_WEST_2).getValue()).build();
    public static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("Specifies an optional SSL Context Service that, if provided, will be used to create connections").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor ENDPOINT_OVERRIDE = new PropertyDescriptor.Builder().name("Endpoint Override URL").description("Endpoint URL to use instead of the AWS default including scheme, host, port, and path. The AWS libraries select an endpoint URL based on the AWS region, but this property overrides the selected endpoint URL, allowing use with other S3-compatible endpoints.").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("AWS Credentials Provider service").displayName("AWS Credentials Provider Service").description("The Controller Service that is used to obtain AWS credentials provider").required(true).identifiesControllerService(AWSCredentialsProviderService.class).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])new ProxySpec[]{ProxySpec.HTTP, ProxySpec.HTTP_AUTH});
    protected static final String DEFAULT_USER_AGENT = "NiFi";
    private final Cache<Region, T> clientCache = Caffeine.newBuilder().build();

    protected abstract <B extends AwsClientBuilder<?, ?>> void configureHttpClient(B var1, ProcessContext var2);

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        try {
            this.onTrigger(context, session);
            session.commitAsync();
        }
        catch (Throwable t) {
            session.rollback(true);
            throw t;
        }
    }

    public abstract void onTrigger(ProcessContext var1, ProcessSession var2) throws ProcessException;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        this.migrateAuthenticationProperties(config);
        ProxyServiceMigration.migrateProxyProperties((PropertyConfiguration)config, (PropertyDescriptor)PROXY_CONFIGURATION_SERVICE, (String)OBSOLETE_PROXY_HOST, (String)OBSOLETE_PROXY_PORT, (String)OBSOLETE_PROXY_USERNAME, (String)OBSOLETE_PROXY_PASSWORD);
    }

    private void migrateAuthenticationProperties(PropertyConfiguration config) {
        if (!config.isPropertySet(AWS_CREDENTIALS_PROVIDER_SERVICE)) {
            if (config.isPropertySet("Access Key") && config.isPropertySet("Secret Key")) {
                String serviceId = config.createControllerService(CREDENTIALS_SERVICE_CLASSNAME, Map.of("Access Key", (String)config.getRawPropertyValue("Access Key").get(), "Secret Key", (String)config.getRawPropertyValue("Secret Key").get()));
                config.setProperty(AWS_CREDENTIALS_PROVIDER_SERVICE.getName(), serviceId);
            } else if (config.isPropertySet("Credentials File")) {
                String serviceId = config.createControllerService(CREDENTIALS_SERVICE_CLASSNAME, Map.of("Credentials File", (String)config.getRawPropertyValue("Credentials File").get()));
                config.setProperty(AWS_CREDENTIALS_PROVIDER_SERVICE, serviceId);
            } else {
                String serviceId = config.createControllerService(CREDENTIALS_SERVICE_CLASSNAME, Map.of(AUTH_SERVICE_ANONYMOUS_CREDENTIALS, "true"));
                config.setProperty(AWS_CREDENTIALS_PROVIDER_SERVICE, serviceId);
            }
        }
        config.removeProperty("Access Key");
        config.removeProperty("Secret Key");
        config.removeProperty("Credentials File");
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.getClient(context);
    }

    @OnStopped
    public void onStopped() {
        this.clientCache.asMap().values().forEach(SdkAutoCloseable::close);
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try (T ignored = this.createClient(context);){
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Create Client").explanation("Successfully created AWS Client").build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to create AWS Client", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Create Client").explanation("Failed to crete AWS Client: " + e.getMessage()).build());
        }
        return results;
    }

    protected T getClient(ProcessContext context, Region region) {
        return (T)((SdkClient)this.clientCache.get((Object)region, ignored -> this.createClient(context, region)));
    }

    protected T getClient(ProcessContext context) {
        return this.getClient(context, this.getRegion(context));
    }

    protected <C extends SdkClient, B extends AwsClientBuilder<B, C>> void configureClientBuilder(B clientBuilder, Region region, ProcessContext context) {
        this.configureClientBuilder(clientBuilder, region, context, ENDPOINT_OVERRIDE);
    }

    protected <C extends SdkClient, B extends AwsClientBuilder<B, C>> void configureClientBuilder(B clientBuilder, Region region, ProcessContext context, PropertyDescriptor endpointOverrideDescriptor) {
        clientBuilder.overrideConfiguration(builder -> builder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)DEFAULT_USER_AGENT));
        clientBuilder.overrideConfiguration(builder -> builder.retryPolicy(RetryPolicy.none()));
        this.configureHttpClient(clientBuilder, context);
        if (region != null) {
            clientBuilder.region(region);
        }
        this.configureEndpoint(context, (SdkClientBuilder<?, ?>)clientBuilder, endpointOverrideDescriptor);
        AwsCredentialsProvider credentialsProvider = this.getCredentialsProvider(context);
        clientBuilder.credentialsProvider(credentialsProvider);
    }

    protected void configureSdkHttpClient(ProcessContext context, AwsHttpClientConfigurer httpClientConfigurer) {
        ProxyConfiguration proxyConfig;
        SSLContextProvider sslContextProvider;
        int communicationsTimeout = context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        httpClientConfigurer.configureBasicSettings(Duration.ofMillis(communicationsTimeout), context.getMaxConcurrentTasks());
        if (this.getSupportedPropertyDescriptors().contains(SSL_CONTEXT_SERVICE) && (sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class)) != null) {
            TlsKeyManagersProvider keyManagersProvider;
            X509TrustManager trustManager = sslContextProvider.createTrustManager();
            TrustManager[] trustManagers = new TrustManager[]{trustManager};
            TlsTrustManagersProvider trustManagersProvider = () -> trustManagers;
            Optional keyManagerFound = sslContextProvider.createKeyManager();
            if (keyManagerFound.isPresent()) {
                X509ExtendedKeyManager keyManager = (X509ExtendedKeyManager)keyManagerFound.get();
                KeyManager[] keyManagers = new KeyManager[]{keyManager};
                keyManagersProvider = () -> keyManagers;
            } else {
                keyManagersProvider = null;
            }
            httpClientConfigurer.configureTls(trustManagersProvider, keyManagersProvider);
        }
        if (Proxy.Type.HTTP.equals((Object)(proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)context)).getProxyType())) {
            httpClientConfigurer.configureProxy(proxyConfig);
        }
    }

    protected Region getRegion(ProcessContext context) {
        String regionValue;
        Region region = this.getSupportedPropertyDescriptors().contains(REGION) ? ((regionValue = context.getProperty(REGION).getValue()) != null ? Region.of((String)regionValue) : null) : null;
        return region;
    }

    protected void configureEndpoint(ProcessContext context, SdkClientBuilder<?, ?> clientBuilder, PropertyDescriptor endpointOverrideDescriptor) {
        String endpointOverride;
        if (endpointOverrideDescriptor != null && this.getSupportedPropertyDescriptors().contains(endpointOverrideDescriptor) && !(endpointOverride = StringUtils.trimToEmpty((String)context.getProperty(endpointOverrideDescriptor).evaluateAttributeExpressions().getValue())).isEmpty()) {
            this.getLogger().info("Overriding endpoint with {}", new Object[]{endpointOverride});
            clientBuilder.endpointOverride(URI.create(endpointOverride));
        }
    }

    protected AwsCredentialsProvider getCredentialsProvider(ProcessContext context) {
        AWSCredentialsProviderService awsCredentialsProviderService = (AWSCredentialsProviderService)context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AWSCredentialsProviderService.class);
        return awsCredentialsProviderService.getAwsCredentialsProvider();
    }

    protected T createClient(ProcessContext context) {
        return this.createClient(context, this.getRegion(context));
    }

    protected abstract T createClient(ProcessContext var1, Region var2);
}

