/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.v2;

import java.time.Duration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.v2.AbstractAwsProcessor;
import org.apache.nifi.processors.aws.v2.AwsHttpClientConfigurer;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public abstract class AbstractAwsAsyncProcessor<T extends SdkClient, U extends AwsAsyncClientBuilder<U, T> & AwsClientBuilder<U, T>>
extends AbstractAwsProcessor<T> {
    protected abstract U createClientBuilder(ProcessContext var1);

    @Override
    public T createClient(ProcessContext context, Region region) {
        U clientBuilder = this.createClientBuilder(context);
        this.configureClientBuilder(clientBuilder, region, context);
        return (T)((SdkClient)((SdkBuilder)clientBuilder).build());
    }

    @Override
    protected <B extends AwsClientBuilder<?, ?>> void configureHttpClient(B clientBuilder, ProcessContext context) {
        ((AwsAsyncClientBuilder)clientBuilder).httpClient(this.createSdkAsyncHttpClient(clientBuilder, context));
    }

    private <B extends AwsClientBuilder<?, ?>> SdkAsyncHttpClient createSdkAsyncHttpClient(B clientBuilder, ProcessContext context) {
        final NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        AwsHttpClientConfigurer configurer = new AwsHttpClientConfigurer(){

            @Override
            public void configureBasicSettings(Duration communicationsTimeout, int maxConcurrentTasks) {
                builder.connectionTimeout(communicationsTimeout);
                builder.readTimeout(communicationsTimeout);
                builder.maxConcurrency(Integer.valueOf(maxConcurrentTasks));
            }

            @Override
            public void configureTls(TlsTrustManagersProvider trustManagersProvider, TlsKeyManagersProvider keyManagersProvider) {
                builder.tlsTrustManagersProvider(trustManagersProvider);
                builder.tlsKeyManagersProvider(keyManagersProvider);
            }

            @Override
            public void configureProxy(org.apache.nifi.proxy.ProxyConfiguration proxyConfiguration) {
                ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().host(proxyConfiguration.getProxyServerHost()).port(proxyConfiguration.getProxyServerPort().intValue());
                if (proxyConfiguration.hasCredential()) {
                    proxyConfigBuilder.username(proxyConfiguration.getProxyUserName());
                    proxyConfigBuilder.password(proxyConfiguration.getProxyUserPassword());
                }
                builder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
            }
        };
        this.configureSdkHttpClient(context, configurer);
        this.customizeAsyncHttpClientBuilderConfiguration(context, builder, clientBuilder.getClass());
        return builder.build();
    }

    protected void customizeAsyncHttpClientBuilderConfiguration(ProcessContext context, NettyNioAsyncHttpClient.Builder builder, Class<? extends AwsClientBuilder> customizationTargetClass) {
    }
}

