/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlassian.bitbucket;

import org.apache.nifi.components.DescribedValue;

public enum BitbucketAuthenticationType implements DescribedValue
{
    BASIC_AUTH("Basic Auth", "Username (not email) and App Password (https://support.atlassian.com/bitbucket-cloud/docs/app-passwords/).\nRequired permissions: repository, repository:read.\n"),
    ACCESS_TOKEN("Access Token", "Repository, Project or Workspace Token (https://support.atlassian.com/bitbucket-cloud/docs/access-tokens/).\nRequired permissions: repository, repository:read.\n"),
    OAUTH2("OAuth 2.0", "Only works with client credentials flow which requires OAuth consumers\n(https://support.atlassian.com/bitbucket-cloud/docs/use-oauth-on-bitbucket-cloud/).\nOAuth consumer needs to be private, and callback url needs to be set, but can have any value.\nOther OAuth token service fields can be left empty or with default values. It is important to also note that\nthe permissions/scopes set at the OAuth Consumer level are ignored and it will inherit the permissions of the\nowner of the OAuth Consumer.\n");

    private final String displayName;
    private final String description;

    private BitbucketAuthenticationType(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

