/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.distributed.cache.client.exception.DeserializationException;
import org.apache.nifi.distributed.cache.client.exception.SerializationException;

public class MapStringSerDe
implements Serializer<Map<String, String>>,
Deserializer<Map<String, String>> {
    private static final Charset CHARACTER_SET = StandardCharsets.UTF_8;
    private static final Gson GSON = new Gson();
    private static final TypeToken<Map<String, String>> MAP_TYPE_TOKEN = new TypeToken<Map<String, String>>(){};

    public Map<String, String> deserialize(byte[] value) throws DeserializationException, IOException {
        if (value == null || value.length == 0) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(value), CHARACTER_SET);){
            Map map = (Map)GSON.fromJson((Reader)reader, MAP_TYPE_TOKEN);
            return map;
        }
    }

    public void serialize(Map<String, String> value, OutputStream output) throws SerializationException, IOException {
        if (value == null) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(output, CHARACTER_SET);){
            GSON.toJson(value, (Appendable)writer);
        }
    }
}

