/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import com.asana.Json;
import com.asana.models.Resource;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.nifi.processors.asana.utils.AbstractAsanaObjectFetcher;
import org.apache.nifi.processors.asana.utils.AsanaObject;
import org.apache.nifi.processors.asana.utils.AsanaObjectFetcherException;
import org.apache.nifi.processors.asana.utils.AsanaObjectState;

public abstract class GenericAsanaObjectFetcher<T extends Resource>
extends AbstractAsanaObjectFetcher {
    private static final String LAST_FINGERPRINTS = ".lastFingerprints";
    private Map<String, String> lastFingerprints = new HashMap<String, String>();

    @Override
    public AsanaObject fetchNext() {
        AsanaObject result = super.fetchNext();
        if (result != null) {
            if (result.getState().equals((Object)AsanaObjectState.REMOVED)) {
                this.lastFingerprints.remove(result.getGid());
            } else {
                this.lastFingerprints.put(result.getGid(), result.getFingerprint());
            }
        }
        return result;
    }

    @Override
    public Map<String, String> saveState() {
        HashMap<String, String> state = new HashMap<String, String>();
        try {
            state.put(this.getClass().getName() + LAST_FINGERPRINTS, GenericAsanaObjectFetcher.compress(Json.getInstance().toJson(this.lastFingerprints)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return state;
    }

    @Override
    public void loadState(Map<String, String> state) {
        if (state.containsKey(this.getClass().getName() + LAST_FINGERPRINTS)) {
            Type type = new TypeToken<Map<String, String>>(this){}.getType();
            try {
                this.lastFingerprints = (Map)Json.getInstance().fromJson(GenericAsanaObjectFetcher.decompress(state.get(this.getClass().getName() + LAST_FINGERPRINTS)), type);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public void clearState() {
        super.clearState();
        this.lastFingerprints.clear();
    }

    @Override
    protected Iterator<AsanaObject> fetch() {
        final Stream<AsanaObject> currentObjects = this.fetchObjects().map(item -> {
            String payload = this.transformObjectToPayload(item);
            return new AsanaObject(this.lastFingerprints.containsKey(item.gid) ? AsanaObjectState.UPDATED : AsanaObjectState.NEW, item.gid, payload, Optional.ofNullable(this.createObjectFingerprint(item)).orElseGet(() -> this.calculateSecureHash(payload)));
        });
        return new FilterIterator((Iterator)new Iterator<AsanaObject>(){
            Iterator<AsanaObject> it;
            Set<String> unseenIds;
            {
                this.it = currentObjects.iterator();
                this.unseenIds = new HashSet<String>(GenericAsanaObjectFetcher.this.lastFingerprints.keySet());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext() || !this.unseenIds.isEmpty();
            }

            @Override
            public AsanaObject next() {
                if (this.it.hasNext()) {
                    AsanaObject next = this.it.next();
                    this.unseenIds.remove(next.getGid());
                    return next;
                }
                this.it = this.unseenIds.stream().map(gid -> new AsanaObject(AsanaObjectState.REMOVED, (String)gid, Json.getInstance().toJson(gid))).iterator();
                this.unseenIds = Collections.emptySet();
                return this.it.next();
            }
        }, item -> !item.getState().equals((Object)AsanaObjectState.UPDATED) || !this.lastFingerprints.get(item.getGid()).equals(item.getFingerprint()));
    }

    protected String transformObjectToPayload(T object) {
        return Json.getInstance().toJson(object);
    }

    protected String createObjectFingerprint(T object) {
        return null;
    }

    protected abstract Stream<T> fetchObjects();

    private static String compress(String str) throws IOException {
        ByteArrayOutputStream compressedBytes = new ByteArrayOutputStream(str.length());
        try (GZIPOutputStream gzip = new GZIPOutputStream(compressedBytes);){
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        return Base64.getEncoder().encodeToString(compressedBytes.toByteArray());
    }

    private static String decompress(String str) throws IOException {
        ByteArrayOutputStream uncompressedBytes = new ByteArrayOutputStream();
        try (GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(str)));){
            int n;
            byte[] buffer = new byte[1024];
            while ((n = ((InputStream)gzip).read(buffer)) > -1) {
                uncompressedBytes.write(buffer, 0, n);
            }
        }
        return uncompressedBytes.toString(StandardCharsets.UTF_8);
    }

    private String calculateSecureHash(String input) {
        try {
            return Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA-512").digest(input.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AsanaObjectFetcherException(e);
        }
    }
}

