/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import com.asana.models.Project;
import com.asana.models.Section;
import com.asana.models.Task;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.processors.asana.utils.AsanaObjectFetcherException;
import org.apache.nifi.processors.asana.utils.GenericAsanaObjectFetcher;

public class AsanaTaskFetcher
extends GenericAsanaObjectFetcher<Task> {
    private static final String SETTINGS_FINGERPRINT = ".settings.fingerprint";
    private final AsanaClient client;
    private final Project project;
    private final Section section;
    private final String tagName;

    public AsanaTaskFetcher(AsanaClient client, String projectName, String sectionName, String tagName) {
        this.client = client;
        this.project = client.getProjectByName(projectName);
        this.section = Optional.ofNullable(sectionName).map(name -> client.getSectionByName(this.project, name)).orElse(null);
        this.tagName = tagName;
    }

    @Override
    public Map<String, String> saveState() {
        HashMap<String, String> state = new HashMap<String, String>(super.saveState());
        state.put(this.getClass().getName() + SETTINGS_FINGERPRINT, this.createSettingsFingerprint());
        return state;
    }

    @Override
    public void loadState(Map<String, String> state) {
        if (!this.createSettingsFingerprint().equals(state.get(this.getClass().getName() + SETTINGS_FINGERPRINT))) {
            throw new AsanaObjectFetcherException("Settings mismatch.");
        }
        super.loadState(state);
    }

    public Stream<Task> fetchTasks() {
        Stream<Object> result = this.section != null ? this.client.getTasks(this.section) : this.client.getTasks(this.project);
        if (this.tagName != null) {
            Set taskIdsWithTag = this.client.getTags().filter(tag -> tag.name.equals(this.tagName)).flatMap(arg_0 -> ((AsanaClient)this.client).getTasks(arg_0)).map(t -> t.gid).collect(Collectors.toSet());
            result = result.filter(task -> taskIdsWithTag.contains(task.gid));
        }
        return result;
    }

    @Override
    protected Stream<Task> fetchObjects() {
        return this.fetchTasks();
    }

    @Override
    protected String createObjectFingerprint(Task object) {
        return Long.toString(object.modifiedAt.getValue());
    }

    private String createSettingsFingerprint() {
        return String.join((CharSequence)":", Arrays.asList(Optional.ofNullable(this.project).map(p -> p.gid).orElse(""), Optional.ofNullable(this.section).map(s -> s.gid).orElse(""), Optional.ofNullable(this.tagName).orElse("")));
    }
}

