/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import com.asana.models.Attachment;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.processors.asana.utils.AsanaTaskFetcher;
import org.apache.nifi.processors.asana.utils.GenericAsanaObjectFetcher;

public class AsanaTaskAttachmentFetcher
extends GenericAsanaObjectFetcher<Attachment> {
    private final AsanaClient client;
    private final AsanaTaskFetcher taskFetcher;

    public AsanaTaskAttachmentFetcher(AsanaClient client, String projectName, String sectionName, String tagName) {
        this.client = client;
        this.taskFetcher = new AsanaTaskFetcher(client, projectName, sectionName, tagName);
    }

    @Override
    public Map<String, String> saveState() {
        HashMap<String, String> state = new HashMap<String, String>();
        state.putAll(this.taskFetcher.saveState());
        state.putAll(super.saveState());
        return state;
    }

    @Override
    public void loadState(Map<String, String> state) {
        this.taskFetcher.loadState(state);
        super.loadState(state);
    }

    @Override
    protected Stream<Attachment> fetchObjects() {
        return this.fetchTaskAttachments();
    }

    @Override
    protected String createObjectFingerprint(Attachment object) {
        return Long.toString(object.createdAt.getValue());
    }

    private Stream<Attachment> fetchTaskAttachments() {
        return this.taskFetcher.fetchTasks().flatMap(arg_0 -> ((AsanaClient)this.client).getAttachments(arg_0));
    }
}

