/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import com.asana.models.Attachment;
import com.asana.models.Project;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.processors.asana.utils.AsanaObjectFetcherException;
import org.apache.nifi.processors.asana.utils.GenericAsanaObjectFetcher;

public class AsanaProjectStatusAttachmentFetcher
extends GenericAsanaObjectFetcher<Attachment> {
    private static final String PROJECT_GID = ".project.gid";
    private final AsanaClient client;
    private final Project project;

    public AsanaProjectStatusAttachmentFetcher(AsanaClient client, String projectName) {
        this.client = client;
        this.project = client.getProjectByName(projectName);
    }

    @Override
    public Map<String, String> saveState() {
        HashMap<String, String> state = new HashMap<String, String>(super.saveState());
        state.put(this.getClass().getName() + PROJECT_GID, this.project.gid);
        return state;
    }

    @Override
    public void loadState(Map<String, String> state) {
        if (!this.project.gid.equals(state.get(this.getClass().getName() + PROJECT_GID))) {
            throw new AsanaObjectFetcherException("Project gid does not match.");
        }
        super.loadState(state);
    }

    @Override
    protected Stream<Attachment> fetchObjects() {
        return this.fetchProjectStatusAttachments();
    }

    @Override
    protected String createObjectFingerprint(Attachment object) {
        return Long.toString(object.createdAt.getValue());
    }

    private Stream<Attachment> fetchProjectStatusAttachments() {
        return this.client.getProjectStatusUpdates(this.project).flatMap(arg_0 -> ((AsanaClient)this.client).getAttachments(arg_0));
    }
}

