/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.nifi.logging.ComponentLog;

abstract class AMQPWorker
implements AutoCloseable {
    protected final ComponentLog processorLog;
    private final Channel channel;
    protected volatile boolean closed = false;

    public AMQPWorker(Connection connection, ComponentLog processorLog) {
        this.processorLog = processorLog;
        this.validateConnection(connection);
        try {
            this.channel = connection.createChannel();
        }
        catch (IOException e) {
            processorLog.error("Failed to create Channel for {}", new Object[]{connection, e});
            throw new IllegalStateException(e);
        }
    }

    protected Channel getChannel() {
        return this.channel;
    }

    @Override
    public void close() throws TimeoutException, IOException {
        if (this.closed) {
            return;
        }
        if (this.channel.isOpen()) {
            if (this.processorLog.isDebugEnabled()) {
                this.processorLog.debug("Closing AMQP channel for {}", new Object[]{this.channel.getConnection()});
            }
            this.channel.close();
        }
        this.closed = true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.channel.getConnection().toString();
    }

    void validateStringProperty(String propertyName, String value) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException("'" + propertyName + "' must not be null or empty");
        }
    }

    private void validateConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("'connection' must not be null!");
        }
        if (!connection.isOpen()) {
            throw new IllegalStateException("'connection' must be open!");
        }
    }
}

