/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.airtable.parse;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.airtable.parse.AirtableTableRetriever;

public class AirtableRecordSetFlowFileWriter {
    private final FlowFile flowFile;
    private final JsonGenerator jsonGenerator;
    private int recordCount = 0;

    private AirtableRecordSetFlowFileWriter(FlowFile flowFile, JsonGenerator jsonGenerator) {
        this.flowFile = flowFile;
        this.jsonGenerator = jsonGenerator;
    }

    public static AirtableRecordSetFlowFileWriter startRecordSet(ProcessSession session) throws IOException {
        FlowFile flowFile = session.create();
        JsonGenerator jsonGenerator = AirtableTableRetriever.JSON_FACTORY.createGenerator(session.write(flowFile));
        jsonGenerator.writeStartArray();
        return new AirtableRecordSetFlowFileWriter(flowFile, jsonGenerator);
    }

    public void writeRecord(JsonParser jsonParser) throws IOException {
        ++this.recordCount;
        this.jsonGenerator.copyCurrentStructure(jsonParser);
    }

    public FlowFile closeRecordSet(ProcessSession session) throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.close();
        FlowFile flowFileWithAttributes = session.putAttribute(this.flowFile, "record.count", String.valueOf(this.recordCount));
        flowFileWithAttributes = session.putAttribute(flowFileWithAttributes, CoreAttributes.MIME_TYPE.key(), "application/json");
        return flowFileWithAttributes;
    }

    public int getRecordCount() {
        return this.recordCount;
    }
}

