/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import org.apache.nifi.c2.protocol.api.FailureCause;

public class C2OperationState
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="State of the operation performed", example="FULLY_APPLIED")
    private OperationState state;
    @Schema(description="Additional details about the state")
    private String details;
    @Schema(description="Additional details about the cause of the failure")
    private FailureCause failureCause;

    public FailureCause getFailureCause() {
        return this.failureCause;
    }

    public void setFailureCause(FailureCause failureCause) {
        this.failureCause = failureCause;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public OperationState getState() {
        return this.state;
    }

    public void setState(OperationState state) {
        this.state = state;
    }

    public void setStateFromOrdinal(int state) {
        this.state = OperationState.fromOrdinal(state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        C2OperationState that = (C2OperationState)o;
        return this.state == that.state && Objects.equals(this.details, that.details) && Objects.equals(this.failureCause, that.failureCause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.details, this.failureCause});
    }

    public String toString() {
        return "C2OperationState{state=" + String.valueOf((Object)this.state) + ", details='" + this.details + "', failureCause='" + String.valueOf(this.failureCause) + "'}";
    }

    public static enum OperationState {
        FULLY_APPLIED,
        PARTIALLY_APPLIED,
        OPERATION_NOT_UNDERSTOOD,
        NO_OPERATION,
        NOT_APPLIED;


        public static OperationState fromOrdinal(int state) {
            return switch (state) {
                case 0 -> FULLY_APPLIED;
                case 1 -> PARTIALLY_APPLIED;
                case 2 -> OPERATION_NOT_UNDERSTOOD;
                case 3 -> NO_OPERATION;
                default -> NOT_APPLIED;
            };
        }

        public static int toOrdinal(OperationState state) {
            return switch (state.ordinal()) {
                case 0 -> 0;
                case 1 -> 1;
                case 2 -> 2;
                case 3 -> 3;
                default -> 4;
            };
        }
    }
}

