/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import org.apache.nifi.c2.protocol.api.ResourceType;

public class ResourceItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String resourceId;
    private String resourceName;
    private ResourceType resourceType;
    private String resourcePath;
    private String digest;
    private String hashType;
    private String url;

    @Schema(description="The identifier of the resource to be synced")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Schema(description="The name of the asset to be synced")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Schema(description="The type of the asset to be synced")
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    @Schema(description="The relative path of the asset on the agent")
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Schema(description="The checksum hash value calculated for the particular asset")
    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    @Schema(description="The type of the hashing algorithm used to calculate the checksum")
    public String getHashType() {
        return this.hashType;
    }

    public void setHashType(String hashType) {
        this.hashType = hashType;
    }

    @Schema(description="The relative url of the asset, from where the agent can download from")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceItem that = (ResourceItem)o;
        return Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.resourceName, that.resourceName) && Objects.equals((Object)this.resourceType, (Object)that.resourceType) && Objects.equals(this.resourcePath, that.resourcePath) && Objects.equals(this.digest, that.digest) && Objects.equals(this.hashType, that.hashType) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceId, this.resourceName, this.resourceType, this.resourcePath, this.digest, this.hashType, this.url});
    }

    public String toString() {
        return "ResourceItem{resourceId='" + this.resourceId + "', resourceName='" + this.resourceName + "', resourceType=" + String.valueOf((Object)this.resourceType) + ", resourcePath='" + this.resourcePath + "', digest='" + this.digest + "', hashType='" + this.hashType + "', url='" + this.url + "'}";
    }
}

