/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.c2.protocol.api.OperandType;

public enum OperationType {
    ACKNOWLEDGE(new OperandType[0]),
    HEARTBEAT(new OperandType[0]),
    CLEAR(OperandType.CONNECTION),
    DESCRIBE(OperandType.MANIFEST),
    UPDATE(OperandType.CONFIGURATION, OperandType.ASSET, OperandType.PROPERTIES),
    RESTART(new OperandType[0]),
    START(OperandType.FLOW, OperandType.PROCESSOR),
    STOP(OperandType.FLOW, OperandType.PROCESSOR),
    PAUSE(new OperandType[0]),
    REPLICATE(new OperandType[0]),
    SUBSCRIBE(new OperandType[0]),
    SYNC(OperandType.RESOURCE),
    TRANSFER(OperandType.DEBUG);

    private final Set<OperandType> supportedOperands;

    private OperationType(OperandType ... supportedOperands) {
        this.supportedOperands = Arrays.stream(supportedOperands).collect(Collectors.toSet());
    }

    public boolean isSupportedOperand(OperandType operand) {
        return this.supportedOperands.contains((Object)operand);
    }
}

