/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.c2.client.api.C2Client;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.OperandPropertiesProvider;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.apache.nifi.c2.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDebugOperationHandler
implements C2OperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TransferDebugOperationHandler.class);
    private static final String C2_CALLBACK_URL_NOT_FOUND = "C2 Server callback URL was not found in request";
    private static final String SUCCESSFUL_UPLOAD = "Debug bundle was uploaded successfully";
    private static final String UNABLE_TO_CREATE_BUNDLE = "Unable to create debug bundle";
    static final String TARGET_ARG = "target";
    static final String RELATIVE_TARGET_ARG = "relativeTarget";
    static final String NEW_LINE = "\n";
    private final C2Client c2Client;
    private final OperandPropertiesProvider operandPropertiesProvider;
    private final List<Path> bundleFilePaths;
    private final Predicate<String> contentFilter;

    private TransferDebugOperationHandler(C2Client c2Client, OperandPropertiesProvider operandPropertiesProvider, List<Path> bundleFilePaths, Predicate<String> contentFilter) {
        this.c2Client = c2Client;
        this.operandPropertiesProvider = operandPropertiesProvider;
        this.bundleFilePaths = bundleFilePaths;
        this.contentFilter = contentFilter;
    }

    public static TransferDebugOperationHandler create(C2Client c2Client, OperandPropertiesProvider operandPropertiesProvider, List<Path> bundleFilePaths, Predicate<String> contentFilter) {
        Preconditions.requires((c2Client != null ? 1 : 0) != 0, (String)"C2Client should not be null");
        Preconditions.requires((operandPropertiesProvider != null ? 1 : 0) != 0, (String)"OperandPropertiesProvider should not be not null");
        Preconditions.requires((bundleFilePaths != null && !bundleFilePaths.isEmpty() ? 1 : 0) != 0, (String)"BundleFilePaths should not be not null or empty");
        Preconditions.requires((contentFilter != null ? 1 : 0) != 0, (String)"Content filter should not be null");
        return new TransferDebugOperationHandler(c2Client, operandPropertiesProvider, bundleFilePaths, contentFilter);
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.TRANSFER;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.DEBUG;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.operandPropertiesProvider.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C2OperationAck handle(C2Operation operation) {
        C2OperationState operationState;
        String callbackUrl;
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        try {
            callbackUrl = this.c2Client.getCallbackUrl(this.getOperationArg(operation, TARGET_ARG).orElse(""), this.getOperationArg(operation, RELATIVE_TARGET_ARG).orElse(""));
        }
        catch (Exception e) {
            LOG.error("Callback URL could not be constructed from C2 request and current configuration");
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, C2_CALLBACK_URL_NOT_FOUND, e));
        }
        List<Path> preparedFiles = null;
        try {
            preparedFiles = this.prepareFiles(operationId, this.bundleFilePaths);
            operationState = this.createDebugBundle(preparedFiles).map(bundle -> this.c2Client.uploadBundle(callbackUrl, bundle).map(errorMessage -> this.operationState(C2OperationState.OperationState.NOT_APPLIED, (String)errorMessage)).orElseGet(() -> this.operationState(C2OperationState.OperationState.FULLY_APPLIED, SUCCESSFUL_UPLOAD))).orElseGet(() -> this.operationState(C2OperationState.OperationState.NOT_APPLIED, UNABLE_TO_CREATE_BUNDLE));
        }
        catch (Exception e) {
            LOG.error("Unexpected error happened", (Throwable)e);
            operationState = this.operationState(C2OperationState.OperationState.NOT_APPLIED, UNABLE_TO_CREATE_BUNDLE);
        }
        finally {
            Optional.ofNullable(preparedFiles).ifPresent(this::cleanup);
        }
        LOG.debug("Returning operation ack for operation {} with state {} and details {}", new Object[]{operation.getIdentifier(), operationState.getState(), operationState.getDetails()});
        return this.operationAck(operationId, operationState);
    }

    private List<Path> prepareFiles(String operationId, List<Path> bundleFilePaths) throws IOException {
        ArrayList<Path> preparedFiles = new ArrayList<Path>();
        for (Path bundleFile : bundleFilePaths) {
            Path tempDirectory = Files.createTempDirectory(operationId, new FileAttribute[0]);
            String fileName = bundleFile.getFileName().toString();
            Path preparedFile = GzipUtils.isCompressedFileName((String)fileName) ? this.handleGzipFile(bundleFile, Paths.get(tempDirectory.toAbsolutePath().toString(), GzipUtils.getUncompressedFileName((String)fileName))) : this.handleUncompressedFile(bundleFile, Paths.get(tempDirectory.toAbsolutePath().toString(), fileName));
            preparedFiles.add(preparedFile);
        }
        return preparedFiles;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Path handleGzipFile(Path sourceFile, Path targetFile) throws IOException {
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(sourceFile.toFile()));){
            Path path;
            try (FileOutputStream fileOutputStream = new FileOutputStream(targetFile.toFile());){
                gzipInputStream.transferTo(fileOutputStream);
                path = targetFile;
            }
            return path;
        }
        catch (IOException e) {
            LOG.error("Error during filtering gzip file content: {}", (Object)sourceFile.toAbsolutePath(), (Object)e);
            throw e;
        }
    }

    private Path handleUncompressedFile(Path sourceFile, Path targetFile) throws IOException {
        Path path;
        block8: {
            Stream<String> fileStream = Files.lines(sourceFile, Charset.defaultCharset());
            try {
                Files.write(targetFile, fileStream.filter(this.contentFilter)::iterator, new OpenOption[0]);
                path = targetFile;
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Error during filtering uncompressed file content: {}", (Object)sourceFile.toAbsolutePath(), (Object)e);
                    throw e;
                }
            }
            fileStream.close();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<byte[]> createDebugBundle(List<Path> filePaths) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (GzipCompressorOutputStream gzipCompressorOutputStream = new GzipCompressorOutputStream((OutputStream)byteOutputStream);
             TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream((OutputStream)gzipCompressorOutputStream);){
            for (Path filePath : filePaths) {
                tarOutputStream.setBigNumberMode(2);
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(filePath.toFile(), filePath.getFileName().toString());
                tarOutputStream.putArchiveEntry(tarArchiveEntry);
                Files.copy(filePath, (OutputStream)tarOutputStream);
                tarOutputStream.closeArchiveEntry();
            }
            tarOutputStream.finish();
        }
        catch (Exception e) {
            LOG.error("Error during create compressed bundle", (Throwable)e);
            Optional<byte[]> optional = Optional.empty();
            return optional;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)byteOutputStream);
        }
        return Optional.of(byteOutputStream).map(ByteArrayOutputStream::toByteArray);
    }

    private void cleanup(List<Path> paths) {
        paths.stream().findFirst().map(Path::getParent).ifPresent(basePath -> {
            try (Stream<Path> walk = Files.walk(basePath, new FileVisitOption[0]);){
                walk.map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                LOG.warn("Unable to clean up temporary directory {}", basePath, (Object)e);
            }
        });
    }
}

