/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.ProcessorStateStrategy;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;

public class StopProcessorOperationHandler
implements C2OperationHandler {
    public static final String PROCESSOR_ID_ARG = "processorId";
    public static final String NOT_APPLIED_DETAILS = "Failed to stop processor (not found)";
    public static final String FULLY_APPLIED_DETAILS = "Processor stopped";
    public static final String PARTIALLY_APPLIED_DETAILS = "Processor stop partially applied";
    private final ProcessorStateStrategy processorStateStrategy;

    public StopProcessorOperationHandler(ProcessorStateStrategy processorStateStrategy) {
        this.processorStateStrategy = processorStateStrategy;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.STOP;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.PROCESSOR;
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public C2OperationAck handle(C2Operation operation) {
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        String processorId = Optional.ofNullable(operation.getArgs()).map(a -> a.get(PROCESSOR_ID_ARG)).map(Object::toString).orElse(null);
        C2OperationState.OperationState opState = processorId == null ? C2OperationState.OperationState.NOT_APPLIED : this.processorStateStrategy.stopProcessor(processorId);
        String details = switch (opState) {
            case C2OperationState.OperationState.NOT_APPLIED -> NOT_APPLIED_DETAILS;
            case C2OperationState.OperationState.FULLY_APPLIED -> FULLY_APPLIED_DETAILS;
            case C2OperationState.OperationState.PARTIALLY_APPLIED -> PARTIALLY_APPLIED_DETAILS;
            default -> PARTIALLY_APPLIED_DETAILS;
        };
        return this.operationAck(operationId, this.operationState(opState, details));
    }
}

